/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class OpenSecureChannelResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=447");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=449");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=448");
    private final ResponseHeader responseHeader;
    private final UInteger serverProtocolVersion;
    private final ChannelSecurityToken securityToken;
    private final ByteString serverNonce;

    public OpenSecureChannelResponse(ResponseHeader responseHeader, UInteger serverProtocolVersion, ChannelSecurityToken securityToken, ByteString serverNonce) {
        this.responseHeader = responseHeader;
        this.serverProtocolVersion = serverProtocolVersion;
        this.securityToken = securityToken;
        this.serverNonce = serverNonce;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public UInteger getServerProtocolVersion() {
        return this.serverProtocolVersion;
    }

    public ChannelSecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public ByteString getServerNonce() {
        return this.serverNonce;
    }

    protected OpenSecureChannelResponse(OpenSecureChannelResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((OpenSecureChannelResponseBuilder)b).responseHeader;
        this.serverProtocolVersion = ((OpenSecureChannelResponseBuilder)b).serverProtocolVersion;
        this.securityToken = ((OpenSecureChannelResponseBuilder)b).securityToken;
        this.serverNonce = ((OpenSecureChannelResponseBuilder)b).serverNonce;
    }

    public static OpenSecureChannelResponseBuilder<?, ?> builder() {
        return new OpenSecureChannelResponseBuilderImpl();
    }

    public OpenSecureChannelResponseBuilder<?, ?> toBuilder() {
        return new OpenSecureChannelResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSecureChannelResponse)) {
            return false;
        }
        OpenSecureChannelResponse other = (OpenSecureChannelResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        UInteger this$serverProtocolVersion = this.getServerProtocolVersion();
        UInteger other$serverProtocolVersion = other.getServerProtocolVersion();
        if (this$serverProtocolVersion == null ? other$serverProtocolVersion != null : !((Object)this$serverProtocolVersion).equals(other$serverProtocolVersion)) {
            return false;
        }
        ChannelSecurityToken this$securityToken = this.getSecurityToken();
        ChannelSecurityToken other$securityToken = other.getSecurityToken();
        if (this$securityToken == null ? other$securityToken != null : !((Object)this$securityToken).equals(other$securityToken)) {
            return false;
        }
        ByteString this$serverNonce = this.getServerNonce();
        ByteString other$serverNonce = other.getServerNonce();
        return !(this$serverNonce == null ? other$serverNonce != null : !((Object)this$serverNonce).equals(other$serverNonce));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenSecureChannelResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        UInteger $serverProtocolVersion = this.getServerProtocolVersion();
        result = result * 59 + ($serverProtocolVersion == null ? 43 : ((Object)$serverProtocolVersion).hashCode());
        ChannelSecurityToken $securityToken = this.getSecurityToken();
        result = result * 59 + ($securityToken == null ? 43 : ((Object)$securityToken).hashCode());
        ByteString $serverNonce = this.getServerNonce();
        result = result * 59 + ($serverNonce == null ? 43 : ((Object)$serverNonce).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OpenSecureChannelResponse(responseHeader=" + this.getResponseHeader() + ", serverProtocolVersion=" + this.getServerProtocolVersion() + ", securityToken=" + this.getSecurityToken() + ", serverNonce=" + this.getServerNonce() + ")";
    }

    private static final class OpenSecureChannelResponseBuilderImpl
    extends OpenSecureChannelResponseBuilder<OpenSecureChannelResponse, OpenSecureChannelResponseBuilderImpl> {
        private OpenSecureChannelResponseBuilderImpl() {
        }

        @Override
        protected OpenSecureChannelResponseBuilderImpl self() {
            return this;
        }

        @Override
        public OpenSecureChannelResponse build() {
            return new OpenSecureChannelResponse(this);
        }
    }

    public static abstract class OpenSecureChannelResponseBuilder<C extends OpenSecureChannelResponse, B extends OpenSecureChannelResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private UInteger serverProtocolVersion;
        private ChannelSecurityToken securityToken;
        private ByteString serverNonce;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OpenSecureChannelResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(OpenSecureChannelResponse instance, OpenSecureChannelResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.serverProtocolVersion(instance.serverProtocolVersion);
            b.securityToken(instance.securityToken);
            b.serverNonce(instance.serverNonce);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B serverProtocolVersion(UInteger serverProtocolVersion) {
            this.serverProtocolVersion = serverProtocolVersion;
            return (B)this.self();
        }

        public B securityToken(ChannelSecurityToken securityToken) {
            this.securityToken = securityToken;
            return (B)this.self();
        }

        public B serverNonce(ByteString serverNonce) {
            this.serverNonce = serverNonce;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "OpenSecureChannelResponse.OpenSecureChannelResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", serverProtocolVersion=" + this.serverProtocolVersion + ", securityToken=" + this.securityToken + ", serverNonce=" + this.serverNonce + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<OpenSecureChannelResponse> {
        @Override
        public Class<OpenSecureChannelResponse> getType() {
            return OpenSecureChannelResponse.class;
        }

        @Override
        public OpenSecureChannelResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            UInteger serverProtocolVersion = decoder.readUInt32("ServerProtocolVersion");
            ChannelSecurityToken securityToken = (ChannelSecurityToken)decoder.readStruct("SecurityToken", ChannelSecurityToken.TYPE_ID);
            ByteString serverNonce = decoder.readByteString("ServerNonce");
            return new OpenSecureChannelResponse(responseHeader, serverProtocolVersion, securityToken, serverNonce);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, OpenSecureChannelResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeUInt32("ServerProtocolVersion", value.getServerProtocolVersion());
            encoder.writeStruct("SecurityToken", (Object)value.getSecurityToken(), ChannelSecurityToken.TYPE_ID);
            encoder.writeByteString("ServerNonce", value.getServerNonce());
        }
    }
}

