/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.ResDevFBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DEVImporter
extends TypeImporter {
    public DEVImporter(IFile typeFile) {
        super(typeFile);
    }

    public DEVImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    @Override
    public DeviceType getElement() {
        return (DeviceType)super.getElement();
    }

    @Override
    protected LibraryElement createRootModelElement() {
        return LibraryElementFactory.eINSTANCE.createDeviceType();
    }

    @Override
    protected String getStartElementName() {
        return "DeviceType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "VarDeclaration": {
                    VarDeclaration v = this.parseVarDeclaration();
                    v.setIsInput(true);
                    this.getElement().getVarDeclaration().add((Object)v);
                    break;
                }
                case "Resource": {
                    this.getElement().getResource().add((Object)this.parseResource(new HashMap<String, FBNetworkElement>()));
                    break;
                }
                case "FBNetwork": {
                    ResDevFBNetworkImporter resNetworkImporter = new ResDevFBNetworkImporter((CommonElementImporter)this, this.getElement().getVarDeclaration());
                    this.getElement().setFBNetwork(resNetworkImporter.getFbNetwork());
                    resNetworkImporter.parseFBNetwork("FBNetwork");
                    break;
                }
                case "Attribute": {
                    this.parseDeviceTypeAttribute();
                    break;
                }
                default: {
                    return false;
                }
                case "ResourceTypeName": 
            }
            return true;
        };
    }

    public static List<String> getReferencedTypes(File file) {
        ArrayList<String> references = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(file);
            Element rootNode = document.getDocumentElement();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Resource")) {
                    String type = "";
                    type = n.getAttributes().getNamedItem("Type").getNodeValue();
                    references.add(type);
                }
                ++i;
            }
        }
        catch (Exception e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        return references;
    }

    private void parseDeviceTypeAttribute() {
        if (this.isProfileAttribute()) {
            this.parseProfile();
        }
    }

    private void parseProfile() {
        String value = this.getAttributeValue("Value");
        if (value != null) {
            this.getElement().setProfile(value);
        }
    }
}

