/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyFactory;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.AbstractChangeHierarchyOperation;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class CreateLeafOperation
extends AbstractChangeHierarchyOperation {
    private final Level parent;
    private final SubApp subapp;
    private Leaf newLeaf;

    public CreateLeafOperation(Level parent, SubApp subapp) {
        super("Create leaf");
        this.parent = parent;
        this.subapp = subapp;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.newLeaf = HierarchyFactory.eINSTANCE.createLeaf();
        this.newLeaf.setRef(this.subapp.getQualifiedName());
        this.newLeaf.setContainerFileName(this.getFileName());
        this.parent.getChildren().add((Object)this.newLeaf);
        CreateLeafOperation.saveHierarchy((EObject)this.parent, monitor);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.parent.getChildren().add((Object)this.newLeaf);
        CreateLeafOperation.saveHierarchy((EObject)this.parent, monitor);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.parent.getChildren().remove((Object)this.newLeaf);
        CreateLeafOperation.saveHierarchy((EObject)this.parent, monitor);
        return Status.OK_STATUS;
    }

    private String getFileName() {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)this.subapp);
        if (rootContainer instanceof LibraryElement) {
            LibraryElement libEl = (LibraryElement)rootContainer;
            return libEl.getTypeEntry().getFile().getProjectRelativePath().toPortableString();
        }
        return "";
    }
}

