/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.util;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class DeploymentHelper {
    public static final String MGR_ID = "MGR_ID";
    private static final String NEGATED_CONNECTION_SUFFIX = ".NOT";

    public static String getVariableValue(VarDeclaration varDecl) throws DeploymentException {
        if (VariableOperations.hasDeclaredInitialValue((VarDeclaration)varDecl)) {
            try {
                return VariableOperations.newVariable((VarDeclaration)varDecl).toString(false);
            }
            catch (Exception e) {
                if (DeploymentHelper.forceDeployement()) {
                    return varDecl.getValue().getValue();
                }
                throw new DeploymentException(MessageFormat.format(Messages.DeploymentHelper_VariableValueError, varDecl.getValue().getValue(), varDecl.getQualifiedName(), e.getMessage()), e);
            }
        }
        return null;
    }

    public static String getVariableValue(VarDeclaration source, VarDeclaration destination, boolean negate) throws DeploymentException {
        if (source != destination || VariableOperations.hasDeclaredInitialValue((VarDeclaration)source)) {
            Value value;
            block6: {
                try {
                    value = VariableOperations.newVariable((VarDeclaration)source).getValue();
                    if (negate) {
                        value = ValueOperations.bitwiseNot((Value)value);
                    }
                    if (IecTypes.GenericTypes.isAnyType((DataType)destination.getType()) || !DeploymentHelper.equalsTypeValue(value, destination)) break block6;
                    return null;
                }
                catch (Exception e) {
                    if (DeploymentHelper.forceDeployement()) {
                        return source.getValue().getValue();
                    }
                    throw new DeploymentException(MessageFormat.format(Messages.DeploymentHelper_VariableValueError, source.getValue().getValue(), destination.getQualifiedName(), e.getMessage()), e);
                }
            }
            return VariableOperations.newVariable((VarDeclaration)destination, (Value)value).toString(false);
        }
        return null;
    }

    private static boolean equalsTypeValue(Value value, VarDeclaration variable) {
        VarDeclaration typeVariable = variable.findInTypeInterface();
        if (typeVariable == null) {
            return false;
        }
        Value destinationTypeValue = VariableOperations.newVariable((VarDeclaration)typeVariable).getValue();
        return ValueOperations.equals((Value)value, (Value)destinationTypeValue);
    }

    public static String getSourceSuffix(Connection conn) {
        if (conn.isNegated()) {
            return NEGATED_CONNECTION_SUFFIX;
        }
        return "";
    }

    public static void addSourceSuffix(StringBuilder suffix, Connection conn) {
        DeploymentHelper.toggleNegatedSourceSuffix(suffix, conn);
    }

    public static void removeSourceSuffix(StringBuilder suffix, Connection conn) {
        DeploymentHelper.toggleNegatedSourceSuffix(suffix, conn);
    }

    private static void toggleNegatedSourceSuffix(StringBuilder suffix, Connection conn) {
        if (conn.isNegated()) {
            if (suffix.indexOf(NEGATED_CONNECTION_SUFFIX) == 0) {
                suffix.delete(0, NEGATED_CONNECTION_SUFFIX.length());
            } else {
                suffix.insert(0, NEGATED_CONNECTION_SUFFIX);
            }
        }
    }

    public static String getMgrID(Device dev) throws DeploymentException {
        for (VarDeclaration varDecl : dev.getVarDeclarations()) {
            String val;
            if (!MGR_ID.equalsIgnoreCase(varDecl.getName()) || (val = DeploymentHelper.getVariableValue(varDecl)) == null) continue;
            return val;
        }
        return "";
    }

    public static String getMgrIDSafe(Device dev) {
        try {
            return DeploymentHelper.getMgrID(dev);
        }
        catch (DeploymentException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
            return "";
        }
    }

    private static boolean forceDeployement() {
        if (ForceDeploymentHelper.forceDeployment == null) {
            String[] args;
            ForceDeploymentHelper.forceDeployment = Boolean.FALSE;
            String[] stringArray = args = Platform.getCommandLineArgs();
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if ("-forceDeployment".equals(arg)) {
                    ForceDeploymentHelper.forceDeployment = Boolean.TRUE;
                    break;
                }
                ++n2;
            }
        }
        return ForceDeploymentHelper.forceDeployment;
    }

    private DeploymentHelper() {
        throw new UnsupportedOperationException();
    }

    private static class ForceDeploymentHelper {
        private static Boolean forceDeployment = null;

        private ForceDeploymentHelper() {
        }
    }
}

