/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffInput;
import org.eclipse.egit.ui.internal.history.FileDiffLabelProvider;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.themes.ColorUtil;

public class CommitFileDiffViewer
extends TableViewer {
    public static final String POPUP_ID = "org.eclipse.egit.ui.fileDiffContributions";
    public static final String GROUP_ID = "fileDiff.group";
    static final int INTERESTING_MARK_TREE_FILTER_INDEX = 0;
    private static final String LINESEP = System.lineSeparator();
    private Clipboard clipboard;
    private IAction selectAll;
    private IAction copy;
    private IAction copyAll;
    private IAction showInHistory;
    private FileDiffInput realInput;
    private FileDiffLoader loader;
    private MenuManager menuManager;

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site) {
        this(parent, site, 268503810);
    }

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site, int style) {
        super(parent, style);
        this.setUseHashlookup(true);
        Table rawTable = this.getTable();
        Color fg = rawTable.getForeground();
        Color bg = rawTable.getBackground();
        RGB dimmedForegroundRgb = ColorUtil.blend((RGB)fg.getRGB(), (RGB)bg.getRGB(), (int)60);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.setLabelProvider((IBaseLabelProvider)new FileDiffLabelProvider(dimmedForegroundRgb));
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object left, Object right) {
                if (left instanceof FileDiff && right instanceof FileDiff) {
                    return FileDiff.PATH_COMPARATOR.compare((FileDiff)left, (FileDiff)right);
                }
                return super.compare(viewer, left, right);
            }
        });
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)iss.getFirstElement();
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    CommitFileDiffViewer.this.showTwoWayFileDiff(d);
                } else if (d.getChange() == DiffEntry.ChangeType.DELETE) {
                    CommitFileDiffViewer.this.openPreviousVersionInEditor(d);
                } else {
                    CommitFileDiffViewer.this.openThisVersionInEditor(d);
                }
            }
        });
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitFileDiffViewer.this.clipboard.dispose();
            }
        });
        MenuManager mgr = new MenuManager();
        rawTable.setMenu(mgr.createContextMenu((Control)rawTable));
        this.showInHistory = new Action(UIText.CommitFileDiffViewer_ShowInHistoryLabel, UIIcons.HISTORY){

            public void run() {
                ShowInContext context = CommitFileDiffViewer.this.getShowInContext();
                if (context == null) {
                    return;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IWorkbenchPart part = page.getActivePart();
                if (part instanceof IHistoryView) {
                    ((IShowInTarget)part).show(context);
                }
            }
        };
        this.copy = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> {
            IStructuredSelection selection = this.getStructuredSelection();
            if (selection != null && !selection.isEmpty()) {
                this.doCopy(selection.iterator());
            }
        });
        this.copy.setText(UIText.CommitFileDiffViewer_CopyFilePathMenuLabel);
        this.copy.setEnabled(true);
        if ((rawTable.getStyle() & 2) != 0) {
            this.selectAll = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, this::doSelectAll);
            this.selectAll.setEnabled(true);
            ActionUtils.setGlobalActions((Control)rawTable, this.copy, this.selectAll);
        } else {
            ActionUtils.setGlobalActions((Control)rawTable, this.copy);
        }
        this.copyAll = new Action(UIText.CommitFileDiffViewer_CopyAllFilePathsMenuLabel){

            public void run() {
                CommitFileDiffViewer.this.doCopy(Arrays.asList(((IStructuredContentProvider)CommitFileDiffViewer.this.getContentProvider()).getElements(CommitFileDiffViewer.this.getInput())).iterator());
            }
        };
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(manager -> {
            this.getControl().setFocus();
            this.updateActionEnablement(this.getStructuredSelection());
            mgr.add((IContributionItem)new Separator(GROUP_ID));
            mgr.add((IContributionItem)new Separator());
            mgr.add(this.showInHistory);
            MenuManager showInSubMenu = UIUtils.createShowInMenu(site.getWorkbenchWindow());
            mgr.add((IContributionItem)showInSubMenu);
            mgr.add((IContributionItem)new Separator("additions"));
            mgr.add((IContributionItem)new Separator());
            if (this.selectAll != null) {
                mgr.add(this.selectAll);
            }
            mgr.add(this.copy);
            mgr.add(this.copyAll);
        });
        this.menuManager = mgr;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.copyAll.setEnabled(this.getContentProvider() instanceof IStructuredContentProvider && this.doGetItemCount() > 0);
    }

    private void updateActionEnablement(IStructuredSelection selection) {
        boolean allSelected;
        boolean bl = allSelected = !selection.isEmpty() && selection.size() == this.getTable().getItemCount();
        if (this.selectAll != null) {
            this.selectAll.setEnabled(!allSelected);
        }
        this.copy.setEnabled(!selection.isEmpty());
        this.showInHistory.setEnabled(!selection.isEmpty());
    }

    protected void handleDispose(DisposeEvent event) {
        this.cancelJob();
        this.realInput = null;
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        super.handleDispose(event);
    }

    public void newInput(Object input) {
        this.cancelJob();
        if (input == null) {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
            this.setInput(new Object());
        } else if (this.realInput != null && input instanceof FileDiffInput) {
            FileDiffInput newInput = (FileDiffInput)input;
            if (!Objects.equals(this.realInput.getRepository(), newInput.getRepository()) || this.realInput.isFirstParentOnly() != newInput.isFirstParentOnly() || !this.realInput.getCommit().equals((AnyObjectId)newInput.getCommit())) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
                this.setInput(new Object());
            }
        }
        if (input instanceof FileDiffInput) {
            this.realInput = (FileDiffInput)input;
            this.startJob((FileDiffInput)input);
        } else {
            this.realInput = null;
            this.setInput(input);
        }
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list != null && list.isEmpty()) {
            list = null;
        }
        super.setSelectionToWidget(list, reveal);
    }

    public ShowInContext getShowInContext() {
        IStructuredSelection selection = this.getStructuredSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<File> files = new ArrayList<File>();
        Repository repo = null;
        Path workTreePath = null;
        boolean isBare = false;
        for (Object selectedElement : selection.toList()) {
            IPath path;
            FileDiff fileDiff = (FileDiff)selectedElement;
            if (repo == null) {
                repo = fileDiff.getRepository();
                if (repo == null) {
                    return null;
                }
                isBare = repo.isBare();
                if (!isBare) {
                    workTreePath = new Path(repo.getWorkTree().getAbsolutePath());
                }
            }
            IFile file = null;
            if (!isBare && workTreePath != null) {
                path = workTreePath.append(fileDiff.getPath());
                file = ResourceUtil.getFileForLocation((IPath)path, (boolean)false);
                if (file != null) {
                    elements.add(file);
                } else {
                    elements.add(path);
                }
                files.add(path.toFile());
                continue;
            }
            path = Path.fromPortableString((String)fileDiff.getGitPath());
            files.add(path.toFile());
            elements.add(fileDiff);
        }
        HistoryPageInput historyPageInput = null;
        if (!files.isEmpty()) {
            historyPageInput = new HistoryPageInput(repo, files.toArray(new File[0]));
        }
        return new ShowInContext(historyPageInput, (ISelection)new StructuredSelection(elements));
    }

    private void openThisVersionInEditor(FileDiff d) {
        DiffViewer.openInEditor(d, DiffEntry.Side.NEW, -1);
    }

    private void openPreviousVersionInEditor(FileDiff d) {
        DiffViewer.openInEditor(d, DiffEntry.Side.OLD, -1);
    }

    private void showTwoWayFileDiff(FileDiff d) {
        DiffViewer.showTwoWayFileDiff(d);
    }

    private void doSelectAll() {
        Table table;
        if (this.getInput() != null && (table = this.getTable()) != null) {
            table.selectAll();
            this.setSelection(this.getSelection());
        }
    }

    private void doCopy(Iterator<?> items) {
        StringBuilder r = new StringBuilder();
        while (items.hasNext()) {
            Object obj = items.next();
            if (!(obj instanceof FileDiff)) continue;
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(((FileDiff)obj).getPath());
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInterestingPaths(Collection<String> interestingPaths) {
        if (this.realInput != null) {
            this.cancelJob();
            this.realInput.setInterestingPaths(interestingPaths);
            this.startJob(this.realInput);
        }
    }

    private TreeFilter toFilter(Collection<String> paths) {
        if (paths != null && !paths.isEmpty()) {
            return PathFilterGroup.createFromStrings(paths);
        }
        return TreeFilter.ALL;
    }

    private void startJob(final FileDiffInput input) {
        final FileDiffLoader job = new FileDiffLoader(input, this.toFilter(input.getInterestingPaths()));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UpdateJob updater = new UpdateJob(MessageFormat.format(UIText.CommitFileDiffViewer_updatingFileDiffs, input.getCommit().getName()), job);
                updater.schedule();
            }
        });
        job.setUser(false);
        job.setSystem(true);
        this.loader = job;
        this.loader.schedule();
    }

    private void cancelJob() {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
        Job.getJobManager().cancel(JobFamilies.HISTORY_FILE_DIFF);
    }

    private static class FileDiffLoader
    extends Job {
        private FileDiff[] diffs;
        private final FileDiffInput input;
        private final TreeFilter filter;

        public FileDiffLoader(FileDiffInput input, TreeFilter filter) {
            super(MessageFormat.format(UIText.CommitFileDiffViewer_computingFileDiffs, input.getCommit().getName()));
            this.input = input;
            this.filter = filter;
            this.setRule(new TreeWalkSchedulingRule(input.getTreeWalk()));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.input.isFirstParentOnly() && this.input.getCommit().getParentCount() > 1) {
                    RevCommit[] parents = new RevCommit[]{this.input.getCommit().getParent(0)};
                    this.diffs = FileDiff.compute(this.input.getRepository(), this.input.getTreeWalk(), this.input.getCommit(), parents, monitor, this.filter);
                } else {
                    this.diffs = FileDiff.compute(this.input.getRepository(), this.input.getTreeWalk(), this.input.getCommit(), monitor, this.filter);
                }
            }
            catch (IOException err) {
                Activator.handleError(MessageFormat.format(UIText.CommitFileDiffViewer_errorGettingDifference, this.input.getCommit().getId()), err, false);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        public FileDiff[] getDiffs() {
            return this.diffs;
        }

        public FileDiffInput getInput() {
            return this.input;
        }

        public boolean belongsTo(Object family) {
            return family == JobFamilies.HISTORY_FILE_DIFF || super.belongsTo(family);
        }
    }

    private static class TreeWalkSchedulingRule
    implements ISchedulingRule {
        private final TreeWalk treeWalk;

        public TreeWalkSchedulingRule(TreeWalk treeWalk) {
            this.treeWalk = treeWalk;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof TreeWalkSchedulingRule) {
                return Objects.equals(this.treeWalk, ((TreeWalkSchedulingRule)rule).treeWalk);
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }

    private class UpdateJob
    extends UIJob {
        private final FileDiffLoader loadJob;

        public UpdateJob(String name, FileDiffLoader loadJob) {
            super(name);
            this.loadJob = loadJob;
            this.setUser(false);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = CommitFileDiffViewer.this.getControl();
            if (control == null || control.isDisposed() || CommitFileDiffViewer.this.loader != this.loadJob || monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            FileDiff[] diffs = this.loadJob.getDiffs();
            try {
                control.setRedraw(false);
                CommitFileDiffViewer.this.setInput(diffs);
                FileDiff interesting = this.getFirstInterestingElement(diffs);
                if (interesting != null) {
                    if (this.loadJob.getInput().isSelectMarked()) {
                        CommitFileDiffViewer.this.setSelection((ISelection)new StructuredSelection((Object)interesting), true);
                    }
                    CommitFileDiffViewer.this.reveal(interesting);
                }
            }
            finally {
                control.setRedraw(true);
            }
            return Status.OK_STATUS;
        }

        private FileDiff getFirstInterestingElement(FileDiff[] diffs) {
            if (diffs != null) {
                FileDiff[] fileDiffArray = diffs;
                int n = diffs.length;
                int n2 = 0;
                while (n2 < n) {
                    FileDiff d = fileDiffArray[n2];
                    if (d.isMarked(0)) {
                        return d;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public boolean belongsTo(Object family) {
            return family == JobFamilies.HISTORY_FILE_DIFF || super.belongsTo(family);
        }
    }
}

