/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreRegionString;

public class STCoreRegionStringJoiner {
    private final CharSequence prefix;
    private final CharSequence delimiter;
    private final CharSequence suffix;
    private final List<STCoreRegionString> strings = new ArrayList<STCoreRegionString>();

    public STCoreRegionStringJoiner(CharSequence delimiter) {
        this(delimiter, "", "");
    }

    public STCoreRegionStringJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.suffix = suffix;
    }

    public STCoreRegionStringJoiner add(STCoreRegionString str) {
        this.strings.add(str);
        return this;
    }

    public STCoreRegionStringJoiner merge(STCoreRegionStringJoiner other) {
        this.strings.addAll(other.strings);
        return this;
    }

    public STCoreRegionString toProposalString() {
        STCoreRegionString result = new STCoreRegionString(this.toString());
        int stringsLength = 0;
        int i = 0;
        while (i < this.strings.size()) {
            STCoreRegionString str = this.strings.get(i);
            str.getRegions(this.prefix.length() + i * this.delimiter.length() + stringsLength).forEach(result::addRegion);
            stringsLength += str.length();
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.strings.stream().collect(Collectors.joining(this.delimiter, this.prefix, this.suffix));
    }
}

