/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.stcore.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyMagnitudeType;
import org.eclipse.fordiac.ide.model.data.AnyNumType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.AnyUnsignedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.ByteType;
import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.DintType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.DwordType;
import org.eclipse.fordiac.ide.model.data.IntType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LintType;
import org.eclipse.fordiac.ide.model.data.LrealType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.LwordType;
import org.eclipse.fordiac.ide.model.data.RealType;
import org.eclipse.fordiac.ide.model.data.SintType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.UdintType;
import org.eclipse.fordiac.ide.model.data.UintType;
import org.eclipse.fordiac.ide.model.data.UlintType;
import org.eclipse.fordiac.ide.model.data.UsintType;
import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WordType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.eval.function.Comment;
import org.eclipse.fordiac.ide.model.eval.function.Functions;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAttribute;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedInputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedOutputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallUnnamedArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreFactory;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STString;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTypeDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarPlainDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public final class STCoreUtil {
    private static final LoadingCache<Pair<DataType, String>, DataType> TYPE_DECLARATION_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Pair<DataType, String>, DataType>(){

        public DataType load(Pair<DataType, String> it) throws Exception {
            return TypeDeclarationParser.parseTypeDeclaration((DataType)((DataType)it.getKey()), (String)((String)it.getValue()));
        }
    });
    private static final Pattern SIMPLE_ARRAY_PATTERN = Pattern.compile("[^a-zA-Z]*");

    private STCoreUtil() {
    }

    public static boolean isArithmetic(STUnaryOperator operator) {
        boolean _switchResult = false;
        if (operator != null) {
            switch (operator) {
                case MINUS: 
                case PLUS: {
                    _switchResult = true;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isLogical(STUnaryOperator operator) {
        boolean _switchResult = false;
        if (operator != null) {
            switch (operator) {
                case NOT: {
                    _switchResult = true;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isArithmetic(STBinaryOperator operator) {
        boolean _switchResult = false;
        if (operator != null) {
            switch (operator) {
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: 
                case POWER: {
                    _switchResult = true;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isComparison(STBinaryOperator operator) {
        boolean _switchResult = false;
        if (operator != null) {
            switch (operator) {
                case EQ: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: {
                    _switchResult = true;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isLogical(STBinaryOperator operator) {
        boolean _switchResult = false;
        if (operator != null) {
            switch (operator) {
                case OR: 
                case XOR: 
                case AND: 
                case AMPERSAND: {
                    _switchResult = true;
                    break;
                }
                default: {
                    _switchResult = false;
                    break;
                }
            }
        } else {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isRange(STBinaryOperator operator) {
        return Objects.equals((Object)operator, (Object)STBinaryOperator.RANGE);
    }

    public static boolean isApplicableTo(STUnaryOperator operator, LibraryElement type) {
        boolean _switchResult = false;
        boolean _matched = false;
        boolean _isAnyType = STCoreUtil.isAnyType((INamedElement)type);
        if (_isAnyType) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            if (Objects.equals((Object)operator, (Object)STUnaryOperator.PLUS)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STUnaryOperator.MINUS)) {
                _matched = true;
            }
            if (_matched) {
                boolean bl = _switchResult = type instanceof AnyMagnitudeType && !(type instanceof AnyUnsignedType);
            }
        }
        if (!_matched && Objects.equals((Object)operator, (Object)STUnaryOperator.NOT)) {
            _matched = true;
            _switchResult = type instanceof AnyBitType;
        }
        return _switchResult;
    }

    public static boolean isApplicableTo(STBinaryOperator operator, LibraryElement first, LibraryElement second) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (STCoreUtil.isAnyType((INamedElement)first) || STCoreUtil.isAnyType((INamedElement)second)) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.ADD)) {
            _matched = true;
            boolean bl = _switchResult = first instanceof AnyNumType && second instanceof AnyNumType && STCoreUtil.hasCommonSupertype(first, second) || first instanceof AnyDurationType && second instanceof AnyDurationType || STCoreUtil.isInstanceofAnyTimeOfDayType(first) && second instanceof AnyDurationType || STCoreUtil.isInstanceofAnyDateAndTimeType(first) && second instanceof AnyDurationType;
        }
        if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.SUB)) {
            _matched = true;
            boolean bl = _switchResult = first instanceof AnyNumType && second instanceof AnyNumType && STCoreUtil.hasCommonSupertype(first, second) || first instanceof AnyDurationType && second instanceof AnyDurationType || STCoreUtil.isInstanceofAnyTimeOfDayType(first) && second instanceof AnyDurationType || STCoreUtil.isInstanceofAnyDateAndTimeType(first) && second instanceof AnyDurationType || STCoreUtil.isInstanceofAnySimpleDateType(first) && STCoreUtil.isInstanceofAnySimpleDateType(second) || STCoreUtil.isInstanceofAnyDateAndTimeType(first) && STCoreUtil.isInstanceofAnyDateAndTimeType(second) || STCoreUtil.isInstanceofAnyTimeOfDayType(first) && STCoreUtil.isInstanceofAnyTimeOfDayType(second);
        }
        if (!_matched) {
            if (Objects.equals((Object)operator, (Object)STBinaryOperator.MUL)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.DIV)) {
                _matched = true;
            }
            if (_matched) {
                boolean bl = _switchResult = first instanceof AnyNumType && second instanceof AnyNumType && STCoreUtil.hasCommonSupertype(first, second) || first instanceof AnyDurationType && second instanceof AnyNumType;
            }
        }
        if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.MOD)) {
            _matched = true;
            boolean bl = _switchResult = first instanceof AnyIntType && second instanceof AnyIntType && STCoreUtil.hasCommonSupertype(first, second);
        }
        if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.POWER)) {
            _matched = true;
            boolean bl = _switchResult = first instanceof AnyRealType && second instanceof AnyNumType && STCoreUtil.hasCommonSupertype(first, second);
        }
        if (!_matched) {
            if (Objects.equals((Object)operator, (Object)STBinaryOperator.AMPERSAND)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.AND)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.OR)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.XOR)) {
                _matched = true;
            }
            if (_matched) {
                boolean bl = _switchResult = first instanceof AnyBitType && second instanceof AnyBitType;
            }
        }
        if (!_matched) {
            if (Objects.equals((Object)operator, (Object)STBinaryOperator.EQ)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.NE)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.GE)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.GT)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.LE)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.LT)) {
                _matched = true;
            }
            if (!_matched && Objects.equals((Object)operator, (Object)STBinaryOperator.RANGE)) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = STCoreUtil.hasCommonSupertype(first, second);
            }
        }
        return _switchResult;
    }

    public static AccessMode getAccessMode(STExpression expression) {
        STExpression _receiver;
        STExpression _left;
        STExpression _variable;
        boolean _contains;
        STExpression _selector;
        STExpression _condition;
        boolean _equals;
        EObject _eContainer;
        AccessMode _switchResult = null;
        EObject container = _eContainer = expression.eContainer();
        boolean _matched = false;
        if (container instanceof STIfStatement && (_equals = Objects.equals(_condition = ((STIfStatement)container).getCondition(), expression))) {
            _matched = true;
        }
        if (!_matched && container instanceof STElseIfPart && (_equals = Objects.equals(_condition = ((STElseIfPart)container).getCondition(), expression))) {
            _matched = true;
        }
        if (!_matched && container instanceof STCaseStatement && (_equals = Objects.equals(_selector = ((STCaseStatement)container).getSelector(), expression))) {
            _matched = true;
        }
        if (!_matched && container instanceof STCaseCases && (_contains = ((STCaseCases)container).getConditions().contains((Object)expression))) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = AccessMode.READ;
        }
        if (!_matched && container instanceof STForStatement && (_equals = Objects.equals(_variable = ((STForStatement)container).getVariable(), expression))) {
            _matched = true;
            _switchResult = AccessMode.WRITE;
        }
        if (!_matched) {
            STExpression _condition2;
            STExpression _condition3;
            if (container instanceof STForStatement && (Objects.equals(((STForStatement)container).getFrom(), expression) || Objects.equals(((STForStatement)container).getTo(), expression) || Objects.equals(((STForStatement)container).getBy(), expression))) {
                _matched = true;
            }
            if (!_matched && container instanceof STRepeatStatement && (_equals = Objects.equals(_condition3 = ((STRepeatStatement)container).getCondition(), expression))) {
                _matched = true;
            }
            if (!_matched && container instanceof STWhileStatement && (_equals = Objects.equals(_condition2 = ((STWhileStatement)container).getCondition(), expression))) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = AccessMode.READ;
            }
        }
        if (!_matched && container instanceof STAssignment && (_equals = Objects.equals(_left = ((STAssignment)container).getLeft(), expression))) {
            _matched = true;
            _switchResult = AccessMode.WRITE;
        }
        if (!_matched && container instanceof STCallArgument) {
            _matched = true;
            _switchResult = STCoreUtil.getAccessMode((STCallArgument)container);
        }
        if (!_matched && container instanceof STMemberAccessExpression) {
            _matched = true;
            _switchResult = STCoreUtil.getAccessMode((STExpression)container);
        }
        if (!_matched && container instanceof STArrayAccessExpression && (_equals = Objects.equals(_receiver = ((STArrayAccessExpression)container).getReceiver(), expression))) {
            _matched = true;
            _switchResult = STCoreUtil.getAccessMode((STExpression)container);
        }
        if (!_matched) {
            if (container instanceof STExpression) {
                _matched = true;
            }
            if (!_matched && container instanceof STVarDeclaration) {
                _matched = true;
            }
            if (!_matched && container instanceof STTypeDeclaration) {
                _matched = true;
            }
            if (!_matched && container instanceof STExpressionSource) {
                _matched = true;
            }
            if (!_matched && container instanceof STInitializerExpression) {
                _matched = true;
            }
            if (!_matched && container instanceof STInitializerExpressionSource) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = AccessMode.READ;
            }
        }
        if (!_matched) {
            _switchResult = AccessMode.NONE;
        }
        return _switchResult;
    }

    public static AccessMode getAccessMode(STCallArgument argument) {
        boolean _containsValue;
        EObject _eContainer;
        AccessMode _switchResult = null;
        EObject container = _eContainer = argument.eContainer();
        boolean _matched = false;
        if (container instanceof STFeatureExpression && (_containsValue = ((STFeatureExpression)container).getMappedInputArguments().containsValue(argument))) {
            _matched = true;
            _switchResult = AccessMode.READ;
        }
        if (!_matched && container instanceof STFeatureExpression && (_containsValue = ((STFeatureExpression)container).getMappedOutputArguments().containsValue(argument))) {
            _matched = true;
            _switchResult = AccessMode.WRITE;
        }
        if (!_matched && container instanceof STFeatureExpression && (_containsValue = ((STFeatureExpression)container).getMappedInOutArguments().containsValue(argument))) {
            _matched = true;
            _switchResult = AccessMode.READ_WRITE;
        }
        if (!_matched) {
            _switchResult = AccessMode.NONE;
        }
        return _switchResult;
    }

    public static List<INamedElement> getFeaturePath(STExpression expression) {
        List _switchResult = null;
        boolean _matched = false;
        if (expression instanceof STFeatureExpression) {
            _matched = true;
            INamedElement _feature = ((STFeatureExpression)expression).getFeature();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new INamedElement[]{_feature}));
        }
        if (!_matched && expression instanceof STMemberAccessExpression) {
            _matched = true;
            List<INamedElement> _featurePath = STCoreUtil.getFeaturePath(((STMemberAccessExpression)expression).getReceiver());
            List<INamedElement> _featurePath_1 = STCoreUtil.getFeaturePath(((STMemberAccessExpression)expression).getMember());
            _switchResult = IterableExtensions.toList((Iterable)Iterables.concat(_featurePath, _featurePath_1));
        }
        if (!_matched && expression instanceof STArrayAccessExpression) {
            _matched = true;
            _switchResult = STCoreUtil.getFeaturePath(((STArrayAccessExpression)expression).getReceiver());
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.emptyList();
        }
        return _switchResult;
    }

    public static boolean isTemporary(INamedElement feature) {
        return feature.eContainer() instanceof STVarPlainDeclarationBlock || feature.eContainer() instanceof STVarTempDeclarationBlock;
    }

    public static boolean isNumericValueValid(DataType type, Object value) {
        boolean _matched_1;
        boolean _switchResult_1;
        boolean _switchResult = false;
        boolean _matched = false;
        if (value instanceof Boolean) {
            _matched = true;
            _switchResult = type instanceof BoolType;
        }
        if (!_matched && value instanceof BigDecimal) {
            _matched = true;
            _switchResult_1 = false;
            _matched_1 = false;
            if (type instanceof RealType) {
                _matched_1 = true;
                _switchResult_1 = Float.isFinite(((BigDecimal)value).floatValue());
            }
            if (!_matched_1 && type instanceof LrealType) {
                _matched_1 = true;
                _switchResult_1 = Double.isFinite(((BigDecimal)value).doubleValue());
            }
            if (!_matched_1) {
                _switchResult_1 = false;
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && value instanceof BigInteger) {
            _matched = true;
            _switchResult_1 = false;
            _matched_1 = false;
            if (type instanceof SintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRange((BigInteger)value, -128L, 127L);
            }
            if (!_matched_1 && type instanceof IntType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRange((BigInteger)value, -32768L, 32767L);
            }
            if (!_matched_1 && type instanceof DintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRange((BigInteger)value, Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (!_matched_1 && type instanceof LintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRange((BigInteger)value, Long.MIN_VALUE, Long.MAX_VALUE);
            }
            if (!_matched_1 && type instanceof UsintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ff", 16));
            }
            if (!_matched_1 && type instanceof UintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ffff", 16));
            }
            if (!_matched_1 && type instanceof UdintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ffffffff", 16));
            }
            if (!_matched_1 && type instanceof UlintType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ffffffffffffffff", 16));
            }
            if (!_matched_1 && type instanceof BoolType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, BigInteger.ONE);
            }
            if (!_matched_1 && type instanceof ByteType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ff", 16));
            }
            if (!_matched_1 && type instanceof WordType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ffff", 16));
            }
            if (!_matched_1 && type instanceof DwordType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ffffffff", 16));
            }
            if (!_matched_1 && type instanceof LwordType) {
                _matched_1 = true;
                _switchResult_1 = STCoreUtil.checkRangeUnsigned((BigInteger)value, new BigInteger("ffffffffffffffff", 16));
            }
            if (!_matched_1) {
                _switchResult_1 = false;
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isStringValueValid(DataType type, STString value) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (type instanceof CharType) {
            _matched = true;
            boolean bl = _switchResult = !value.isWide() && value.length() == 1;
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            boolean _isWide = value.isWide();
            boolean bl = _switchResult = !_isWide;
        }
        if (!_matched && type instanceof WcharType) {
            _matched = true;
            boolean bl = _switchResult = value.isWide() && value.length() == 1;
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            _switchResult = value.isWide();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean checkRange(BigInteger value, long lower, long upper) {
        return value.compareTo(BigInteger.valueOf(lower)) >= 0 && value.compareTo(BigInteger.valueOf(upper)) <= 0;
    }

    public static boolean checkRangeUnsigned(BigInteger value, BigInteger upper) {
        return value.signum() >= 0 && value.compareTo(upper) <= 0;
    }

    public static LibraryElement getExpectedType(STExpression expression) {
        LibraryElement _xblockexpression = null;
        Resource resource = expression.eResource();
        LibraryElement _xifexpression = null;
        _xifexpression = resource instanceof STResource ? ((STResource)resource).getExpectedType(expression) : STCoreUtil.computeExpectedType(expression);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static LibraryElement getExpectedType(STInitializerExpression expression) {
        LibraryElement _xblockexpression = null;
        Resource resource = expression.eResource();
        LibraryElement _xifexpression = null;
        _xifexpression = resource instanceof STResource ? ((STResource)resource).getExpectedType(expression) : STCoreUtil.computeExpectedType(expression);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static LibraryElement computeExpectedType(STExpression expression) {
        boolean _isComparison;
        LibraryElement _declaredResultType_1;
        STExpression _left_1;
        LibraryElement _declaredResultType;
        STExpression _right;
        LibraryElement _xifexpression;
        boolean _isLogical;
        LibraryElement _declaredResultType_12;
        LibraryElement _declaredResultType2;
        boolean _tripleEquals;
        STExpression _left;
        boolean _isLogical2;
        boolean _isArithmetic;
        EObject _eContainer;
        AnyNumType _switchResult = null;
        EObject it = _eContainer = expression.eContainer();
        boolean _matched = false;
        if (it instanceof STUnaryExpression && (_isArithmetic = STCoreUtil.isArithmetic(((STUnaryExpression)it).getOp()))) {
            _matched = true;
            _switchResult = STCoreUtil.getEquivalentAnyNumType(STCoreUtil.getExpectedType((STExpression)it));
        }
        if (!_matched && it instanceof STUnaryExpression && (_isLogical2 = STCoreUtil.isLogical(((STUnaryExpression)it).getOp()))) {
            _matched = true;
            _switchResult = STCoreUtil.getEquivalentAnyBitType(STCoreUtil.getExpectedType((STExpression)it));
        }
        if (!_matched && it instanceof STBinaryExpression && (STCoreUtil.isArithmetic(((STBinaryExpression)it).getOp()) || STCoreUtil.isRange(((STBinaryExpression)it).getOp()))) {
            _matched = true;
            LibraryElement _xifexpression2 = null;
            _left = ((STBinaryExpression)it).getLeft();
            boolean bl = _tripleEquals = expression == _left;
            if (_tripleEquals) {
                STExpression _right2 = ((STBinaryExpression)it).getRight();
                _declaredResultType2 = null;
                if (_right2 != null) {
                    _declaredResultType2 = _right2.getDeclaredResultType();
                }
                _xifexpression2 = _declaredResultType2;
            } else {
                STExpression _left_12 = ((STBinaryExpression)it).getLeft();
                _declaredResultType_12 = null;
                if (_left_12 != null) {
                    _declaredResultType_12 = _left_12.getDeclaredResultType();
                }
                _xifexpression2 = _declaredResultType_12;
            }
            _switchResult = STCoreUtil.getCompatibleType((DataType)STCoreUtil.getEquivalentAnyNumType(STCoreUtil.getExpectedType((STExpression)it)), (DataType)STCoreUtil.getEquivalentAnyNumType(_xifexpression2));
        }
        if (!_matched && it instanceof STBinaryExpression && (_isLogical = STCoreUtil.isLogical(((STBinaryExpression)it).getOp()))) {
            boolean _tripleEquals2;
            _matched = true;
            _xifexpression = null;
            STExpression _left2 = ((STBinaryExpression)it).getLeft();
            boolean bl = _tripleEquals2 = expression == _left2;
            if (_tripleEquals2) {
                _right = ((STBinaryExpression)it).getRight();
                _declaredResultType = null;
                if (_right != null) {
                    _declaredResultType = _right.getDeclaredResultType();
                }
                _xifexpression = _declaredResultType;
            } else {
                _left_1 = ((STBinaryExpression)it).getLeft();
                _declaredResultType_1 = null;
                if (_left_1 != null) {
                    _declaredResultType_1 = _left_1.getDeclaredResultType();
                }
                _xifexpression = _declaredResultType_1;
            }
            _switchResult = STCoreUtil.getCompatibleType((DataType)STCoreUtil.getEquivalentAnyBitType(STCoreUtil.getExpectedType((STExpression)it)), (DataType)STCoreUtil.getEquivalentAnyBitType(_xifexpression));
        }
        if (!_matched && it instanceof STBinaryExpression && (_isComparison = STCoreUtil.isComparison(((STBinaryExpression)it).getOp()))) {
            boolean _tripleEquals3;
            _matched = true;
            _xifexpression = null;
            STExpression _left3 = ((STBinaryExpression)it).getLeft();
            boolean bl = _tripleEquals3 = expression == _left3;
            if (_tripleEquals3) {
                _right = ((STBinaryExpression)it).getRight();
                _declaredResultType = null;
                if (_right != null) {
                    _declaredResultType = _right.getDeclaredResultType();
                }
                _xifexpression = _declaredResultType;
            } else {
                _left_1 = ((STBinaryExpression)it).getLeft();
                _declaredResultType_1 = null;
                if (_left_1 != null) {
                    _declaredResultType_1 = _left_1.getDeclaredResultType();
                }
                _xifexpression = _declaredResultType_1;
            }
            _switchResult = _xifexpression;
        }
        if (!_matched && it instanceof STAssignment) {
            _matched = true;
            LibraryElement _xifexpression3 = null;
            _left = ((STAssignment)it).getLeft();
            boolean bl = _tripleEquals = expression == _left;
            if (_tripleEquals) {
                STExpression _right3 = ((STAssignment)it).getRight();
                _declaredResultType2 = null;
                if (_right3 != null) {
                    _declaredResultType2 = _right3.getDeclaredResultType();
                }
                _xifexpression3 = _declaredResultType2;
            } else {
                STExpression _left_13 = ((STAssignment)it).getLeft();
                _declaredResultType_12 = null;
                if (_left_13 != null) {
                    _declaredResultType_12 = _left_13.getDeclaredResultType();
                }
                _xifexpression3 = _declaredResultType_12;
            }
            _switchResult = _xifexpression3;
        }
        if (!_matched) {
            if (it instanceof STIfStatement) {
                _matched = true;
            }
            if (!_matched && it instanceof STWhileStatement) {
                _matched = true;
            }
            if (!_matched && it instanceof STRepeatStatement) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = IecTypes.ElementaryTypes.BOOL;
            }
        }
        if (!_matched && it instanceof STForStatement) {
            _matched = true;
            AnyIntType _xifexpression4 = null;
            STExpression _variable = ((STForStatement)it).getVariable();
            boolean bl = _tripleEquals = expression == _variable;
            if (_tripleEquals) {
                _xifexpression4 = IecTypes.GenericTypes.ANY_INT;
            } else {
                STExpression _variable_1 = ((STForStatement)it).getVariable();
                LibraryElement _resultType = null;
                if (_variable_1 != null) {
                    _resultType = _variable_1.getResultType();
                }
                _xifexpression4 = _resultType;
            }
            _switchResult = _xifexpression4;
        }
        if (!_matched && it instanceof STCaseCases) {
            _matched = true;
            STExpression _selector = ((STCaseCases)it).getStatement().getSelector();
            LibraryElement _declaredResultType3 = null;
            if (_selector != null) {
                _declaredResultType3 = _selector.getDeclaredResultType();
            }
            _switchResult = _declaredResultType3;
        }
        if (!_matched && it instanceof STInitializerExpression) {
            _matched = true;
            _switchResult = STCoreUtil.getExpectedType((STInitializerExpression)it);
        }
        if (!_matched && it instanceof STArrayInitElement) {
            _matched = true;
            _switchResult = STCoreUtil.computeExpectedType((STArrayInitElement)it);
        }
        if (!_matched && it instanceof STStructInitElement) {
            _matched = true;
            _switchResult = STCoreUtil.getFeatureType(((STStructInitElement)it).getVariable());
        }
        if (!_matched && it instanceof STCallArgument) {
            _matched = true;
            _switchResult = STCoreUtil.computeExpectedType((STCallArgument)it);
        }
        if (!_matched && it instanceof STExpressionSource) {
            _matched = true;
            Resource _eResource = ((STExpressionSource)it).eResource();
            _switchResult = ((STResource)_eResource).getExpectedType();
        }
        return _switchResult;
    }

    public static LibraryElement computeExpectedType(STInitializerExpression expression) {
        EObject _eContainer;
        LibraryElement _switchResult = null;
        EObject it = _eContainer = expression.eContainer();
        boolean _matched = false;
        if (it instanceof STAttribute) {
            _matched = true;
            _switchResult = STCoreUtil.getFeatureType((INamedElement)((STAttribute)it).getDeclaration());
        }
        if (!_matched && it instanceof STVarDeclaration) {
            _matched = true;
            _switchResult = STCoreUtil.getFeatureType((INamedElement)it);
        }
        if (!_matched && it instanceof STArrayInitElement) {
            _matched = true;
            _switchResult = STCoreUtil.computeExpectedType((STArrayInitElement)it);
        }
        if (!_matched && it instanceof STStructInitElement) {
            _matched = true;
            _switchResult = STCoreUtil.getFeatureType(((STStructInitElement)it).getVariable());
        }
        if (!_matched && it instanceof STArrayInitializerExpression) {
            _matched = true;
            _switchResult = STCoreUtil.getExpectedType((STInitializerExpression)it);
        }
        if (!_matched && it instanceof STStructInitializerExpression) {
            _matched = true;
            _switchResult = STCoreUtil.getExpectedType((STInitializerExpression)it);
        }
        if (!_matched && it instanceof STInitializerExpressionSource) {
            _matched = true;
            Resource _eResource = ((STInitializerExpressionSource)it).eResource();
            _switchResult = ((STResource)_eResource).getExpectedType();
        }
        return _switchResult;
    }

    private static LibraryElement computeExpectedType(STArrayInitElement initElement) {
        EObject _eContainer;
        DataType _switchResult = null;
        EObject it = _eContainer = initElement.eContainer();
        boolean _matched = false;
        if (it instanceof STArrayInitializerExpression) {
            LibraryElement _expectedType;
            _matched = true;
            DataType _switchResult_1 = null;
            LibraryElement type = _expectedType = STCoreUtil.getExpectedType((STInitializerExpression)it);
            boolean _matched_1 = false;
            if (type instanceof ArrayType) {
                boolean _greaterThan;
                _matched_1 = true;
                DataType _xifexpression = null;
                int _size = ((ArrayType)type).getSubranges().size();
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    Functions.Function1 _function = it_1 -> (Subrange)EcoreUtil.copy((EObject)it_1);
                    _xifexpression = STCoreUtil.newArrayType(((ArrayType)type).getBaseType(), IterableExtensions.map((Iterable)IterableExtensions.tail((Iterable)((ArrayType)type).getSubranges()), (Functions.Function1)_function));
                } else {
                    _xifexpression = ((ArrayType)type).getBaseType();
                }
                _switchResult_1 = _xifexpression;
            }
            _switchResult = _switchResult_1;
        }
        return _switchResult;
    }

    private static LibraryElement computeExpectedType(STCallArgument argument) {
        LibraryElement _xblockexpression = null;
        EObject featureExpression = argument.eContainer();
        LibraryElement _xifexpression = null;
        if (featureExpression instanceof STFeatureExpression) {
            LibraryElement _xblockexpression_1 = null;
            INamedElement feature = ((STFeatureExpression)featureExpression).getFeature();
            LibraryElement _xifexpression_1 = null;
            if (feature instanceof STStandardFunction) {
                LibraryElement _expectedType;
                DataType _xblockexpression_2 = null;
                DataType _switchResult = null;
                LibraryElement type = _expectedType = STCoreUtil.getExpectedType((STExpression)featureExpression);
                boolean _matched = false;
                if (type instanceof DataType) {
                    _matched = true;
                    _switchResult = (DataType)type;
                }
                DataType expectedReturnType = _switchResult;
                int index = ((STFeatureExpression)featureExpression).getParameters().indexOf((Object)argument);
                DataType _xifexpression_2 = null;
                if (index >= 0) {
                    Functions.Function1 _function = it -> {
                        LibraryElement _declaredResultType;
                        DataType _switchResult_1 = null;
                        LibraryElement type_1 = _declaredResultType = it.getDeclaredResultType();
                        boolean _matched_1 = false;
                        if (type_1 instanceof DataType) {
                            _matched_1 = true;
                            _switchResult_1 = (DataType)type_1;
                        }
                        return _switchResult_1;
                    };
                    _xifexpression_2 = Functions.inferExpectedParameterTypeFromDataType((Method)((STStandardFunction)feature).getJavaMethod(), (DataType)expectedReturnType, (List)IterableExtensions.toList((Iterable)ListExtensions.map(((STFeatureExpression)featureExpression).getParameters(), (Functions.Function1)_function)), (int)index);
                }
                _xblockexpression_2 = _xifexpression_2;
                _xifexpression_1 = _xblockexpression_2;
            } else {
                _xifexpression_1 = STCoreUtil.getFeatureType(STCoreUtil.getParameter(argument));
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    static INamedElement _getParameter(STCallNamedInputArgument argument) {
        return argument.getParameter();
    }

    static INamedElement _getParameter(STCallNamedOutputArgument argument) {
        return argument.getParameter();
    }

    static INamedElement _getParameter(STCallUnnamedArgument argument) {
        ITypedElement _xblockexpression = null;
        EObject featureExpression = argument.eContainer();
        ITypedElement _xifexpression = null;
        if (featureExpression instanceof STFeatureExpression) {
            ITypedElement _xblockexpression_1 = null;
            int index = ((STFeatureExpression)featureExpression).getParameters().indexOf((Object)argument);
            ITypedElement _xifexpression_1 = null;
            if (index >= 0) {
                ITypedElement _xblockexpression_2 = null;
                INamedElement feature = ((STFeatureExpression)featureExpression).getFeature();
                ITypedElement _xifexpression_2 = null;
                if (feature instanceof ICallable) {
                    boolean _lessThan;
                    ITypedElement _xblockexpression_3 = null;
                    EList inputParameters = ((ICallable)feature).getInputParameters();
                    EList outputParameters = ((ICallable)feature).getOutputParameters();
                    EList inOutParameters = ((ICallable)feature).getInOutParameters();
                    ITypedElement _xifexpression_3 = null;
                    int _size = inputParameters.size();
                    boolean bl = _lessThan = index < _size;
                    if (_lessThan) {
                        _xifexpression_3 = (ITypedElement)inputParameters.get(index);
                    } else {
                        ITypedElement _xifexpression_4 = null;
                        boolean _isVarargs = ((ICallable)feature).isVarargs();
                        if (_isVarargs) {
                            _xifexpression_4 = (ITypedElement)inputParameters.getLast();
                        } else {
                            boolean _lessThan_1;
                            int _size_2;
                            ITypedElement _xifexpression_5 = null;
                            int _size_1 = inputParameters.size();
                            int _plus = _size_1 + (_size_2 = inOutParameters.size());
                            boolean bl2 = _lessThan_1 = index < _plus;
                            if (_lessThan_1) {
                                int _size_3 = inputParameters.size();
                                int _minus = index - _size_3;
                                _xifexpression_5 = (ITypedElement)inOutParameters.get(_minus);
                            } else {
                                boolean _lessThan_2;
                                int _size_6;
                                int _size_5;
                                ITypedElement _xifexpression_6 = null;
                                int _size_4 = inputParameters.size();
                                int _plus_1 = _size_4 + (_size_5 = inOutParameters.size());
                                int _plus_2 = _plus_1 + (_size_6 = outputParameters.size());
                                boolean bl3 = _lessThan_2 = index < _plus_2;
                                if (_lessThan_2) {
                                    int _size_7 = inputParameters.size();
                                    int _minus_1 = index - _size_7;
                                    int _size_8 = inOutParameters.size();
                                    int _minus_2 = _minus_1 - _size_8;
                                    _xifexpression_6 = (ITypedElement)outputParameters.get(_minus_2);
                                }
                                _xifexpression_5 = _xifexpression_6;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static List<? extends ITypedElement> computeInputParameters(ICallable callable, Iterable<STCallArgument> arguments) {
        Object _xifexpression = null;
        if (callable instanceof STStandardFunction) {
            Functions.Function1 _function = it -> it.getResultType();
            _xifexpression = STCoreUtil.inferParameterVariables(((STStandardFunction)callable).getJavaMethod(), IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.map(arguments, (Functions.Function1)_function), DataType.class)), true);
        } else {
            _xifexpression = callable.getInputParameters();
        }
        return _xifexpression;
    }

    public static List<? extends ITypedElement> computeOutputParameters(ICallable callable, Iterable<STCallArgument> arguments) {
        Object _xifexpression = null;
        if (callable instanceof STStandardFunction) {
            Functions.Function1 _function = it -> it.getResultType();
            _xifexpression = STCoreUtil.inferParameterVariables(((STStandardFunction)callable).getJavaMethod(), IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.map(arguments, (Functions.Function1)_function), DataType.class)), false);
        } else {
            _xifexpression = callable.getOutputParameters();
        }
        return _xifexpression;
    }

    public static List<? extends ITypedElement> computeInOutParameters(ICallable callable, Iterable<STCallArgument> arguments) {
        return callable.getInOutParameters();
    }

    static List<STVarDeclaration> inferParameterVariables(Method method, List<DataType> argumentTypes, boolean input) {
        List _xblockexpression = null;
        List ptypes = Functions.inferParameterTypesFromDataTypes((Method)method, argumentTypes);
        int _size = ptypes.size();
        Functions.Function1 _function = index -> {
            STVarDeclaration _xifexpression = null;
            Class _parameterType = Functions.getParameterType((Method)method, (int)index);
            boolean _equals = Objects.equals(_parameterType, Variable.class);
            boolean _xor = input ^ _equals;
            if (_xor) {
                STVarDeclaration _createSTVarDeclaration = STCoreFactory.eINSTANCE.createSTVarDeclaration();
                Procedures.Procedure1 _function_1 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    if (input) {
                        _builder.append("IN");
                    } else {
                        _builder.append("OUT");
                    }
                    _builder.append(index);
                    it.setName(_builder.toString());
                    String _elvis = null;
                    Parameter _parameter = Functions.getParameter((Method)method, (int)index);
                    Comment _annotation = null;
                    if (_parameter != null) {
                        _annotation = _parameter.getAnnotation(Comment.class);
                    }
                    String _value = null;
                    if (_annotation != null) {
                        _value = _annotation.value();
                    }
                    _elvis = _value != null ? _value : "";
                    it.setComment(MessageFormat.format(_elvis, index));
                    it.setType((DataType)ptypes.get((int)index));
                };
                _xifexpression = (STVarDeclaration)ObjectExtensions.operator_doubleArrow((Object)_createSTVarDeclaration, (Procedures.Procedure1)_function_1);
            }
            return _xifexpression;
        };
        _xblockexpression = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)new ExclusiveRange(0, _size, true), (Functions.Function1)_function)));
        return _xblockexpression;
    }

    public static LibraryElement getFeatureType(INamedElement feature) {
        try {
            DataType _type;
            LibraryElement _switchResult = null;
            boolean _matched = false;
            if (feature instanceof VarDeclaration) {
                _matched = true;
                DataType _xifexpression = null;
                boolean _isArray = ((VarDeclaration)feature).isArray();
                if (_isArray) {
                    _type = ((VarDeclaration)feature).getType();
                    String _arraySize = ArraySizeHelper.getArraySize((IInterfaceElement)((IInterfaceElement)feature));
                    Pair _mappedTo = Pair.of((Object)_type, (Object)_arraySize);
                    _xifexpression = (DataType)TYPE_DECLARATION_CACHE.get((Object)_mappedTo);
                } else {
                    _xifexpression = ((VarDeclaration)feature).getType();
                }
                _switchResult = _xifexpression;
            }
            if (!_matched && feature instanceof STVarDeclaration) {
                STExpression _maxLength;
                _matched = true;
                DataType _xblockexpression = null;
                DataType _switchResult_1 = null;
                DataType type = _type = ((STVarDeclaration)feature).getType();
                boolean _matched_1 = false;
                if (type instanceof AnyStringType && (_maxLength = ((STVarDeclaration)feature).getMaxLength()) instanceof STNumericLiteral) {
                    _matched_1 = true;
                    _switchResult_1 = STCoreUtil.newStringType((AnyStringType)type, STCoreUtil.asConstantInt(((STVarDeclaration)feature).getMaxLength()));
                }
                if (!_matched_1 && type instanceof DataType) {
                    _matched_1 = true;
                    _switchResult_1 = type;
                }
                DataType type_1 = _switchResult_1;
                DataType _xifexpression = null;
                boolean _isArray = ((STVarDeclaration)feature).isArray();
                if (_isArray) {
                    List _xifexpression_1 = null;
                    boolean _isEmpty = ((STVarDeclaration)feature).getRanges().isEmpty();
                    if (_isEmpty) {
                        Functions.Function1 _function = it -> DataFactory.eINSTANCE.createSubrange();
                        _xifexpression_1 = ListExtensions.map(((STVarDeclaration)feature).getCount(), (Functions.Function1)_function);
                    } else {
                        Functions.Function1 _function_1 = it -> STCoreUtil.toSubrange(it);
                        _xifexpression_1 = ListExtensions.map(((STVarDeclaration)feature).getRanges(), (Functions.Function1)_function_1);
                    }
                    _xifexpression = STCoreUtil.newArrayType(type_1, _xifexpression_1);
                } else {
                    _xifexpression = type_1;
                }
                _xblockexpression = _xifexpression;
                _switchResult = _xblockexpression;
            }
            if (!_matched && feature instanceof AdapterDeclaration) {
                _matched = true;
                AdapterFB _adapterFB = ((AdapterDeclaration)feature).getAdapterFB();
                FBType _type2 = null;
                if (_adapterFB != null) {
                    _type2 = _adapterFB.getType();
                }
                _switchResult = _type2;
            }
            if (!_matched && feature instanceof ITypedElement) {
                _matched = true;
                _switchResult = ((ITypedElement)feature).getType();
            }
            if (!_matched) {
                _switchResult = null;
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ArrayType newArrayType(DataType arrayBaseType, Subrange ... arraySubranges) {
        return STCoreUtil.newArrayType(arrayBaseType, (Iterable)Conversions.doWrapArray((Object)arraySubranges));
    }

    public static ArrayType newArrayType(DataType arrayBaseType, Iterable<Subrange> arraySubranges) {
        ArrayType _xifexpression = null;
        if (arrayBaseType != null) {
            ArrayType _createArrayType = DataFactory.eINSTANCE.createArrayType();
            Procedures.Procedure1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("ARRAY [");
                Functions.Function1 _function_1 = it_1 -> {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    if (it_1.isSetLowerLimit() && it_1.isSetUpperLimit()) {
                        int _lowerLimit = it_1.getLowerLimit();
                        _builder_1.append((Object)_lowerLimit);
                        _builder_1.append("..");
                        int _upperLimit = it_1.getUpperLimit();
                        _builder_1.append((Object)_upperLimit);
                    } else {
                        _builder_1.append("*");
                    }
                    return _builder_1.toString();
                };
                String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)arraySubranges, (Functions.Function1)_function_1), (CharSequence)", ");
                _builder.append(_join);
                _builder.append("] OF ");
                String _name = arrayBaseType.getName();
                _builder.append(_name);
                it.setName(_builder.toString());
                it.setBaseType(arrayBaseType);
                Iterables.addAll((Collection)it.getSubranges(), (Iterable)arraySubranges);
            };
            _xifexpression = (ArrayType)ObjectExtensions.operator_doubleArrow((Object)_createArrayType, (Procedures.Procedure1)_function);
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public static Subrange toSubrange(STExpression expr) {
        Subrange _xtrycatchfinallyexpression = null;
        try {
            Subrange _switchResult = null;
            boolean _matched = false;
            if (expr instanceof STBinaryExpression) {
                boolean _tripleEquals;
                STBinaryOperator _op = ((STBinaryExpression)expr).getOp();
                boolean bl = _tripleEquals = _op == STBinaryOperator.RANGE;
                if (_tripleEquals) {
                    _matched = true;
                    _switchResult = STCoreUtil.newSubrange(STCoreUtil.asConstantInt(((STBinaryExpression)expr).getLeft()), STCoreUtil.asConstantInt(((STBinaryExpression)expr).getRight()));
                }
            }
            if (!_matched) {
                int _asConstantInt = STCoreUtil.asConstantInt(expr);
                int _minus = _asConstantInt - 1;
                _switchResult = STCoreUtil.newSubrange(0, _minus);
            }
            _xtrycatchfinallyexpression = _switchResult;
        }
        catch (Throwable _t) {
            if (_t instanceof ArithmeticException) {
                _xtrycatchfinallyexpression = DataFactory.eINSTANCE.createSubrange();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    public static AnyStringType newStringType(AnyStringType template, int maxLengthValue) {
        AnyStringType _xifexpression = null;
        if (template != null) {
            EObject _create = DataFactory.eINSTANCE.create(template.eClass());
            Procedures.Procedure1 _function = it -> {
                StringConcatenation _builder = new StringConcatenation();
                String _name = template.getName();
                _builder.append(_name);
                _builder.append("[");
                _builder.append((Object)maxLengthValue);
                _builder.append("]");
                it.setName(_builder.toString());
                it.setMaxLength(maxLengthValue);
            };
            _xifexpression = (AnyStringType)ObjectExtensions.operator_doubleArrow((Object)((AnyStringType)_create), (Procedures.Procedure1)_function);
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public static int asConstantInt(STExpression expr) {
        Object value;
        if (expr instanceof STNumericLiteral && (value = ((STNumericLiteral)expr).getValue()) instanceof BigInteger) {
            return ((BigInteger)value).intValueExact();
        }
        throw new ArithmeticException("Not a constant integer");
    }

    public static Subrange newSubrange(int lower, int upper) {
        Subrange _createSubrange = DataFactory.eINSTANCE.createSubrange();
        Procedures.Procedure1 _function = it -> {
            it.setLowerLimit(lower);
            it.setUpperLimit(upper);
        };
        return (Subrange)ObjectExtensions.operator_doubleArrow((Object)_createSubrange, (Procedures.Procedure1)_function);
    }

    public static DataType getCompatibleType(DataType type, DataType other) {
        DataType _xifexpression = null;
        if (type == null) {
            _xifexpression = other;
        } else {
            DataType _xifexpression_1 = null;
            if (other == null) {
                _xifexpression_1 = type;
            } else {
                DataType _xifexpression_2 = null;
                if (type.isAssignableFrom(other) || other.isAssignableFrom(type)) {
                    _xifexpression_2 = type;
                } else {
                    DataType _xifexpression_3 = null;
                    if (type instanceof AnyUnsignedType && (STCoreUtil.isAssignableFrom(type, (DataType)STCoreUtil.getEquivalentAnyUnsignedType((LibraryElement)other)) || STCoreUtil.isAssignableFrom((DataType)STCoreUtil.getEquivalentAnyUnsignedType((LibraryElement)other), type))) {
                        _xifexpression_3 = type;
                    } else {
                        DataType _xifexpression_4 = null;
                        _xifexpression_4 = type instanceof AnyBitType && (STCoreUtil.isAssignableFrom(type, (DataType)STCoreUtil.getEquivalentAnyBitType((LibraryElement)other)) || STCoreUtil.isAssignableFrom((DataType)STCoreUtil.getEquivalentAnyBitType((LibraryElement)other), type)) ? type : other;
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static boolean isAssignableFrom(DataType first, DataType second) {
        return first != null && first.isAssignableFrom(second);
    }

    public static AnyNumType getEquivalentAnyNumType(LibraryElement type) {
        SintType _switchResult = null;
        boolean _matched = false;
        if (type instanceof BoolType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.SINT;
        }
        if (!_matched && type instanceof ByteType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.USINT;
        }
        if (!_matched && type instanceof WordType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.UINT;
        }
        if (!_matched && type instanceof DwordType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.UDINT;
        }
        if (!_matched && type instanceof LwordType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.ULINT;
        }
        if (!_matched && type instanceof AnyNumType) {
            _matched = true;
            _switchResult = (AnyNumType)type;
        }
        return _switchResult;
    }

    public static AnyUnsignedType getEquivalentAnyUnsignedType(LibraryElement type) {
        UsintType _switchResult = null;
        boolean _matched = false;
        if (type instanceof SintType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.USINT;
        }
        if (!_matched && type instanceof IntType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.UINT;
        }
        if (!_matched && type instanceof DintType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.UDINT;
        }
        if (!_matched && type instanceof LintType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.ULINT;
        }
        if (!_matched && type instanceof AnyUnsignedType) {
            _matched = true;
            _switchResult = (AnyUnsignedType)type;
        }
        return _switchResult;
    }

    public static AnyBitType getEquivalentAnyBitType(LibraryElement type) {
        ByteType _switchResult = null;
        boolean _matched = false;
        if (type instanceof SintType) {
            _matched = true;
        }
        if (!_matched && type instanceof UsintType) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = IecTypes.ElementaryTypes.BYTE;
        }
        if (!_matched) {
            if (type instanceof IntType) {
                _matched = true;
            }
            if (!_matched && type instanceof UintType) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = IecTypes.ElementaryTypes.WORD;
            }
        }
        if (!_matched) {
            if (type instanceof DintType) {
                _matched = true;
            }
            if (!_matched && type instanceof UdintType) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = IecTypes.ElementaryTypes.DWORD;
            }
        }
        if (!_matched) {
            if (type instanceof LintType) {
                _matched = true;
            }
            if (!_matched && type instanceof UlintType) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = IecTypes.ElementaryTypes.LWORD;
            }
        }
        if (!_matched && type instanceof AnyBitType) {
            _matched = true;
            _switchResult = (AnyBitType)type;
        }
        return _switchResult;
    }

    public static DataType getEquivalentAnyLDateType(LibraryElement type) {
        LdateType _switchResult = null;
        boolean _matched = false;
        if (type instanceof DateType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.LDATE;
        }
        if (!_matched && type instanceof TimeOfDayType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.LTOD;
        }
        if (!_matched && type instanceof DateAndTimeType) {
            _matched = true;
            _switchResult = IecTypes.ElementaryTypes.LDT;
        }
        if (!_matched && type instanceof DataType) {
            _matched = true;
            _switchResult = (DataType)type;
        }
        return _switchResult;
    }

    public static boolean isInstanceofAnySimpleDateType(LibraryElement type) {
        return type instanceof DateType || type instanceof LdateType;
    }

    public static boolean isInstanceofAnyTimeOfDayType(LibraryElement type) {
        return type instanceof TimeOfDayType || type instanceof LtodType;
    }

    public static boolean isInstanceofAnyDateAndTimeType(LibraryElement type) {
        return type instanceof DateAndTimeType || type instanceof LdtType;
    }

    public static boolean isInstanceofAnySDateType(LibraryElement type) {
        return type instanceof DateType || type instanceof TimeOfDayType || type instanceof DateAndTimeType;
    }

    public static boolean isInstanceofAnyLDateType(LibraryElement type) {
        return type instanceof LdateType || type instanceof LtodType || type instanceof LdtType;
    }

    public static DataType commonSubtype(DataType type1, DataType type2) {
        DataType _xifexpression = null;
        if (type1 == null) {
            _xifexpression = type2;
        } else {
            DataType _xifexpression_1 = null;
            if (type2 == null) {
                _xifexpression_1 = type1;
            } else {
                DataType _xifexpression_2 = null;
                boolean _isAssignableFrom = type1.isAssignableFrom(type2);
                if (_isAssignableFrom) {
                    _xifexpression_2 = type2;
                } else {
                    Object _xifexpression_3 = null;
                    boolean _isAssignableFrom_1 = type2.isAssignableFrom(type1);
                    _xifexpression_3 = _isAssignableFrom_1 ? type1 : null;
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static boolean hasCommonSupertype(LibraryElement type1, LibraryElement type2) {
        boolean _xifexpression = false;
        boolean _equals = Objects.equals(type1, type2);
        if (_equals) {
            _xifexpression = true;
        } else {
            boolean _xifexpression_1 = false;
            if (type1 instanceof DataType) {
                boolean _xifexpression_2 = false;
                if (type2 instanceof DataType) {
                    boolean _xifexpression_3 = false;
                    boolean _isAssignableFrom = ((DataType)type1).isAssignableFrom((DataType)type2);
                    if (_isAssignableFrom) {
                        _xifexpression_3 = true;
                    } else {
                        boolean _xifexpression_4 = false;
                        boolean _isAssignableFrom_1 = ((DataType)type2).isAssignableFrom((DataType)type1);
                        _xifexpression_4 = _isAssignableFrom_1;
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                } else {
                    _xifexpression_2 = false;
                }
                _xifexpression_1 = _xifexpression_2;
            } else {
                _xifexpression_1 = false;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static boolean isAnyVariableReference(STExpression expr) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (expr instanceof STFeatureExpression) {
            _matched = true;
            _switchResult = STCoreUtil.isAnyTypeVariable(((STFeatureExpression)expr).getFeature());
        }
        if (!_matched && expr instanceof STMemberAccessExpression) {
            _matched = true;
            _switchResult = STCoreUtil.isAnyVariableReference(((STMemberAccessExpression)expr).getMember());
        }
        if (!_matched && expr instanceof STArrayAccessExpression) {
            _matched = true;
            _switchResult = STCoreUtil.isAnyVariableReference(((STArrayAccessExpression)expr).getReceiver());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isAnyTypeVariable(INamedElement element) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (element instanceof VarDeclaration) {
            _matched = true;
            _switchResult = IecTypes.GenericTypes.isAnyType((DataType)((VarDeclaration)element).getType());
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isAnyType(INamedElement element) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (element instanceof DataType) {
            _matched = true;
            _switchResult = IecTypes.GenericTypes.isAnyType((DataType)((DataType)element));
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static EObject getVariableScope(STVarDeclaration decl) {
        EObject _eContainer = null;
        if (decl != null) {
            _eContainer = decl.eContainer();
        }
        EObject _eContainer_1 = null;
        if (_eContainer != null) {
            _eContainer_1 = _eContainer.eContainer();
        }
        return _eContainer_1;
    }

    public static boolean isAncestor(EClassifier clazz, EObject object) {
        boolean _xifexpression = false;
        if (object == null) {
            _xifexpression = false;
        } else {
            boolean _xifexpression_1 = false;
            boolean _isInstance = clazz.isInstance((Object)object);
            _xifexpression_1 = _isInstance ? true : STCoreUtil.isAncestor(clazz, object.eContainer());
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static boolean isSimpleInitialValue(VarDeclaration decl, boolean strict) {
        boolean _isArray;
        boolean _isNullOrEmpty;
        DataType _type;
        boolean _switchResult = false;
        DataType type = _type = decl.getType();
        boolean _matched = false;
        Value _value = decl.getValue();
        String _value_1 = null;
        if (_value != null) {
            _value_1 = _value.getValue();
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1)) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && (_isArray = decl.isArray())) {
            _matched = true;
            _switchResult = STCoreUtil.isSimpleArrayValue(decl.getValue().getValue(), strict);
        }
        if (!_matched && type instanceof AnyElementaryType) {
            _matched = true;
            _switchResult = STCoreUtil.isSimpleValue(decl.getValue().getValue(), type, strict);
        }
        if (!_matched && type instanceof DirectlyDerivedType) {
            _matched = true;
            _switchResult = STCoreUtil.isSimpleValue(decl.getValue().getValue(), ((DirectlyDerivedType)type).getBaseType(), strict);
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isSimpleAttributeValue(Attribute attr, boolean strict) {
        DataType _type;
        boolean _switchResult = false;
        DataType type = _type = attr.getType();
        boolean _matched = false;
        if (type instanceof AnyElementaryType) {
            _matched = true;
            _switchResult = STCoreUtil.isSimpleValue(attr.getValue(), type, strict);
        }
        if (!_matched && type instanceof DirectlyDerivedType) {
            _matched = true;
            _switchResult = STCoreUtil.isSimpleValue(attr.getValue(), ((DirectlyDerivedType)type).getBaseType(), strict);
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isSimpleValue(String value, DataType type, boolean strict) {
        boolean _xifexpression = false;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)value);
        if (_isNullOrEmpty) {
            _xifexpression = true;
        } else {
            boolean _xtrycatchfinallyexpression = false;
            try {
                boolean _xblockexpression = false;
                new TypedValueConverter(type, strict).toValue(value);
                _xtrycatchfinallyexpression = _xblockexpression = true;
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    _xtrycatchfinallyexpression = false;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            _xifexpression = _xtrycatchfinallyexpression;
        }
        return _xifexpression;
    }

    public static boolean isSimpleArrayValue(String value, boolean strict) {
        boolean _xifexpression = false;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)value);
        _xifexpression = _isNullOrEmpty ? true : !strict && SIMPLE_ARRAY_PATTERN.matcher(value).matches();
        return _xifexpression;
    }

    @XbaseGenerated
    static INamedElement getParameter(STCallArgument argument) {
        if (argument instanceof STCallNamedInputArgument) {
            return STCoreUtil._getParameter((STCallNamedInputArgument)argument);
        }
        if (argument instanceof STCallNamedOutputArgument) {
            return STCoreUtil._getParameter((STCallNamedOutputArgument)argument);
        }
        if (argument instanceof STCallUnnamedArgument) {
            return STCoreUtil._getParameter((STCallUnnamedArgument)argument);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(argument).toString());
    }
}

