/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.ui.handler.AbstractDeploymentCommand;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.gef.EditPart;

public class DeleteResourceHandler
extends AbstractDeploymentCommand {
    private Resource resource;

    @Override
    protected boolean prepareParametersToExecute(Object element) {
        this.setDevice(null);
        if (element instanceof Resource) {
            Resource resourceElement;
            this.resource = resourceElement = (Resource)element;
            this.setDevice(resourceElement.getDevice());
            return this.getDevice() != null;
        }
        if (element instanceof EditPart) {
            EditPart editPart = (EditPart)element;
            return this.prepareParametersToExecute(editPart.getModel());
        }
        return false;
    }

    @Override
    protected void executeCommand(IDeviceManagementInteractor executor) throws DeploymentException {
        executor.deleteResource(this.resource.getName());
    }

    @Override
    protected void manageExecutorError() {
        DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox((Device)this.getDevice(), (Resource)this.resource);
    }

    @Override
    protected String getErrorMessageHeader() {
        return Messages.DeleteResourceHandler_DeleteResourceError;
    }

    @Override
    protected String getCurrentElementName() {
        return MessageFormat.format(Messages.DeleteResourceHandler_Resource, this.resource.getName());
    }
}

