/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.topdownpacking;

import java.util.List;
import org.eclipse.elk.alg.topdownpacking.GridElkNode;
import org.eclipse.elk.alg.topdownpacking.INodeArranger;
import org.eclipse.elk.alg.topdownpacking.NodeArrangementStrategy;
import org.eclipse.elk.alg.topdownpacking.TopdownPackingPhases;
import org.eclipse.elk.alg.topdownpacking.options.TopdownpackingOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.ITopdownLayoutProvider;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class TopdownpackingLayoutProvider
extends AbstractLayoutProvider
implements ITopdownLayoutProvider {
    private final AlgorithmAssembler<TopdownPackingPhases, GridElkNode> algorithmAssembler = AlgorithmAssembler.create(TopdownPackingPhases.class);

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        GridElkNode wrappedGraph = new GridElkNode(layoutGraph);
        List<ILayoutProcessor<GridElkNode>> algorithm = this.assembleAlgorithm(wrappedGraph);
        progressMonitor.begin("Topdown Packing", (float)algorithm.size());
        for (ILayoutProcessor<GridElkNode> processor : algorithm) {
            processor.process((Object)wrappedGraph, progressMonitor.subTask(1.0f));
        }
        progressMonitor.done();
    }

    public List<ILayoutProcessor<GridElkNode>> assembleAlgorithm(GridElkNode graph) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)TopdownPackingPhases.P1_NODE_ARRANGEMENT, (ILayoutPhaseFactory)graph.getProperty(TopdownpackingOptions.NODE_ARRANGEMENT_STRATEGY));
        this.algorithmAssembler.setPhase((Enum)TopdownPackingPhases.P2_WHITESPACE_ELIMINATION, (ILayoutPhaseFactory)graph.getProperty(TopdownpackingOptions.WHITESPACE_ELIMINATION_STRATEGY));
        return this.algorithmAssembler.build((Object)graph);
    }

    public KVector getPredictedGraphSize(ElkNode graph) {
        INodeArranger nodePlacer = (INodeArranger)((NodeArrangementStrategy)((Object)graph.getProperty(TopdownpackingOptions.NODE_ARRANGEMENT_STRATEGY))).create();
        return nodePlacer.getPredictedSize(graph);
    }
}

