/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.nebula.widgets.grid.DataVisualizer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GridUtils {
    private static final String INDET_PROPERTY = "{http://xml.apache.org/xslt}indent-amount";
    private static final String INDENT_VALUE = "2";
    private static final String INDENT_ACCEPTED_VALUE = "yes";
    private static final String GRID_TAG = "grid";
    private static final String HEADER_TAG = "header";
    private static final String COLUMN_TAG = "column";
    private static final String CHILDREN_TAG = "children";
    private static final String ROWS_TAG = "rows";
    private static final String ROW_TAG = "row";
    private static final String ID_TAG = "id";

    public static void gridToXml(Grid grid, OutputStream outputStream) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        try {
            docFactory.setFeature(FEATURE, true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("ParserConfigurationException was thrown. The feature '" + FEATURE + "' is not supported by your XML processor.", e);
        }
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement(GRID_TAG);
        doc.appendChild(rootElement);
        GridColumn[] columnsArray = grid.getColumns();
        Element header = doc.createElement(HEADER_TAG);
        rootElement.appendChild(header);
        int column = 0;
        while (column < columnsArray.length) {
            Element columnElement = doc.createElement(COLUMN_TAG);
            columnElement.appendChild(doc.createTextNode(columnsArray[column].getText()));
            header.appendChild(columnElement);
            Attr columnNumber = doc.createAttribute(ID_TAG);
            columnNumber.setValue(Integer.toString(column));
            columnElement.setAttributeNode(columnNumber);
            ++column;
        }
        GridItem[] itemsList = grid.getItems();
        DataVisualizer dataVisualizer = grid.getDataVisualizer();
        Element rowsElement = doc.createElement(ROWS_TAG);
        rootElement.appendChild(rowsElement);
        GridUtils.writeChildren(doc, rowsElement, columnsArray, itemsList, dataVisualizer, 0);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", INDENT_ACCEPTED_VALUE);
        transformer.setOutputProperty(INDET_PROPERTY, INDENT_VALUE);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        transformer.transform(source, result);
    }

    private static void writeChildren(Document doc, Element rootElement, GridColumn[] columnsList, GridItem[] itemsArray, DataVisualizer dataVisualizer, int level) {
        int row = 0;
        while (row < itemsArray.length) {
            GridItem gridItem = itemsArray[row];
            if (gridItem.isVisible() && gridItem.getLevel() == level) {
                Element rowElement = GridUtils.writeGridItemInformation(doc, rootElement, columnsList, dataVisualizer, gridItem);
                GridItem[] items = gridItem.getItems();
                if (items.length > 0) {
                    Element childrenElement = doc.createElement(CHILDREN_TAG);
                    rowElement.appendChild(childrenElement);
                    GridUtils.writeChildren(doc, childrenElement, columnsList, items, gridItem.getParent().getDataVisualizer(), level + 1);
                }
            }
            ++row;
        }
    }

    private static Element writeGridItemInformation(Document doc, Element rootElement, GridColumn[] columnsList, DataVisualizer dataVisualizer, GridItem item) {
        Element rowElement = doc.createElement(ROW_TAG);
        rootElement.appendChild(rowElement);
        int column = 0;
        while (column < columnsList.length) {
            String text = dataVisualizer.getText(item, column);
            if (text != null) {
                Element columnElement = doc.createElement(COLUMN_TAG);
                columnElement.appendChild(doc.createTextNode(text));
                rowElement.appendChild(columnElement);
                Attr columnNumber = doc.createAttribute(ID_TAG);
                columnNumber.setValue(Integer.toString(column));
                columnElement.setAttributeNode(columnNumber);
            }
            ++column;
        }
        return rowElement;
    }
}

