/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring.ProviderDocumentChange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.xtext.resource.IGlobalServiceProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRefactoringDocumentProvider;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;
import org.eclipse.xtext.util.internal.Nullable;

public class STCoreRefactoringDocumentProvider
extends DefaultRefactoringDocumentProvider {
    @Inject(optional=true)
    @Nullable
    private IWorkbench workbench;
    @Inject
    private IGlobalServiceProvider globalServiceProvider;

    public IRefactoringDocument get(URI uri, final StatusWrapper status) {
        URI resourceURI = uri.trimFragment();
        final IFileEditorInput fileEditorInput = this.getEditorInput(resourceURI, status);
        if (fileEditorInput != null) {
            IFile file = fileEditorInput.getFile();
            IPath redirectedPath = this.getChangeRedirector().getRedirectedPath(file.getFullPath());
            IFile redirectedFile = file.getWorkspace().getRoot().getFile(redirectedPath);
            if (redirectedFile.equals((Object)file)) {
                IDocumentProvider documentProvider;
                ITextEditor editor;
                if (this.workbench != null && (editor = (ITextEditor)new DisplayRunnableWithResult<ITextEditor>(){

                    protected ITextEditor run() throws Exception {
                        IWorkbenchWindow activeWorkbenchWindow = STCoreRefactoringDocumentProvider.this.workbench.getActiveWorkbenchWindow();
                        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                        ITextEditor editor = (ITextEditor)Adapters.adapt((Object)activePage.findEditor((IEditorInput)fileEditorInput), ITextEditor.class);
                        if (editor != null) {
                            if (editor instanceof ITextEditorExtension && ((ITextEditorExtension)editor).isEditorInputReadOnly()) {
                                status.add(3, "Editor for {0} is read only", new Object[]{fileEditorInput.getName()});
                            }
                            return editor;
                        }
                        return null;
                    }
                }.syncExec()) != null && (documentProvider = editor.getDocumentProvider()) != null) {
                    return new ProviderDocument(resourceURI, fileEditorInput, documentProvider);
                }
                IDocumentProvider documentProvider2 = this.getDocumentProvider(resourceURI);
                if (documentProvider2 != null) {
                    return new ProviderDocument(resourceURI, fileEditorInput, documentProvider2);
                }
            } else {
                return new DefaultRefactoringDocumentProvider.RedirectedFileDocument(resourceURI, file, redirectedFile, this.getEncodingProvider(resourceURI));
            }
        }
        return null;
    }

    protected IDocumentProvider getDocumentProvider(URI resourceURI) {
        return (IDocumentProvider)this.globalServiceProvider.findService(resourceURI, XtextDocumentProvider.class);
    }

    public static class ProviderDocument
    extends DefaultRefactoringDocumentProvider.AbstractRefactoringDocument {
        private final IFileEditorInput editorInput;
        private final IDocumentProvider documentProvider;

        public ProviderDocument(URI resourceURI, IFileEditorInput editorInput, IDocumentProvider documentProvider) {
            super(resourceURI);
            this.editorInput = editorInput;
            this.documentProvider = documentProvider;
        }

        public IFileEditorInput getEditorInput() {
            return this.editorInput;
        }

        public IDocumentProvider getDocumentProvider() {
            return this.documentProvider;
        }

        public Change createChange(String name, TextEdit textEdit) {
            ProviderDocumentChange documentChange = new ProviderDocumentChange(name, this.editorInput, this.documentProvider);
            documentChange.setEdit(textEdit);
            documentChange.setTextType(this.getURI().fileExtension());
            return documentChange;
        }

        public String getOriginalContents() {
            try {
                this.documentProvider.connect((Object)this.editorInput);
                IDocument document = this.documentProvider.getDocument((Object)this.editorInput);
                if (document == null) {
                    throw new IllegalStateException("Couldn't acquire document");
                }
                String string = document.get();
                return string;
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
            finally {
                this.documentProvider.disconnect((Object)this.editorInput);
            }
        }
    }
}

