/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.hyperlinking;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.AbstractHyperlink;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkAcceptor;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class STAlgorithmHyperlinkHelper
extends HyperlinkHelper {
    public void createHyperlinksByOffset(XtextResource resource, int offset, IHyperlinkAcceptor acceptor) {
        EObject target;
        INode node = this.getEObjectAtOffsetHelper().getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (node != null && (target = this.getEObjectAtOffsetHelper().getCrossReferencedElement(node)) != null && !target.eIsProxy()) {
            if (target instanceof FB) {
                this.createHyperlinksToType(resource, node, ((FB)target).getType(), acceptor);
            } else if (target instanceof Event && target.eContainer() instanceof InterfaceList && target.eContainer().eContainer() instanceof FBType) {
                this.createHyperlinksToType(resource, node, (FBType)target.eContainer().eContainer(), acceptor);
            } else if (target instanceof AdapterDeclaration) {
                this.createHyperlinksToType(resource, node, ((AdapterDeclaration)target).getAdapterFB().getType(), acceptor);
            } else {
                this.createHyperlinksTo(resource, node, target, acceptor);
            }
        }
    }

    protected void createHyperlinksToType(XtextResource from, INode node, FBType target, IHyperlinkAcceptor acceptor) {
        super.createHyperlinksTo(from, node, (EObject)target, (IHyperlinkAcceptor)new RenamingHyperlinkAcceptor(new TrimmingHyperlinkAcceptor(acceptor), "Open Type - " + target.getName()));
    }

    protected static class RenamingHyperlinkAcceptor
    implements IHyperlinkAcceptor {
        private final IHyperlinkAcceptor delegate;
        private final String text;

        protected RenamingHyperlinkAcceptor(IHyperlinkAcceptor acceptor, String text) {
            this.delegate = acceptor;
            this.text = text;
        }

        public void accept(IHyperlink hyperlink) {
            if (hyperlink instanceof AbstractHyperlink) {
                ((AbstractHyperlink)hyperlink).setHyperlinkText(this.text);
            }
            this.delegate.accept(hyperlink);
        }
    }

    protected static class TrimmingHyperlinkAcceptor
    implements IHyperlinkAcceptor {
        private final IHyperlinkAcceptor delegate;

        protected TrimmingHyperlinkAcceptor(IHyperlinkAcceptor acceptor) {
            this.delegate = acceptor;
        }

        public void accept(IHyperlink hyperlink) {
            if (hyperlink instanceof XtextHyperlink) {
                XtextHyperlink xtextHyperlink = (XtextHyperlink)hyperlink;
                xtextHyperlink.setURI(xtextHyperlink.getURI().trimFragment());
            }
            this.delegate.accept(hyperlink);
        }
    }
}

