/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.util;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class OperationCommand
extends Command {
    private final IUndoableOperation operation;
    private final boolean critical;

    public OperationCommand(IUndoableOperation operation) {
        this(operation, true);
    }

    public OperationCommand(IUndoableOperation operation, boolean critical) {
        super(operation.getLabel());
        this.operation = operation;
        this.critical = critical;
    }

    public boolean canExecute() {
        return this.operation.canExecute();
    }

    public boolean canRedo() {
        return this.operation.canRedo();
    }

    public boolean canUndo() {
        return this.operation.canUndo();
    }

    public void dispose() {
        this.operation.dispose();
    }

    public void execute() {
        try {
            this.operation.execute(null, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void redo() {
        try {
            this.operation.redo(null, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void undo() {
        try {
            this.operation.undo(null, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Exception e) {
        if (this.critical) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        } else {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
        }
    }

    public IUndoableOperation getOperation() {
        return this.operation;
    }
}

