/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.listeners;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Node;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.handlers.AbstractHierarchyHandler;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.CreateLeafOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.MoveNodeOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.view.PlantHierarchyView;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.CommonViewer;

public class HierarchyManagerDropAssistant
extends CommonDropAdapterAssistant {
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        TreeSelection selection;
        Object object;
        if (operation != 2) {
            return Status.CANCEL_STATUS;
        }
        if (!super.isSupportedType(transferType)) {
            return Status.CANCEL_STATUS;
        }
        if (!(target instanceof Level)) {
            return Status.CANCEL_STATUS;
        }
        Object object2 = this.getCurrentEvent().data;
        if (object2 instanceof TreeSelection && (object = (selection = (TreeSelection)object2).getFirstElement()) instanceof SubApp) {
            SubApp subapp = (SubApp)object;
            RootLevel root = (RootLevel)EcoreUtil.getRootContainer((EObject)((Level)target));
            if (root != null && root.getLevels().stream().anyMatch(l -> HierarchyManagerDropAssistant.hasChild(l, subapp.getQualifiedName()))) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        TreeSelection selection;
        if (aTarget == null || aDropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        boolean isNodeDrop = aDropTargetEvent.data instanceof TreeSelection && (selection = (TreeSelection)aDropTargetEvent.data).getFirstElement() instanceof Node;
        Object object = ((TreeSelection)aDropTargetEvent.data).getFirstElement();
        if (object instanceof SubApp) {
            SubApp subapp = (SubApp)object;
            if (this.getTargetProject() != HierarchyManagerDropAssistant.getSourceProject(subapp)) {
                return Status.CANCEL_STATUS;
            }
        }
        if (!this.isSupportedType(aDropAdapter.getCurrentTransfer())) {
            return Status.CANCEL_STATUS;
        }
        Level parent = null;
        int targetIndex = -1;
        if (aTarget instanceof Level) {
            Level targetLevel;
            parent = targetLevel = (Level)aTarget;
        } else if (aTarget instanceof Leaf) {
            Leaf targetLeaf = (Leaf)aTarget;
            parent = (Level)targetLeaf.eContainer();
        }
        if (parent != null) {
            Level level;
            if (!isNodeDrop) {
                CreateLeafOperation operation = new CreateLeafOperation(parent, (SubApp)((TreeSelection)aDropTargetEvent.data).getFirstElement());
                AbstractHierarchyHandler.executeOperation(operation);
                return Status.OK_STATUS;
            }
            Node node = (Node)((TreeSelection)aDropTargetEvent.data).getFirstElement();
            if (node instanceof Level && HierarchyManagerDropAssistant.checkIfChild(level = (Level)node, (EObject)aTarget)) {
                return Status.CANCEL_STATUS;
            }
            if (aTarget instanceof Leaf) {
                Leaf targetLeaf = (Leaf)aTarget;
                if (node instanceof Leaf || node instanceof Level) {
                    targetIndex = ((Level)targetLeaf.eContainer()).getChildren().indexOf((Object)targetLeaf);
                }
            }
            MoveNodeOperation operation = new MoveNodeOperation((EObject)parent, node, targetIndex);
            AbstractHierarchyHandler.executeOperation(operation);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        TreeSelection selection;
        Object object = this.getCurrentEvent().data;
        return object instanceof TreeSelection && ((selection = (TreeSelection)object).getFirstElement() instanceof Node || selection.getFirstElement() instanceof SubApp) && super.isSupportedType(aTransferType);
    }

    private IProject getTargetProject() {
        return ((PlantHierarchyView)((CommonViewer)((NavigatorContentService)this.getContentService()).getViewer()).getCommonNavigator()).getCurrentProject();
    }

    private static IProject getSourceProject(SubApp subapp) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)subapp);
        if (rootContainer instanceof LibraryElement) {
            LibraryElement libEl = (LibraryElement)rootContainer;
            return libEl.getTypeEntry().getFile().getProject();
        }
        return null;
    }

    private static boolean checkIfChild(Level source, EObject target) {
        Level level;
        if (target instanceof RootLevel) {
            return false;
        }
        if (target instanceof Level && source == (level = (Level)target)) {
            return true;
        }
        return HierarchyManagerDropAssistant.checkIfChild(source, target.eContainer());
    }

    private static boolean hasChild(Level level, String subappName) {
        return level.getChildren().stream().anyMatch(node -> {
            Level l;
            if (node instanceof Leaf) {
                Leaf leaf = (Leaf)node;
                return leaf.getRef().equals(subappName);
            }
            return node instanceof Level && HierarchyManagerDropAssistant.hasChild(l = (Level)node, subappName);
        });
    }
}

