/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public class ForteTypeNameCreator {
    public static String getForteTypeName(FBNetworkElement fb) {
        if (fb != null && fb.getTypeEntry() != null) {
            if (fb instanceof ConfigurableFB) {
                ConfigurableFB confFB = (ConfigurableFB)fb;
                return ForteTypeNameCreator.getConfigureFBType(confFB);
            }
            return ForteTypeNameCreator.getTypeName(fb);
        }
        return "";
    }

    private static String getTypeName(FBNetworkElement fb) {
        return ForteTypeNameCreator.convertFullTypeNameToFORTE(fb.getFullTypeName());
    }

    private static String getConfigureFBType(ConfigurableFB confFB) {
        DataType dt = confFB.getDataType();
        Object typeName = ForteTypeNameCreator.getTypeName((FBNetworkElement)confFB);
        if (dt != null) {
            typeName = (String)typeName + "_1" + ForteTypeNameCreator.convertFullTypeNameToFORTE(PackageNameHelper.getFullTypeName((LibraryElement)dt));
        }
        return typeName;
    }

    private static String convertFullTypeNameToFORTE(String fullTypeName) {
        return fullTypeName.replace(':', '_');
    }

    private ForteTypeNameCreator() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

