/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.util.Objects;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.IDeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.IContainerWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;

public abstract class AbstractContainerWatch
extends DeploymentDebugElement
implements IContainerWatch {
    protected final String name;
    protected final ITypedElement element;
    protected final String qualifiedName;
    protected final Resource resource;

    protected AbstractContainerWatch(String name, ITypedElement element, IDeploymentDebugTarget target) {
        super(target);
        this.name = name;
        this.element = element;
        this.qualifiedName = element.getQualifiedName();
        this.resource = DeploymentDebugWatchUtils.getResource((INamedElement)element);
    }

    @Override
    public void addWatch() throws DebugException {
        for (IWatch watch : this.getSubWatches()) {
            watch.addWatch();
        }
    }

    @Override
    public void removeWatch() throws DebugException {
        for (IWatch watch : this.getSubWatches()) {
            watch.removeWatch();
        }
    }

    @Override
    public void updateValue(DeploymentDebugWatchData watchData) {
        for (IWatch watch : this.getSubWatches()) {
            watch.updateValue(watchData);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getSubWatches().stream().allMatch(IWatch::isAlive);
    }

    public String getReferenceTypeName() {
        return this.element.getTypeName();
    }

    public boolean hasValueChanged() {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        throw AbstractContainerWatch.createUnsupportedOperationException();
    }

    public void setValue(IValue value) throws DebugException {
        throw AbstractContainerWatch.createUnsupportedOperationException();
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) {
        return false;
    }

    public boolean verifyValue(IValue value) {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ITypedElement getWatchedElement() {
        return this.element;
    }

    @Override
    public DeploymentDebugDevice getDebugTarget() {
        return (DeploymentDebugDevice)super.getDebugTarget();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractContainerWatch other = (AbstractContainerWatch)obj;
        return Objects.equals(this.getQualifiedName(), other.getQualifiedName());
    }
}

