# frozen_string_literal: true

class AddTemporaryIndexOnVulnerabilityReads < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = "tmp_idx_vuln_reads_where_dismissal_reason_null"
  DISMISSED_STATE = 2

  def up
    add_concurrent_index(
      :vulnerability_reads,
      %i[id],
      where: "state = #{DISMISSED_STATE} AND dismissal_reason IS NULL",
      name: INDEX_NAME
    )
  end

  def down
    remove_concurrent_index_by_name(
      :vulnerability_reads,
      INDEX_NAME
    )
  end
end
