/* arm.v4a-linux.elf-so_entry.h
   created from arm.v4a-linux.elf-so_entry.bin, 12728 (0x31b8) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V4A_LINUX_ELF_SO_ENTRY_SIZE    12728
#define STUB_ARM_V4A_LINUX_ELF_SO_ENTRY_ADLER32 0xf65134d4
#define STUB_ARM_V4A_LINUX_ELF_SO_ENTRY_CRC32   0xa5f71bd8

unsigned char stub_arm_v4a_linux_elf_so_entry[12728] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 252, 10,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  16,  0, 13,  0,  0,  0,160,227, 30,255, 47,225,  0,  0, 82,227,
/* 0x0040 */   7,  0,  0, 10,  0,192,160,225,  1, 48,209,228,  1, 32, 82,226,
/* 0x0050 */   1, 48,192,228,  3,  0,  0, 26, 12,  0,160,225, 30,255, 47,225,
/* 0x0060 */   0,  0, 82,227, 15,  0,  0, 10,  0,192,160,225,  1, 16,192,228,
/* 0x0070 */   1, 32, 82,226, 12,  0,  0, 26, 12,  0,160,225, 30,255, 47,225,
/* 0x0080 */   0,  0, 82,227, 23,  0,  0, 10,  1, 48,209,228,  1, 32, 82,226,
/* 0x0090 */   1, 48,192,228, 19,  0,  0, 26, 30,255, 47,225,  7,192,160,225,
/* 0x00a0 */ 129,112,160,227,  1,124,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x00b0 */  30,255, 47,225,  7,192,160,225,  6,112,160,227,  0,  0,  0,239,
/* 0x00c0 */  12,112,160,225, 30,255, 47,225,  7,192,160,225,  1,112,160,227,
/* 0x00d0 */   0,  0,  0,239, 12,112,160,225, 30,255, 47,225,  7,192,160,225,
/* 0x00e0 */ 148,112,160,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x00f0 */   7,192,160,225,118,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0100 */  30,255, 47,225,  7,192,160,225, 93,112,160,227,  0,  0,  0,239,
/* 0x0110 */  12,112,160,225, 30,255, 47,225,  7,192,160,225, 20,112,160,227,
/* 0x0120 */   0,  0,  0,239, 12,112,160,225, 30,255, 47,225,  7,192,160,225,
/* 0x0130 */  19,112,160,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x0140 */   7,192,160,225, 39,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0150 */  30,255, 47,225,  7,192,160,225,  5,112,160,227,  0,  0,  0,239,
/* 0x0160 */  12,112,160,225, 30,255, 47,225,  7,192,160,225, 66,112,160,227,
/* 0x0170 */   1,124,135,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x0180 */   7,192,160,225,  3,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0190 */  30,255, 47,225,  7,192,160,225,106,112,160,227,  0,  0,  0,239,
/* 0x01a0 */  12,112,160,225, 30,255, 47,225,  7,192,160,225,122,112,160,227,
/* 0x01b0 */   0,  0,  0,239, 12,112,160,225, 30,255, 47,225,  7,192,160,225,
/* 0x01c0 */  10,112,160,227,  0,  0,  0,239, 12,112,160,225, 30,255, 47,225,
/* 0x01d0 */   7,192,160,225,  4,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x01e0 */  30,255, 47,225,240,  1,240,231, 30,255, 47,225, 48, 64, 45,233,
/* 0x01f0 */  16, 80,157,229, 12, 64,157,229, 37, 86,160,225,  6,192,192,225,
/* 0x0200 */  12,  0, 64,224, 12, 16,129,224,  7,192,160,225,192,112,160,227,
/* 0x0210 */   0,  0,  0,239, 12,112,160,225, 48,128,189,232, 47,112,114,111,
/* 0x0220 */  99, 47,115,101,108,102, 47, 97,117,120,118,  0,  2,220, 77,226,
/* 0x0230 */  14, 64,160,225,  0, 96,224,227,  6,102,160,225, 99,  0,224,227,
/* 0x0240 */  44, 16, 79,226,  0, 32,160,227,254,255,255,235,  0, 80,160,225,
/* 0x0250 */   0,  0, 16,225,152,  0,  0, 74,  2, 44,160,227, 13, 16,160,225,
/* 0x0260 */   5,  0,160,225,254,255,255,235,  0,  0, 16,225,150,  0,  0, 74,
/* 0x0270 */  13, 16,160,225,  8, 32,145,228,  6, 32, 82,226,148,  0,  0, 10,
/* 0x0280 */   8,  0, 80,226,150,  0,  0, 10,142,  0,  0,234,  4, 96, 17,229,
/* 0x0290 */   6, 96, 66,224,  5,  0,160,225,254,255,255,235,  2,220,141,226,
/* 0x02a0 */   8, 96,141,229,  2,  0,  0,235,254,255,255,234,254,255,255,234,
/* 0x02b0 */  63, 32,  0,226, 31, 48,  0,226, 26,  0, 83,227,  5,  0,  0,154,
/* 0x02c0 */  32,  0, 16,227, 70, 32, 66, 18, 43, 32, 66,  2, 64,  0,130,226,
/* 0x02d0 */  30,255, 47,225,  2,192,160,225, 17,  0,  0,234,  0, 32,208,229,
/* 0x02e0 */  32, 32,130,227,  0, 48,209,229, 32, 48,131,227,  3, 32, 82,224,
/* 0x02f0 */  21,  0,  0, 26,  1,  0,128,226,  1, 16,129,226,  1,192, 76,226,
/* 0x0300 */   1,  0,124,227,  9,  0,  0, 26,  0, 32,160,227,  2,  0,160,225,
/* 0x0310 */  30,255, 47,225,112, 64, 45,233, 64,208, 77,226,  0, 80,160,225,
/* 0x0320 */   1, 96,160,225, 13,  0,160,225,255, 16,160,227, 64, 32,160,227,
/* 0x0330 */ 254,255,255,235,  5,  0,160,225, 13, 16,160,225,254,255,255,235,
/* 0x0340 */   0, 64, 80,226, 41,  0,  0,186,184, 48,221,225, 15, 58,  3,226,
/* 0x0350 */   1,  9, 83,227,  0, 64,160,  3, 53,  0,  0,234,  2,  0,116,227,
/* 0x0360 */  47,  0,  0, 26,  5,  0,160,225,  7, 29,160,227,254,255,255,235,
/* 0x0370 */   0, 64,160,225,  0, 48, 86,226,  1, 48,160, 19,164, 63, 19,224,
/* 0x0380 */   5,  0,160, 17,  4, 16,160, 17,254,255,255, 27,  4,  0,160,225,
/* 0x0390 */  64,208,141,226,112,128,189,232,240, 65, 45,233,  0,112,160,225,
/* 0x03a0 */   1, 96,160,225, 63,  0,  0,235, 47,100, 97,116, 97, 47,100, 97,
/* 0x03b0 */ 116, 97, 47,  0, 14, 16,160,225, 11, 32,160,227,254,255,255,235,
/* 0x03c0 */   0, 64,160,227,  0, 64,192,229,  7,  0,160,225,  1, 16,160,227,
/* 0x03d0 */  23,  0,  0,235, 77,  0,  0,235, 47,112,114,111, 99, 47,115,101,
/* 0x03e0 */ 108,102, 47, 99,109,100,108,105,110,101,  0,  0, 14,128,160,225,
/* 0x03f0 */   8,  0,160,225,  4, 16,160,225,  4, 32,160,225,254,255,255,235,
/* 0x0400 */   0, 64,160,225,  6, 16,160,225,255, 46,160,227, 15, 32,130,226,
/* 0x0410 */ 254,255,255,235,  0, 80,160,225,  4,  0,160,225,254,255,255,235,
/* 0x0420 */   0,  0, 85,227,  8,  0,160,177,254,255,255,187,  0, 48,160,227,
/* 0x0430 */   5, 48,198,231,  0, 48,214,229,  0,  0, 83,227,  6, 16,160,  1,
/* 0x0440 */ 139,  0,  0, 10,  6, 16,160,225,  1, 48,241,229,  0,  0, 83,227,
/* 0x0450 */ 100,  0,  0, 26,139,  0,  0,234,  1, 48,116,229, 47,  0, 83,227,
/* 0x0460 */ 104,  0,  0, 26,  1,128,100,224, 10,  0,135,226,  4, 16,160,225,
/* 0x0470 */   8, 32,160,225,254,255,255,235,  0, 80,160,225,  0, 96,160,227,
/* 0x0480 */   0, 96,192,229,  7,  0,160,225,  6, 16,160,225, 23,  0,  0,235,
/* 0x0490 */  13,  0,112,227,141,  0,  0, 26,126,  0,  0,235, 99,111,109, 46,
/* 0x04a0 */ 116,101,114,109,117,120, 47,102,105,108,101,115,  0,  0,  0,  0,
/* 0x04b0 */  14, 16,160,225, 11,  0,135,226, 16, 32,160,227,254,255,255,235,
/* 0x04c0 */   4, 16,160,225,  8, 32,160,225,254,255,255,235,  0, 80,160,225,
/* 0x04d0 */   0, 96,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x04e0 */ 141,  0,  0,234,  1, 64,160,225,104,  0,  0,234,144,  0,  0,235,
/* 0x04f0 */  47, 99, 97, 99,104,101,  0,  0, 14, 16,160,225,  5,  0,160,225,
/* 0x0500 */   6, 32,160,227,254,255,255,235,  0, 64,160,225,  0, 96,160,227,
/* 0x0510 */   0, 96,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x0520 */ 157,  0,  0,235, 47,117,112,120,  0,  0,  0,  0, 14, 16,160,225,
/* 0x0530 */   4,  0,160,225,  4, 32,160,227,254,255,255,235,  0, 64,160,225,
/* 0x0540 */ 254,255,255,235,  0, 80,160,225,254,255,255,235,  0,  0,196,229,
/* 0x0550 */  37,  3,160,225,254,255,255,235,  1,  0,196,229, 37,  6,160,225,
/* 0x0560 */ 254,255,255,235,  2,  0,196,229,  3, 96,196,229,  6,  0,160,225,
/* 0x0570 */ 240,129,189,232,240, 65, 45,233,  1,218, 77,226, 12,208, 77,226,
/* 0x0580 */   0,112,160,225,  1,128,160,225,  2, 96,160,225,183,  0,  0,235,
/* 0x0590 */ 117,112,120,  0, 14, 64,160,225,  4,  0,160,225, 16, 16,160,227,
/* 0x05a0 */ 254,255,255,235,  0, 80,160,225, 22,  0,112,227,194,  0,  0, 26,
/* 0x05b0 */   4,  0,160,225,  0, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x05c0 */   0,  0, 85,227,214,  0,  0,170,200,  0,  0,235, 47,100,101,118,
/* 0x05d0 */  47,115,104,109,  0,  0,  0,  0, 14,  0,160,225, 65, 24,160,227,
/* 0x05e0 */   2, 16,129,226,  7, 45,160,227,254,255,255,235,  0, 80, 80,226,
/* 0x05f0 */ 214,  0,  0,170,212,  0,  0,235,109,101,109,102,100, 95, 99,114,
/* 0x0600 */ 101, 97,116,101,  0,  0,  0,  0, 14,  0,160,225,254,255,255,235,
/* 0x0610 */  12, 64,141,226,  4,  0,160,225,254,255,255,235,219,  0,  0,235,
/* 0x0620 */  97,110,100,  0, 14,  0,160,225,  4, 16,160,225,  3, 32,160,227,
/* 0x0630 */   7,  0,  0,235,  0,  0, 80,227,237,  0,  0, 10,227,  0,  0,235,
/* 0x0640 */  76,105,110,  0, 14,  0,160,225,  4, 16,160,225,  3, 32,160,227,
/* 0x0650 */   7,  0,  0,235,  0,  0, 80,227,237,  0,  0, 26,130, 48,212,229,
/* 0x0660 */  52,  0, 83,227,  1, 64,160,131, 15,  1,  0,138,  0,  0, 86,227,
/* 0x0670 */ 246,  0,  0, 26,254,255,255,235,  0, 96, 80,226,  2, 49,160,  3,
/* 0x0680 */   1, 42,141,  2, 12, 32,130,  2,195,105,194,  7, 12, 96,141,  2,
/* 0x0690 */  38,  0,117,227, 14,  1,  0, 26,  0,  0, 86,227, 14,  1,  0, 10,
/* 0x06a0 */   0, 48,214,229,  0,  0, 83,227,  3,  1,  0, 26,  6,  0,160,225,
/* 0x06b0 */   2, 27,141,226, 12, 16,129,226, 56,  0,  0,235,  0,  0, 80,227,
/* 0x06c0 */  75,  1,  0,186,  6,  0,160,225,194, 16,160,227,  7, 45,160,227,
/* 0x06d0 */ 254,255,255,235,  0, 80, 80,226,  5,  0,160,177, 75,  1,  0,186,
/* 0x06e0 */   6,  0,160,225,254,255,255,235,  0, 64,160,227, 15,  1,  0,234,
/* 0x06f0 */   0, 64,160,227,  0,  0, 87,227, 22,  1,  0, 10,254,255,255,235,
/* 0x0700 */   0,  0,224,225,  7,  0,  0,224,  7,112, 96,224,  0,128,136,224,
/* 0x0710 */   0,  0, 88,227, 49,  1,  0, 10,  0,  0, 84,227, 32,  1,  0, 10,
/* 0x0720 */   5,  0,160,225,  8, 16,160,225,254,255,255,235,  0,  0, 80,227,
/* 0x0730 */  49,  1,  0,170, 75,  1,  0,234,  5,  0,160,225,  1, 16, 72,226,
/* 0x0740 */   0, 32,160,227,254,255,255,235,  1, 26,224,227,  0, 64,160,227,
/* 0x0750 */   1, 58,141,226, 12, 48,131,226,  1, 64,195,231,  5,  0,160,225,
/* 0x0760 */   1, 16,131,224,  1, 32,160,227,254,255,255,235,  5,  0,160,225,
/* 0x0770 */   4, 16,160,225,  4, 32,160,225,254,255,255,235,  0,  0, 87,227,
/* 0x0780 */   1,192,160,  3, 61,  1,  0, 10,254,255,255,235,  0, 32,160,225,
/* 0x0790 */   0, 48,215,225, 73,  1,  0, 10,  5,  0,160,225,  7, 16,160,225,
/* 0x07a0 */   0, 32, 98,226,254,255,255,235, 73,  1,  0,234,  0, 80,141,229,
/* 0x07b0 */   0, 48,160,227,  4, 48,141,229,  7,  0,160,225,  8, 16,160,225,
/* 0x07c0 */   3, 32,160,227, 12, 48,160,225,254,255,255,235,  1, 10,112,227,
/* 0x07d0 */   1, 48,133,146,  3,  0,128,145, 75,  1,  0,234, 17,192,160,227,
/* 0x07e0 */  61,  1,  0,234, 12,208,141,226,  1,218,141,226,240,129,189,232,
/* 0x07f0 */ 240, 64, 45,233,  8,208, 77,226,  0,112,160,225,  1, 96,160,225,
/* 0x0800 */   4,  0,  0,235,117,112,120,  0, 14, 64,160,225,  4,  0,160,225,
/* 0x0810 */  16, 16,160,227,254,255,255,235,  0, 80,160,225, 22,  0,112,227,
/* 0x0820 */  15,  0,  0, 26,  4,  0,160,225,  0, 16,160,227,254,255,255,235,
/* 0x0830 */   0, 80,160,225,  0,  0, 85,227, 29,  0,  0,170, 21,  0,  0,235,
/* 0x0840 */  47,100,101,118, 47,115,104,109,  0,  0,  0,  0, 14,  0,160,225,
/* 0x0850 */  65, 24,160,227,  2, 16,129,226,  7, 45,160,227,254,255,255,235,
/* 0x0860 */   0, 80, 80,226,  5, 64,160,177, 50,  0,  0,186,  5,  0,160,225,
/* 0x0870 */   6, 16,160,225,254,255,255,235,  0,  0, 80,227,  0, 64,160,177,
/* 0x0880 */  50,  0,  0,186,  0, 80,141,229,  0, 48,160,227,  4, 48,141,229,
/* 0x0890 */   7,  0,160,225,  6, 16,160,225,  3, 32,160,227,  3,  0, 87,225,
/* 0x08a0 */   1, 48,160,  3, 17, 48,160, 19,254,255,255,235,  0, 64,160,225,
/* 0x08b0 */ 254,255,255,235,  4,  0, 80,225,  1, 48,132,130,  3, 64,133,128,
/* 0x08c0 */   4,  0,160,225,  8,208,141,226,240,128,189,232,  0,  0,160,225,
/* 0x08d0 */ 255, 64, 45,233, 12,208, 77,226,124,  0,  0,235,  0,  0,158,229,
/* 0x08e0 */   4,  0,141,229,  4,112,158,229, 12, 64,142,226,  0, 32,160,227,
/* 0x08f0 */   0, 16,160,225,  0,  0,160,227,254,255,255,235,  4, 48,141,226,
/* 0x0900 */  32, 38,160,225,  2, 38,160,225,  0, 32,141,229,  7, 16,160,225,
/* 0x0910 */   2,112, 64,224,  1,112, 71,226,  4,  0,160,225, 50,  0,  0,235,
/* 0x0920 */   0,  0, 80,227, 22,  0,  0, 10,240,  1,240,231,  4, 32,157,229,
/* 0x0930 */   0, 16,157,229,  7,  0,160,225,  0, 96,129,229,254,255,255,235,
/* 0x0940 */   2,  0, 80,225, 30,  0,  0, 10,240,  1,240,231,  0, 80,160,227,
/* 0x0950 */   7, 64,160,225, 18, 48,160,227,  5, 32,160,227,  4, 16,157,229,
/* 0x0960 */   0,  0,157,229,  7,192,160,225,192,112,160,227,  0,  0,  0,239,
/* 0x0970 */  12,112,160,225,  0, 32,157,229,  2,  0, 80,225, 44,  0,  0, 10,
/* 0x0980 */ 240,  1,240,231,  7,  0,160,225,254,255,255,235, 12, 16,141,226,
/* 0x0990 */ 220,  0, 79,226,  0, 32,157,229, 12,240,130,226,  0, 16,129,224,
/* 0x09a0 */  62, 64, 45,233,  0, 80,224,227,  2, 65,160,227, 75,  0,  0,234,
/* 0x09b0 */  26,  0,189,232,  1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,
/* 0x09c0 */  48,128,189,232,  4, 64,148,224, 14,240,160, 17,  1, 64,208,228,
/* 0x09d0 */   4, 64,164,224,  4, 76,176,225, 14,240,160,225,  1, 16,160,227,
/* 0x09e0 */  14,192,160,225, 60,  0,  0,235,  1, 16,177,224, 60,  0,  0,235,
/* 0x09f0 */  68,  0,  0, 58, 12,240,160,225,  1, 48,208,228,  1, 48,194,228,
/* 0x0a00 */  60,  0,  0,235, 73,  0,  0, 42, 66,  0,  0,235,  3, 48, 81,226,
/* 0x0a10 */   0, 16,160,227, 85,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,
/* 0x0a20 */   5, 80,240,225, 55,  0,  0, 10, 60,  0,  0,235,  1, 16,177,224,
/* 0x0a30 */  60,  0,  0,235,  1, 16,177,224, 92,  0,  0, 26, 66,  0,  0,235,
/* 0x0a40 */   2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,
/* 0x0a50 */   1, 16, 81,226,  1, 48,194,228, 94,  0,  0, 42, 75,  0,  0,234,
/* 0x0a60 */   8,  0,189,232,  0,  0,160,225,  3,  0, 64,224,  8,  0,189,232,
/* 0x0a70 */   2,  0,189,232,  3, 32, 66,224,  8,  0,189,232,  0, 32,131,229,
/* 0x0a80 */  30,255, 47,225,  0,  0,224,227,  0,  6,160,225, 30,255, 47,225,
/* 0x0a90 */   0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,
/* 0x0aa0 */   0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,108, 69,
/* 0x0ab0 */  76, 70, 77, 65, 73, 78, 90,  0, 46,114,101,108, 72, 85, 77, 70,
/* 0x0ac0 */  95, 65,  0, 46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,114,
/* 0x0ad0 */ 101,108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,114,
/* 0x0ae0 */ 101,108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108,
/* 0x0af0 */  69, 76, 70, 77, 65, 73, 78, 88,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b20 */   0,  0,  0,  0, 31,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0b30 */   0,  0,  0,  0, 52,  0,  0,  0,116,  2,  0,  0,  0,  0,  0,  0,
/* 0x0b40 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,
/* 0x0b50 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,184, 16,  0,  0,
/* 0x0b60 */ 120,  0,  0,  0, 14,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,
/* 0x0b70 */   8,  0,  0,  0, 44,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0b80 */   0,  0,  0,  0,168,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b90 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,
/* 0x0ba0 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 48, 17,  0,  0,
/* 0x0bb0 */   8,  0,  0,  0, 14,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
/* 0x0bc0 */   8,  0,  0,  0, 55,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0bd0 */   0,  0,  0,  0,172,  2,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x0be0 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 51,  0,  0,  0,
/* 0x0bf0 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 56, 17,  0,  0,
/* 0x0c00 */   8,  0,  0,  0, 14,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,
/* 0x0c10 */   8,  0,  0,  0, 66,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0c20 */   0,  0,  0,  0,176,  2,  0,  0, 64,  5,  0,  0,  0,  0,  0,  0,
/* 0x0c30 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 62,  0,  0,  0,
/* 0x0c40 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 64, 17,  0,  0,
/* 0x0c50 */ 192,  2,  0,  0, 14,  0,  0,  0,  7,  0,  0,  0,  4,  0,  0,  0,
/* 0x0c60 */   8,  0,  0,  0, 82,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0c70 */   0,  0,  0,  0,240,  7,  0,  0,220,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c80 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 78,  0,  0,  0,
/* 0x0c90 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  0,  0,
/* 0x0ca0 */  96,  0,  0,  0, 14,  0,  0,  0,  9,  0,  0,  0,  4,  0,  0,  0,
/* 0x0cb0 */   8,  0,  0,  0, 96,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,
/* 0x0cc0 */   0,  0,  0,  0,204,  8,  0,  0,196,  1,  0,  0,  0,  0,  0,  0,
/* 0x0cd0 */   0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 92,  0,  0,  0,
/* 0x0ce0 */   9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96, 20,  0,  0,
/* 0x0cf0 */ 184,  0,  0,  0, 14,  0,  0,  0, 11,  0,  0,  0,  4,  0,  0,  0,
/* 0x0d00 */   8,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d10 */   0,  0,  0,  0,144, 10,  0,  0,105,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d20 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,
/* 0x0d30 */   2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,124, 13,  0,  0,
/* 0x0d40 */  48,  2,  0,  0, 15,  0,  0,  0,  7,  0,  0,  0,  4,  0,  0,  0,
/* 0x0d50 */  16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d60 */   0,  0,  0,  0,172, 15,  0,  0, 11,  1,  0,  0,  0,  0,  0,  0,
/* 0x0d70 */   0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d90 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,
/* 0x0da0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,
/* 0x0db0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  9,  0,  0,  0,  0,  0,
/* 0x0dc0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 11,  0,  0,  0,  0,  0,
/* 0x0dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,
/* 0x0de0 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,  1,  0,  0,  0,
/* 0x0df0 */ 184,  1,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0, 15,  0,  0,  0,
/* 0x0e00 */ 228,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 22,  0,  0,  0,
/* 0x0e10 */ 196,  1,  0,  0,  0,  0,  0,  0, 16,  0, 11,  0, 38,  0,  0,  0,
/* 0x0e20 */   8,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 45,  0,  0,  0,
/* 0x0e30 */  76,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 53,  0,  0,  0,
/* 0x0e40 */ 208,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 63,  0,  0,  0,
/* 0x0e50 */ 248,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 69,  0,  0,  0,
/* 0x0e60 */ 196,  2,  0,  0,124,  2,  0,  0, 18,  0,  7,  0, 93,  0,  0,  0,
/* 0x0e70 */ 184,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0, 98,  0,  0,  0,
/* 0x0e80 */   0,  0,  0,  0,220,  0,  0,  0, 18,  0,  9,  0,120,  0,  0,  0,
/* 0x0e90 */ 116,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,126,  0,  0,  0,
/* 0x0ea0 */ 156,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,132,  0,  0,  0,
/* 0x0eb0 */ 168,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,142,  0,  0,  0,
/* 0x0ec0 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,157,  0,  0,  0,
/* 0x0ed0 */ 104,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,170,  0,  0,  0,
/* 0x0ee0 */   0,  0,  0,  0,  0,  0,  0,  0, 18,  0, 11,  0,177,  0,  0,  0,
/* 0x0ef0 */  76,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,182,  0,  0,  0,
/* 0x0f00 */ 136,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,189,  0,  0,  0,
/* 0x0f10 */  44,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,196,  0,  0,  0,
/* 0x0f20 */ 208,  0,  0,  0,196,  0,  0,  0, 18,  0, 11,  0,219,  0,  0,  0,
/* 0x0f30 */ 176,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,227,  0,  0,  0,
/* 0x0f40 */ 188,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,233,  0,  0,  0,
/* 0x0f50 */  96,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,238,  0,  0,  0,
/* 0x0f60 */ 148,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,243,  0,  0,  0,
/* 0x0f70 */  52,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,250,  0,  0,  0,
/* 0x0f80 */  32,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,255,  0,  0,  0,
/* 0x0f90 */  12,  1,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,  5,  1,  0,  0,
/* 0x0fa0 */ 128,  0,  0,  0,  0,  0,  0,  0, 16,  0,  1,  0,  0,103,101,116,
/* 0x0fb0 */  95,112, 97,103,101, 95,109, 97,115,107,  0,103,101,116,112,105,
/* 0x0fc0 */ 100,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,
/* 0x0fd0 */ 100,  0,109,101,109, 99,112,121,  0,109,101,109,112, 99,112,121,
/* 0x0fe0 */   0,102,116,114,117,110, 99, 97,116,101,  0,108,115,101,101,107,
/* 0x0ff0 */   0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x1000 */  95, 97,110,100,114,111,105,100,  0,109,109, 97,112,  0,117,112,
/* 0x1010 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,
/* 0x1020 */ 110,117,120,  0,117,110, 97,109,101,  0,119,114,105,116,101,  0,
/* 0x1030 */ 102,100, 97,116, 97,115,121,110, 99,  0,103,101,116, 95,117,112,
/* 0x1040 */ 120,102,110, 95,112, 97,116,104,  0,109,101,109,102,100, 95, 99,
/* 0x1050 */ 114,101, 97,116,101,  0, 95,115,116, 97,114,116,  0,114,101, 97,
/* 0x1060 */ 100,  0,117,110,108,105,110,107,  0,109,101,109,115,101,116,  0,
/* 0x1070 */ 117, 99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,
/* 0x1080 */ 114,101,115,115, 95, 56,  0,109,121, 95, 98,107,112,116,  0,102,
/* 0x1090 */ 115,121,110, 99,  0,115,116, 97,116,  0,101,120,105,116,  0,111,
/* 0x10a0 */ 112,101,110, 97,116,  0,111,112,101,110,  0,109,107,100,105,114,
/* 0x10b0 */   0, 99,108,111,115,101,  0,  0, 12,  0,  0,  0,  1,  1,  0,  0,
/* 0x10c0 */  32,  0,  0,  0,  1,  1,  0,  0, 48,  0,  0,  0,  1,  1,  0,  0,
/* 0x10d0 */  64,  0,  0,  0,  1,  1,  0,  0, 80,  0,  0,  0,  1,  1,  0,  0,
/* 0x10e0 */  96,  0,  0,  0,  1,  1,  0,  0, 20,  2,  0,  0,  1, 31,  0,  0,
/* 0x10f0 */  32,  2,  0,  0,  1,  1,  0,  0, 48,  2,  0,  0,  1, 23,  0,  0,
/* 0x1100 */  56,  2,  0,  0,  1,  1,  0,  0, 72,  2,  0,  0,  1,  1,  0,  0,
/* 0x1110 */  80,  2,  0,  0,  1,  1,  0,  0, 84,  2,  0,  0,  1,  1,  0,  0,
/* 0x1120 */ 100,  2,  0,  0,  1, 34,  0,  0,112,  2,  0,  0,  1,  4,  0,  0,
/* 0x1130 */   0,  0,  0,  0,  1, 14,  0,  0,  0,  0,  0,  0,  1, 16,  0,  0,
/* 0x1140 */  12,  0,  0,  0,  1,  2,  0,  0, 40,  0,  0,  0,  1,  2,  0,  0,
/* 0x1150 */  64,  0,  0,  0,  1,  2,  0,  0, 84,  0,  0,  0,  1,  2,  0,  0,
/* 0x1160 */ 128,  0,  0,  0,  1, 25,  0,  0,140,  0,  0,  0,  1, 29,  0,  0,
/* 0x1170 */ 148,  0,  0,  0,  1,  2,  0,  0,168,  0,  0,  0,  1,  2,  0,  0,
/* 0x1180 */ 176,  0,  0,  0,  1,  2,  0,  0,188,  0,  0,  0,  1, 33,  0,  0,
/* 0x1190 */ 216,  0,  0,  0,  1, 27,  0,  0,244,  0,  0,  0,  1,  2,  0,  0,
/* 0x11a0 */  12,  1,  0,  0,  1, 11,  0,  0, 32,  1,  0,  0,  1,  2,  0,  0,
/* 0x11b0 */  36,  1,  0,  0,  1,  2,  0,  0, 76,  1,  0,  0,  1, 32,  0,  0,
/* 0x11c0 */  96,  1,  0,  0,  1, 23,  0,  0,108,  1,  0,  0,  1, 34,  0,  0,
/* 0x11d0 */ 120,  1,  0,  0,  1, 27,  0,  0,144,  1,  0,  0,  1,  2,  0,  0,
/* 0x11e0 */ 160,  1,  0,  0,  1,  2,  0,  0,164,  1,  0,  0,  1,  2,  0,  0,
/* 0x11f0 */ 176,  1,  0,  0,  1,  2,  0,  0,196,  1,  0,  0,  1, 11,  0,  0,
/* 0x1200 */ 220,  1,  0,  0,  1,  2,  0,  0,228,  1,  0,  0,  1,  2,  0,  0,
/* 0x1210 */ 232,  1,  0,  0,  1,  2,  0,  0, 12,  2,  0,  0,  1, 11,  0,  0,
/* 0x1220 */  24,  2,  0,  0,  1, 11,  0,  0, 44,  2,  0,  0,  1,  2,  0,  0,
/* 0x1230 */  48,  2,  0,  0,  1,  2,  0,  0, 56,  2,  0,  0,  1,  2,  0,  0,
/* 0x1240 */  60,  2,  0,  0,  1,  2,  0,  0, 84,  2,  0,  0,  1, 11,  0,  0,
/* 0x1250 */ 108,  2,  0,  0,  1,  2,  0,  0,112,  2,  0,  0,  1,  2,  0,  0,
/* 0x1260 */ 136,  2,  0,  0,  1, 11,  0,  0,144,  2,  0,  0,  1,  8,  0,  0,
/* 0x1270 */ 152,  2,  0,  0,  1,  2,  0,  0,164,  2,  0,  0,  1,  2,  0,  0,
/* 0x1280 */ 176,  2,  0,  0,  1,  2,  0,  0,220,  2,  0,  0,  1,  2,  0,  0,
/* 0x1290 */ 240,  2,  0,  0,  1, 21,  0,  0,252,  2,  0,  0,  1,  2,  0,  0,
/* 0x12a0 */   8,  3,  0,  0,  1, 21,  0,  0, 20,  3,  0,  0,  1,  2,  0,  0,
/* 0x12b0 */  24,  3,  0,  0,  1,  2,  0,  0, 56,  3,  0,  0,  1, 32,  0,  0,
/* 0x12c0 */  64,  3,  0,  0,  1,  2,  0,  0, 68,  3,  0,  0,  1,  2,  0,  0,
/* 0x12d0 */  92,  3,  0,  0,  1, 27,  0,  0,104,  3,  0,  0,  1, 17,  0,  0,
/* 0x12e0 */ 108,  3,  0,  0,  1,  2,  0,  0,128,  3,  0,  0,  1,  2,  0,  0,
/* 0x12f0 */ 136,  3,  0,  0,  1,  2,  0,  0,140,  3,  0,  0,  1,  2,  0,  0,
/* 0x1300 */ 160,  3,  0,  0,  1,  2,  0,  0,168,  3,  0,  0,  1,  2,  0,  0,
/* 0x1310 */ 184,  3,  0,  0,  1,  2,  0,  0,192,  3,  0,  0,  1,  2,  0,  0,
/* 0x1320 */ 196,  3,  0,  0,  1, 20,  0,  0,228,  3,  0,  0,  1,  2,  0,  0,
/* 0x1330 */ 236,  3,  0,  0,  1,  2,  0,  0,248,  3,  0,  0,  1,  2,  0,  0,
/* 0x1340 */   8,  4,  0,  0,  1,  2,  0,  0, 16,  4,  0,  0,  1,  2,  0,  0,
/* 0x1350 */  32,  4,  0,  0,  1, 32,  0,  0, 44,  4,  0,  0,  1,  2,  0,  0,
/* 0x1360 */  52,  4,  0,  0,  1, 24,  0,  0, 60,  4,  0,  0,  1,  2,  0,  0,
/* 0x1370 */  72,  4,  0,  0,  1,  2,  0,  0, 76,  4,  0,  0,  1,  7,  0,  0,
/* 0x1380 */ 100,  4,  0,  0,  1,  2,  0,  0,108,  4,  0,  0,  1,  2,  0,  0,
/* 0x1390 */ 120,  4,  0,  0,  1, 12,  0,  0,128,  4,  0,  0,  1,  2,  0,  0,
/* 0x13a0 */ 132,  4,  0,  0,  1,  2,  0,  0,148,  4,  0,  0,  1, 13,  0,  0,
/* 0x13b0 */ 184,  4,  0,  0,  1, 18,  0,  0,200,  4,  0,  0,  1, 13,  0,  0,
/* 0x13c0 */ 212,  4,  0,  0,  1,  2,  0,  0,216,  4,  0,  0,  1,  7,  0,  0,
/* 0x13d0 */ 228,  4,  0,  0,  1,  2,  0,  0,244,  4,  0,  0,  1, 18,  0,  0,
/* 0x13e0 */ 248,  4,  0,  0,  1,  2,  0,  0, 24,  5,  0,  0,  1, 15,  0,  0,
/* 0x13f0 */  40,  5,  0,  0,  1,  2,  0,  0, 48,  5,  0,  0,  1,  2,  0,  0,
/* 0x1400 */  16,  0,  0,  0,  1,  3,  0,  0, 36,  0,  0,  0,  1, 21,  0,  0,
/* 0x1410 */  48,  0,  0,  0,  1,  3,  0,  0, 60,  0,  0,  0,  1, 21,  0,  0,
/* 0x1420 */  72,  0,  0,  0,  1,  3,  0,  0, 76,  0,  0,  0,  1,  3,  0,  0,
/* 0x1430 */ 108,  0,  0,  0,  1, 32,  0,  0,120,  0,  0,  0,  1,  3,  0,  0,
/* 0x1440 */ 132,  0,  0,  0,  1, 12,  0,  0,144,  0,  0,  0,  1,  3,  0,  0,
/* 0x1450 */ 184,  0,  0,  0,  1, 15,  0,  0,192,  0,  0,  0,  1,  7,  0,  0,
/* 0x1460 */  12,  0,  0,  0,  1,  1,  0,  0, 44,  0,  0,  0,  1,  9,  0,  0,
/* 0x1470 */  80,  0,  0,  0,  1,  4,  0,  0, 88,  0,  0,  0,  1,  4,  0,  0,
/* 0x1480 */ 112,  0,  0,  0,  1, 18,  0,  0,120,  0,  0,  0,  1,  4,  0,  0,
/* 0x1490 */ 176,  0,  0,  0,  1,  4,  0,  0,188,  0,  0,  0,  1, 34,  0,  0,
/* 0x14a0 */ 224,  0,  0,  0,  1,  4,  0,  0, 24,  1,  0,  0,  1,  4,  0,  0,
/* 0x14b0 */  32,  1,  0,  0,  1,  4,  0,  0, 36,  1,  0,  0,  1,  4,  0,  0,
/* 0x14c0 */  52,  1,  0,  0,  1,  4,  0,  0, 56,  1,  0,  0,  1,  4,  0,  0,
/* 0x14d0 */  60,  1,  0,  0,  1,  4,  0,  0, 72,  1,  0,  0,  1,  4,  0,  0,
/* 0x14e0 */  88,  1,  0,  0,  1,  4,  0,  0, 92,  1,  0,  0,  1,  4,  0,  0,
/* 0x14f0 */ 100,  1,  0,  0,  1,  4,  0,  0,108,  1,  0,  0,  1,  4,  0,  0,
/* 0x1500 */ 112,  1,  0,  0,  1,  4,  0,  0,140,  1,  0,  0,  1,  4,  0,  0,
/* 0x1510 */ 144,  1,  0,  0,  1,  4,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x1520 */ 109, 97,116, 32,101,108,102, 51, 50, 45,108,105,116,116,108,101,
/* 0x1530 */  97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x1540 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1550 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x1560 */  32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x1570 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x1580 */ 108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1590 */  90, 32, 32, 32, 32, 32, 32, 48, 50, 55, 52, 32, 32, 48, 32, 32,
/* 0x15a0 */  48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79,
/* 0x15b0 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 72, 85, 77, 70, 95,
/* 0x15c0 */  65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32,
/* 0x15d0 */  48, 32, 32, 48, 50, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x15e0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 72, 85, 77, 70,
/* 0x15f0 */  95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32,
/* 0x1600 */  32, 48, 32, 32, 48, 50, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1610 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 85, 77, 70,
/* 0x1620 */  95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32, 48, 53, 52, 48, 32,
/* 0x1630 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 98, 48, 32, 32, 50, 42, 42,
/* 0x1640 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x1650 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48,100,
/* 0x1660 */  99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 55,102, 48, 32, 32, 50,
/* 0x1670 */  42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x1680 */  53, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 32,
/* 0x1690 */  48, 49, 99, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 99, 99,
/* 0x16a0 */  32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x16b0 */  10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48,
/* 0x16c0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x16d0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76, 70, 77, 65,
/* 0x16e0 */  73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x16f0 */  32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x1700 */  32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x1710 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1720 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48, 32, 85, 77, 70, 95,
/* 0x1730 */  76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1740 */  32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32,
/* 0x1750 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x1760 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77, 70,
/* 0x1770 */  95, 65, 32, 48, 32, 72, 85, 77, 70, 95, 65, 10, 48, 48, 48, 48,
/* 0x1780 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77,
/* 0x1790 */  70, 95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48, 48, 48,
/* 0x17a0 */  48, 48, 49, 98, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x17b0 */  70, 77, 65, 73, 78, 88, 32, 48, 32,103,101,116, 95,112, 97,103,
/* 0x17c0 */ 101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,101, 52, 32,
/* 0x17d0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x17e0 */  32, 48, 32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48, 49,
/* 0x17f0 */  99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1800 */  73, 78, 88, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95, 97,
/* 0x1810 */ 110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,103,
/* 0x1820 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1830 */  48, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x1840 */  99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1850 */  78, 90, 32, 48, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48,
/* 0x1860 */  48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1870 */  70, 77, 65, 73, 78, 90, 32, 48, 32,102,116,114,117,110, 99, 97,
/* 0x1880 */ 116,101, 10, 48, 48, 48, 48, 48, 48,102, 56, 32,103, 32, 32, 32,
/* 0x1890 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,108,
/* 0x18a0 */ 115,101,101,107, 10, 48, 48, 48, 48, 48, 50, 99, 52, 32,103, 32,
/* 0x18b0 */  32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x18c0 */  68, 32, 48, 50, 55, 99, 32,117,112,120, 95,109,109, 97,112, 95,
/* 0x18d0 */  97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100, 10, 48,
/* 0x18e0 */  48, 48, 48, 48, 49, 98, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x18f0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,109, 97,112, 10,
/* 0x1900 */  48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70,
/* 0x1910 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48,100, 99, 32,117,
/* 0x1920 */ 112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,
/* 0x1930 */ 105,110,117,120, 10, 48, 48, 48, 48, 48, 49, 55, 52, 32,103, 32,
/* 0x1940 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x1950 */  32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 49, 57, 99, 32,
/* 0x1960 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1970 */  32, 48, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 97,
/* 0x1980 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1990 */  78, 90, 32, 48, 32,102,100, 97,116, 97,115,121,110, 99, 10, 48,
/* 0x19a0 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x19b0 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,116, 95,117,
/* 0x19c0 */ 112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x19d0 */  54, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x19e0 */  73, 78, 90, 32, 48, 32,109,101,109,102,100, 95, 99,114,101, 97,
/* 0x19f0 */ 116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x1a00 */  32, 32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 95,
/* 0x1a10 */ 115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32,103,
/* 0x1a20 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1a30 */  48, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 49, 56, 56, 32,
/* 0x1a40 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1a50 */  32, 48, 32,117,110,108,105,110,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  50, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1a70 */  73, 78, 90, 32, 48, 32,109,101,109,115,101,116, 10, 48, 48, 48,
/* 0x1a80 */  48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 69, 76,
/* 0x1a90 */  70, 77, 65, 73, 78, 88, 32, 48, 99, 52, 32,117, 99,108, 95,110,
/* 0x1aa0 */ 114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115, 95,
/* 0x1ab0 */  56, 10, 48, 48, 48, 48, 48, 49, 98, 48, 32,103, 32, 32, 32, 32,
/* 0x1ac0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,121,
/* 0x1ad0 */  95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32,103,
/* 0x1ae0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x1af0 */  48, 32,102,115,121,110, 99, 10, 48, 48, 48, 48, 48, 49, 54, 48,
/* 0x1b00 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1b10 */  90, 32, 48, 32,115,116, 97,116, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x1b20 */  52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1b30 */  78, 90, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 49,
/* 0x1b40 */  51, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1b50 */  73, 78, 90, 32, 48, 32,111,112,101,110, 97,116, 10, 48, 48, 48,
/* 0x1b60 */  48, 48, 49, 50, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1b70 */  70, 77, 65, 73, 78, 90, 32, 48, 32,111,112,101,110, 10, 48, 48,
/* 0x1b80 */  48, 48, 48, 49, 48, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1b90 */  76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,107,100,105,114, 10,
/* 0x1ba0 */  48, 48, 48, 48, 48, 48, 56, 48, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1bb0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,108,111,115,
/* 0x1bc0 */ 101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x1bd0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65,
/* 0x1be0 */  73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x1bf0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1c00 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32,
/* 0x1c10 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1c20 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1c30 */  48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1c40 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x1c50 */  48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1c60 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x1c70 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82, 95, 65, 82,
/* 0x1c80 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x1c90 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32,
/* 0x1ca0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1cb0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x1cc0 */  48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1cd0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x1ce0 */  48, 48, 48, 48, 50, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1cf0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 97,116,
/* 0x1d00 */  10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1d10 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1d20 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 51, 48, 32, 82, 95,
/* 0x1d30 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d40 */ 114,101, 97,100, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95,
/* 0x1d50 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d60 */  69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 52,
/* 0x1d70 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1d80 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48,
/* 0x1d90 */  48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1da0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1db0 */  10, 48, 48, 48, 48, 48, 50, 53, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x1dc0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1dd0 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 54, 52, 32, 82, 95,
/* 0x1de0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1df0 */  99,108,111,115,101, 10, 48, 48, 48, 48, 48, 50, 55, 48, 32, 82,
/* 0x1e00 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e10 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 10, 82, 69, 76, 79, 67,
/* 0x1e20 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x1e30 */  82, 32, 91, 72, 85, 77, 70, 95, 65, 93, 58, 10, 79, 70, 70, 83,
/* 0x1e40 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e50 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1e60 */  48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1e70 */  32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112,
/* 0x1e80 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100, 10,
/* 0x1e90 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1ea0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 76, 93,
/* 0x1eb0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1ed0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82,
/* 0x1ee0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,
/* 0x1ef0 */ 120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,
/* 0x1f00 */ 110,117,120, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1f10 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70,
/* 0x1f20 */  95, 65, 78, 68, 82, 79, 73, 68, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x1f30 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f40 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x1f50 */  48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1f60 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x1f70 */  73, 68, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82,
/* 0x1f80 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x1f90 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x1fa0 */  52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1fb0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x1fc0 */  10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x1fd0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x1fe0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48,
/* 0x1ff0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2000 */  32, 32, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2020 */  32, 32, 32, 32, 32,115,116, 97,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x2030 */  57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2040 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2050 */  10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2060 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2070 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 98, 48,
/* 0x2080 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2090 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x20a0 */  48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x20b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,107,100,105,114, 10,
/* 0x20c0 */  48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x20d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,
/* 0x20e0 */ 112,116, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82,
/* 0x20f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2100 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,
/* 0x2110 */  48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2120 */  32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48,
/* 0x2130 */  48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2140 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2150 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65,
/* 0x2160 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2170 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2180 */  49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2190 */  32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48,
/* 0x21a0 */  49, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x21b0 */  32, 32, 32, 32, 32, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48,
/* 0x21c0 */  49, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x21d0 */  32, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48,
/* 0x21e0 */  48, 49, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x21f0 */  32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48,
/* 0x2200 */  48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2210 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2220 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82,
/* 0x2230 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2240 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2250 */  48, 48, 49, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2260 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2270 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 98, 48, 32, 82, 95, 65,
/* 0x2280 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2290 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x22a0 */  49, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x22b0 */  32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48,
/* 0x22c0 */  48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x22d0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x22e0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95,
/* 0x22f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2300 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2310 */  48, 49,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2320 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2330 */  73, 68, 10, 48, 48, 48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82,
/* 0x2340 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x2350 */ 109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82,
/* 0x2360 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2370 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 50,
/* 0x2380 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x23a0 */  48, 48, 48, 48, 48, 50, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x23b0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x23c0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32,
/* 0x23d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x23f0 */  48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2400 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2410 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 53, 52, 32, 82, 95,
/* 0x2420 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2430 */ 109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 54, 99,
/* 0x2440 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2450 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2460 */  48, 48, 48, 48, 50, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2470 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2480 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 56, 56, 32, 82,
/* 0x2490 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x24a0 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 57,
/* 0x24b0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x24c0 */  32, 32, 32, 32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48,
/* 0x24d0 */  50, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x24e0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x24f0 */  68, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77,
/* 0x2500 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2510 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 98,
/* 0x2520 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2530 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2540 */  48, 48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2550 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2560 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,102, 48, 32,
/* 0x2570 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2580 */  32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x2590 */  48, 48, 48, 48, 50,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x25a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x25b0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 48, 56, 32, 82,
/* 0x25c0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x25d0 */  32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48, 48,
/* 0x25e0 */  48, 48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x25f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2600 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 49, 56, 32, 82, 95,
/* 0x2610 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2620 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2630 */  48, 51, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2640 */  32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48,
/* 0x2650 */  48, 51, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2660 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2670 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 52, 52, 32, 82, 95, 65, 82,
/* 0x2680 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2690 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x26a0 */  53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x26b0 */  32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48,
/* 0x26c0 */  48, 48, 51, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x26d0 */  32, 32, 32, 32, 32, 32, 32, 32,117,110, 97,109,101, 10, 48, 48,
/* 0x26e0 */  48, 48, 48, 51, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x26f0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x2700 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 48, 32, 82, 95,
/* 0x2710 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2720 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x2730 */  48, 51, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2740 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2750 */  73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 99, 32, 82, 95, 65, 82,
/* 0x2760 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2770 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x2780 */  97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2790 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x27a0 */  10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x27b0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x27c0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 98, 56,
/* 0x27d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x27e0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x27f0 */  48, 48, 48, 48, 51, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2800 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2810 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 99, 52, 32, 82,
/* 0x2820 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2830 */  32,103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104, 10,
/* 0x2840 */  48, 48, 48, 48, 48, 51,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2850 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2860 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,101, 99, 32,
/* 0x2870 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2880 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2890 */  48, 48, 48, 51,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x28a0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x28b0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 48, 56, 32, 82, 95,
/* 0x28c0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x28d0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x28e0 */  48, 52, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x28f0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2900 */  73, 68, 10, 48, 48, 48, 48, 48, 52, 50, 48, 32, 82, 95, 65, 82,
/* 0x2910 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,
/* 0x2920 */ 101,110, 10, 48, 48, 48, 48, 48, 52, 50, 99, 32, 82, 95, 65, 82,
/* 0x2930 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2940 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x2950 */  51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2960 */  32, 32, 32, 32, 32,117,110,108,105,110,107, 10, 48, 48, 48, 48,
/* 0x2970 */  48, 52, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2980 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2990 */  73, 68, 10, 48, 48, 48, 48, 48, 52, 52, 56, 32, 82, 95, 65, 82,
/* 0x29a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x29b0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x29c0 */  52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x29d0 */  32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x29e0 */ 115,107, 10, 48, 48, 48, 48, 48, 52, 54, 52, 32, 82, 95, 65, 82,
/* 0x29f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2a00 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x2a10 */  54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2a20 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2a30 */  10, 48, 48, 48, 48, 48, 52, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2a40 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,114,117,
/* 0x2a50 */ 110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 52, 56, 48, 32, 82,
/* 0x2a60 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a70 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2a80 */  48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2a90 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2aa0 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 57, 52, 32, 82, 95, 65,
/* 0x2ab0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x2ac0 */ 115,101,101,107, 10, 48, 48, 48, 48, 48, 52, 98, 56, 32, 82, 95,
/* 0x2ad0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ae0 */ 119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52, 99, 56, 32, 82,
/* 0x2af0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b00 */  32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 52,100, 52, 32,
/* 0x2b10 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2b20 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2b30 */  48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2b40 */  52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,
/* 0x2b50 */ 101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 52,101, 52, 32,
/* 0x2b60 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2b70 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2b80 */  48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2b90 */  52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48,
/* 0x2ba0 */  48, 48, 48, 48, 52,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2bb0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2bc0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82,
/* 0x2bd0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2be0 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 53, 50, 56, 32, 82,
/* 0x2bf0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c00 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2c10 */  48, 48, 53, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2c20 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2c30 */  79, 73, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x2c40 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70,
/* 0x2c50 */  95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x2c60 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c70 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2c80 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2c90 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48,
/* 0x2ca0 */  48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2cb0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,100, 95,
/* 0x2cc0 */  99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,
/* 0x2cd0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2ce0 */  32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48,
/* 0x2cf0 */  48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2d00 */  32, 32, 32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101,
/* 0x2d10 */  97,116,101, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65,
/* 0x2d20 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2d30 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 52,
/* 0x2d40 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2d50 */  32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48,
/* 0x2d60 */  48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d70 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x2d80 */  48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78,
/* 0x2da0 */  85, 88, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82,
/* 0x2db0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,
/* 0x2dc0 */ 114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 57, 48,
/* 0x2dd0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2de0 */  32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48,
/* 0x2df0 */  48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2e00 */  32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48,
/* 0x2e10 */  48, 48, 48, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2e20 */  32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101,
/* 0x2e30 */  95,109, 97,115,107, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x2e40 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,
/* 0x2e50 */  76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x2e60 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e70 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x2e80 */  48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2e90 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x2ea0 */  48, 48, 48, 48, 48, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2eb0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x2ec0 */  97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x2ed0 */  53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ee0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48,
/* 0x2ef0 */  48, 48, 48, 48, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2f00 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2f10 */  88, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77,
/* 0x2f20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,
/* 0x2f30 */ 116,101, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82,
/* 0x2f40 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2f50 */  70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32,
/* 0x2f60 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2f70 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x2f80 */  48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2f90 */  32, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48,
/* 0x2fa0 */  48, 48,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2fb0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x2fc0 */  48, 48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2fd0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2fe0 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65,
/* 0x2ff0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3000 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 50, 52,
/* 0x3010 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3020 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x3030 */  48, 49, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3040 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x3050 */  48, 48, 48, 48, 48, 49, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3060 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x3070 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 51, 99, 32, 82, 95, 65,
/* 0x3080 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3090 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 52, 56,
/* 0x30a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x30b0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x30c0 */  48, 49, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x30d0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x30e0 */  48, 48, 48, 48, 48, 49, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x30f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x3100 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 54, 52, 32, 82, 95, 65,
/* 0x3110 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x3120 */  76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 54, 99,
/* 0x3130 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3140 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x3150 */  48, 49, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3160 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x3170 */  48, 48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3180 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x3190 */  73, 78, 88, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65,
/* 0x31a0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x31b0 */  76, 70, 77, 65, 73, 78, 88, 10
};
