/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Dimen;
import nts.base.Num;
import nts.builder.Builder;
import nts.command.CommandBase;
import nts.command.Token;
import nts.typo.TypoAssignPrim;
import nts.typo.TypoCommand;

public class SpaceFactorPrim
extends TypoAssignPrim
implements Num.Provider {
    public static final int MIN_SPACE_FACTOR = 1;
    public static final int MAX_SPACE_FACTOR = Short.MAX_VALUE;

    protected void assign(Token src, boolean glob) {
        Builder bld = TypoCommand.getBld();
        if (bld.getSpaceFactor() > 0) {
            CommandBase.skipOptEquals();
            int sf = CommandBase.scanInt();
            if (1 <= sf && sf <= Short.MAX_VALUE) {
                bld.setSpaceFactor(sf);
            } else {
                CommandBase.error("BadSpaceFactor", CommandBase.num(sf), CommandBase.num(1), CommandBase.num(Short.MAX_VALUE));
            }
        } else {
            this.illegalCase(bld);
        }
    }

    public boolean hasCrazyValue() {
        if (TypoCommand.getBld().getSpaceFactor() > 0) {
            return false;
        }
        CommandBase.error("ImproperSForPD", this);
        return true;
    }

    public boolean hasDimenValue() {
        return !(TypoCommand.getBld().getSpaceFactor() > 0);
    }

    public Dimen getDimenValue() {
        int sf = TypoCommand.getBld().getSpaceFactor();
        if (sf > 0) {
            return null;
        }
        CommandBase.error("ImproperSForPD", this);
        return Dimen.ZERO;
    }

    public boolean hasNumValue() {
        return true;
    }

    public Num getNumValue() {
        int sf = TypoCommand.getBld().getSpaceFactor();
        if (sf > 0) {
            return Num.valueOf(sf);
        }
        CommandBase.error("ImproperSForPD", this);
        return Num.ZERO;
    }

    public SpaceFactorPrim(String name) {
        super(name);
    }
}

