/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Num;
import nts.command.Command;
import nts.command.Token;
import nts.io.CharCode;
import nts.io.Log;
import nts.typo.BuilderCommand;

class CharGiven
extends Command
implements Num.Provider {
    private CharCode code;
    private String name;

    public void exec(Token src) {
        BuilderCommand.handleChar(this.code, src);
    }

    public CharCode charCodeToAdd() {
        return this.code;
    }

    public boolean sameAs(Command cmd) {
        return cmd instanceof CharGiven && this.code.match(((CharGiven)cmd).code);
    }

    public void addOn(Log log) {
        log.addEsc(this.name).add('\"').add(Integer.toHexString(this.code.numValue()).toUpperCase());
    }

    public boolean hasNumValue() {
        return true;
    }

    public Num getNumValue() {
        return Num.valueOf(this.code.numValue());
    }

    public final String toString() {
        return "[character given: " + this.code + "]";
    }

    public CharGiven(CharCode code, String name) {
        this.code = code;
        this.name = name;
    }
}

