/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Dimen;
import nts.base.Glue;
import nts.node.AnyBoxNode;
import nts.node.Box;
import nts.node.BoxSizes;
import nts.node.ChrKernNode;
import nts.node.GlueSetting;
import nts.node.HSkipNode;
import nts.node.HorizIterator;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.SizesEvaluator;
import nts.node.TypeSetter;
import nts.node.VisibleSummarizer;

public class HBoxNode
extends AnyBoxNode {
    public static final HBoxNode EMPTY = new HBoxNode(BoxSizes.ZERO, GlueSetting.NATURAL, NodeList.EMPTY);

    public final boolean isHBox() {
        return true;
    }

    public String getDesc() {
        return "hbox";
    }

    protected void moveStart(TypeSetter setter) {
        setter.moveLeft(this.getLeftX());
    }

    protected void movePrev(TypeSetter setter, Node node) {
        setter.moveRight(node.getLeftX(this.setting));
    }

    protected void movePast(TypeSetter setter, Node node) {
        setter.moveRight(node.getWidth(this.setting));
    }

    public Box pretendSizesCopy(BoxSizes sizes) {
        return new HBoxNode(sizes, this.setting, this.list);
    }

    public static HBoxNode packedOf(NodeList list) {
        return new HBoxNode(HorizIterator.naturalSizes(list.nodes()), GlueSetting.NATURAL, list);
    }

    public static HBoxNode packedOf(Node node) {
        return HBoxNode.packedOf(new NodeList(node));
    }

    public Node trailingKernSpared() {
        return this.list.length() == 2 && this.list.nodeAt(0).kernAfterCanBeSpared() && this.list.nodeAt(1).isKernThatCanBeSpared() ? new HBoxNode(this.sizes, this.setting, new NodeList(this.list.nodeAt(0))) : this;
    }

    public Node reboxedToWidth(Dimen width) {
        if (this.getWidth().equals(width)) {
            return this;
        }
        if (this.list.isEmpty()) {
            return this.pretendingWidth(width);
        }
        NodeList forPacking = this.list;
        if (this.list.length() == 1 && this.list.nodeAt(0).kernAfterCanBeSpared()) {
            Node node = this.list.nodeAt(0);
            Dimen delta = this.getWidth().minus(node.getWidth());
            if (!delta.isZero()) {
                forPacking = new NodeList(2);
                forPacking.append(node).append(new ChrKernNode(delta));
            }
        }
        return HBoxNode.packedToWidth(forPacking.nodes(), width);
    }

    public static Node reboxedToWidth(Node node, Dimen width) {
        return node.getWidth().equals(width) ? node : HBoxNode.packedToWidth(NodeList.nodes(node), width);
    }

    private static HBoxNode packedToWidth(NodeEnum nodes, Dimen width) {
        HSkipNode filler = new HSkipNode(Glue.valueOf(Dimen.ZERO, Dimen.UNITY, (byte)1, Dimen.UNITY, (byte)1));
        NodeList list = new NodeList();
        list.append(filler).append(nodes).append(filler);
        SizesEvaluator pack = new SizesEvaluator();
        HorizIterator.summarize(list.nodes(), pack);
        width = width.minus(pack.getHeight());
        Dimen size = pack.getBody().plus(pack.getDepth());
        pack.evaluate(width.minus(size), false);
        BoxSizes sizes = new BoxSizes(pack.getWidth(), width, pack.getLeftX(), pack.getHeight());
        return new HBoxNode(sizes, pack.getSetting(), list);
    }

    public Dimen allegedlyVisibleWidth() {
        VisibleSummarizer summarizer = new VisibleSummarizer(this.setting);
        summarizer.summarize(this.list.nodes());
        return summarizer.getVisibleWidth();
    }

    public String toString() {
        return "HBox(" + this.sizes + "; " + this.setting + "; " + this.list + ")";
    }

    public HBoxNode(BoxSizes sizes, GlueSetting setting, NodeList list) {
        super(sizes, setting, list);
    }
}

