/*
 * Decompiled with CFR 0.152.
 */
package nts.io;

import java.io.Serializable;
import java.util.Vector;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.Loggable;

public class Name
implements Serializable,
Loggable {
    public static final Name NULL;
    public static final Name EMPTY;
    private CharCode[] codes;

    public final int length() {
        return this.codes.length;
    }

    public CharCode codeAt(int index) {
        return this.codes[index];
    }

    public void getCodes(int beg, int end, CharCode[] dst, int offset) {
        while (beg < end) {
            dst[offset++] = this.codes[beg++];
        }
    }

    public void getCodes(CharCode[] dst, int offset) {
        this.getCodes(0, this.codes.length, dst, offset);
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.length()) {
            h = h * 39 + this.codeAt(i).hashCode();
            ++i;
        }
        return h;
    }

    public final boolean equals(Object o) {
        if (o != null && o instanceof Name) {
            Name other = (Name)o;
            if (this.length() == other.length()) {
                int i = 0;
                while (i < this.length()) {
                    if (!this.codeAt(i).equals(other.codeAt(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public boolean match(Name x) {
        if (this.length() == x.length()) {
            int i = 0;
            while (i < this.length()) {
                if (!this.codeAt(i).match(x.codeAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void addOn(Log log) {
        log.add(this.codes);
    }

    public void addEscapedOn(Log log) {
        log.addEsc().add(this.codes);
    }

    public void addProperlyEscapedOn(Log log) {
        switch (this.codes.length) {
            case 0: {
                log.addEsc("csname").addEsc("endcsname");
                break;
            }
            case 1: {
                log.addEsc().add(this.codes[0]);
                if (!this.codes[0].isLetter()) break;
                log.add(' ');
                break;
            }
            default: {
                log.addEsc().add(this.codes).add(' ');
                break;
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.length()) {
            buf.append(this.codeAt(i++));
        }
        return buf.toString();
    }

    public Name(CharCode[] codes) {
        this.codes = codes;
    }

    public Name(CharCode code) {
        this.codes = new CharCode[1];
        this.codes[0] = code;
    }

    public Name() {
        this.codes = new CharCode[0];
    }

    static {
        EMPTY = new Name();
    }

    public static class Buffer
    implements Serializable {
        private Vector data;

        public Buffer append(CharCode code) {
            this.data.addElement(code);
            return this;
        }

        public Buffer append(CharCode[] codes, int offset, int count) {
            this.data.ensureCapacity(this.data.size() + count);
            while (count-- > 0) {
                this.data.addElement(codes[offset++]);
            }
            return this;
        }

        public Buffer append(CharCode[] codes) {
            return this.append(codes, 0, codes.length);
        }

        public Buffer append(Name name) {
            return this.append(name.codes);
        }

        public void clear() {
            this.data.clear();
        }

        public int length() {
            return this.data.size();
        }

        public CharCode codeAt(int index) {
            return (CharCode)this.data.elementAt(index);
        }

        public void getCodes(int beg, int end, CharCode[] dst, int offset) {
            while (beg < end) {
                dst[offset++] = this.codeAt(beg++);
            }
        }

        public int hashCode() {
            int h = 0;
            int i = 0;
            while (i < this.length()) {
                h = h * 39 + this.codeAt(i).hashCode();
                ++i;
            }
            return h;
        }

        public final boolean equals(Object o) {
            if (o != null && o instanceof Buffer) {
                Buffer other = (Buffer)o;
                if (this.length() == other.length()) {
                    int i = 0;
                    while (i < this.length()) {
                        if (!this.codeAt(i).equals(other.codeAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public Name toName() {
            Object[] codes = new CharCode[this.length()];
            this.data.copyInto(codes);
            return new Name((CharCode[])codes);
        }

        public Buffer() {
            this.data = new Vector();
        }

        public Buffer(int size) {
            this.data = new Vector(size);
        }
    }
}

