/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.texparser.LatexParserUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class TexPairMatcher
implements ICharacterPairMatcher {
    private int fAnchor = 1;
    private String pairs;

    public TexPairMatcher(String pairs) {
        this.pairs = pairs;
        if (pairs.length() % 2 == 1) {
            TexlipsePlugin.stat("Bad parameter for TexPairMatcher constructor: " + pairs);
            this.pairs = "";
        }
    }

    public void dispose() {
    }

    public void clear() {
    }

    public IRegion match(IDocument document, int offset) {
        int index;
        block10: {
            block9: {
                if (--offset < 0) {
                    return null;
                }
                index = this.pairs.indexOf(document.getChar(offset));
                if (index != -1) break block9;
                return null;
            }
            if (offset <= 0 || document.getChar(offset - 1) != '\\') break block10;
            return null;
        }
        try {
            String docString = document.get();
            if (index % 2 == 1) {
                this.fAnchor = 0;
                int peerIndex = LatexParserUtils.findPeerChar(docString, offset, this.fAnchor, this.pairs.charAt(index), this.pairs.charAt(index - 1));
                if (peerIndex != -1) {
                    return new Region(peerIndex, offset - peerIndex + 1);
                }
            } else {
                this.fAnchor = 1;
                int peerIndex = LatexParserUtils.findPeerChar(docString, offset, this.fAnchor, this.pairs.charAt(index), this.pairs.charAt(index + 1));
                if (peerIndex != -1) {
                    return new Region(offset, peerIndex - offset + 1);
                }
            }
        }
        catch (BadLocationException ble) {
            TexlipsePlugin.log("Bad location in TexPairMatcher.match()", ble);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }
}

