.PS
# Quantum.m4
cct_init

[
  boxht = 0.30
  boxwid = boxht
  define(`dotrad_',boxht/5)

define(`Bus',`line right_ 10*boxwid `$1'
  circle diam boxht `$2' at last line.start
  box fill_(1) "H" at last line.start+(boxwid*3/2,0)
  box fill_(1) "H" at last line.end-(boxwid*2.5,0) ')

define(`Meter',`[ Box: box wid boxwid*3/2 fill_(1)
  r = Box.wid/3
  C: 0.3 between Box.s and Box.n
  arc cw from C+(-r,0) to C+(r,0) with .c at C
  arrow from C+(-r/4,0) to C+(0.9*r,0.9*r) ]')

X: Bus(,shaded rgbstring(0.5,0.5,1) "X")
A1: Bus(from X.start+(0,-boxht*3/2), shaded "red" "A")
A2: Bus(from 2 between X.start and A1.start,shaded "red" "A")
   dot(at X.start+(3*boxwid,0))
   line to (Here,A2); dot
   circle rad dotrad_ at A1.start+(4*boxwid,0)
   line from last circle.s to (last circle,X); dot
   Meter with .e at X.end
   box wid boxwid*1.2 ht boxht*1.2 fill_(1) "$R_{\psi}^{\pi/2}$" \
     at A2.end-(4.5*boxwid,0)
]
[
#.PS
# Rxx gate
# https://tex.stackexchange.com/questions/741304/quantikz-how-to-draw-a-r-xx-gate-using-quantikz-in-latex
#cct_init
  define(`dotrad_',`(0.04*dimen_)')

  linethick = 1.6
  define(`Box',`box wid boxwid*2/3 ht boxht*2/3 rad boxht/8 outlined "red!60" \
   "$\theta_{xx}^{{\color{red}2},`$1',`$2'}$" shaded "white"')

  del = boxht/4
 Outer: box rad boxht/4 dashed wid 3*boxwid ht 4*boxwid shaded "red!4"
Rxx: [
 B1: Box(1,i)
 B2: Box(1,j) with .w at B1.e+(del,0)
 B3: Box(1,j) with .n at (1/2 between B1 and B2,B1.s-(0,B1.ht+del))
 B4: Box(1,8) with .w at B3.e+(B1.ht+del/2,0)
 B5: Box(j,8) with .n at (B1,B4.s-(0,B1.ht+del))
 B6: Box(i,8) at (B4.w.x-del/2,B5.y)
 I1: B1.nw+(-B1.ht,del)
 Rail1: line from I1 right_ B4.e.x+B1.w.x-2*I1.x
 Rail2: line from (Rail1.start,B3.n+(0,del)) right_ Rail1.len
 Rail3: line from (Rail1.start,B3.s-(0,del)) right_ Rail1.len
 Rail4: line from (Rail1.start,B5.s-(0,del)) right_ Rail1.len
 define(`connx',
  `dot(at (`$1',`$2')); line to `$1'.n; dot(at (`$1',`$3')); line to `$1'.s')
 connx(B1,Rail1,Rail2)
 connx(B2,Rail1,Rail3)
 connx(B3,Rail2,Rail3)
 connx(B4,Rail1,Rail4)
 connx(B5,Rail3,Rail4)
 connx(B6,Rail2,Rail4)
 "$\cdots$" at (B3,Rail2)+(0,del)
 "$\cdots$" at (B6,Rail2)+(0,del)
 "$\cdots$" at (B2,Rail3)-(0,del)
  ] at Outer
#.PE
  ] with .nw at last [].ne+(boxht/3,0)

#.PE
#.PS
# SQUID.m4
cct_init

[
down_
#source
S1: SQUID
  "J1" at S1.J1 above rjust
  "J2" at S1.J2 above ljust

S2: SQUID(3,dimen_*1.5,-120) at S1.e+(elen_,0)
  "J1" at S2.J1 above rjust
  "J2" at S2.J2 below ljust
  "J3" at S2.J3 above ljust
  arcrad = S2.C.rad*0.7
  arc from S2.c+(Rect_(arcrad,-135)) to S2.c+(Rect_(arcrad,-45)) \
   with .c at S2.C ->
  ] with .w at (1st [].w.x+boxwid/2,last [].s.y+boxht)

.PE
