/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.ArrayList;
import java.util.Random;
import moa.core.Example;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class IrrelevantFeatureAppenderStream
extends AbstractOptionHandler
implements InstanceStream {
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to imbalance.", ExampleStream.class, "generators.RandomTreeGenerator");
    public IntOption numNumericFeaturesOption = new IntOption("numNumericFeatures", 'n', "Number of numeric features to be appended.", 0, 0, 1000);
    public IntOption numCategoricalFeaturesOption = new IntOption("numCategoricalFeatures", 'c', "Number of categorical features to be appended.", 0, 0, 1000);
    public IntOption numValuesCategoricalFeatureOption = new IntOption("numValuesCategoricalFeature", 'v', "Number of values for each categorical feature.", 2, 1, 1000);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    protected ExampleStream originalStream = null;
    protected InstancesHeader newHeader = null;
    protected Random random = null;

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.originalStream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        this.random = new Random(this.instanceRandomSeedOption.getValue());
        this.buildHeader();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.newHeader;
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.originalStream.estimatedRemainingInstances();
    }

    @Override
    public boolean hasMoreInstances() {
        return this.originalStream.hasMoreInstances();
    }

    @Override
    public Example<Instance> nextInstance() {
        Object original = this.originalStream.nextInstance();
        double[] values = new double[this.newHeader.numAttributes()];
        int ix = 0;
        for (int i = 0; i < ((Instance)original.getData()).dataset().numAttributes(); ++i) {
            if (((Instance)original.getData()).dataset().classIndex() == i) continue;
            values[ix] = ((Instance)original.getData()).value(i);
            ++ix;
        }
        while (ix < values.length - 1) {
            Attribute att = this.newHeader.attribute(ix);
            values[ix] = att.isNumeric() ? this.random.nextDouble() : (double)this.random.nextInt(this.numValuesCategoricalFeatureOption.getValue());
            ++ix;
        }
        if (((Instance)original.getData()).classIndex() != -1) {
            values[values.length - 1] = ((Instance)original.getData()).classValue();
        }
        DenseInstance instnc = new DenseInstance(1.0, values);
        instnc.setDataset(this.newHeader);
        return new InstanceExample(instnc);
    }

    @Override
    public boolean isRestartable() {
        return this.originalStream.isRestartable();
    }

    @Override
    public void restart() {
        this.originalStream.restart();
        this.random = new Random(this.instanceRandomSeedOption.getValue());
        this.buildHeader();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    private void buildHeader() {
        int i;
        Attribute att;
        int i2;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        InstancesHeader originalHeader = this.originalStream.getHeader();
        for (i2 = 0; i2 < originalHeader.numAttributes(); ++i2) {
            att = originalHeader.attribute(i2);
            if (att == originalHeader.classAttribute()) continue;
            attributes.add(att);
        }
        for (i2 = 0; i2 < this.numNumericFeaturesOption.getValue(); ++i2) {
            att = new Attribute("irrelNum" + i2);
            attributes.add(att);
        }
        ArrayList<String> catVals = new ArrayList<String>();
        for (i = 0; i < this.numValuesCategoricalFeatureOption.getValue(); ++i) {
            catVals.add("v" + i);
        }
        for (i = 0; i < this.numCategoricalFeaturesOption.getValue(); ++i) {
            Attribute att2 = new Attribute("irrelCat" + i, catVals);
            attributes.add(att2);
        }
        if (originalHeader.classIndex() != -1) {
            attributes.add(originalHeader.attribute(originalHeader.classIndex()));
        }
        Instances format = new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0);
        format.setClassIndex(attributes.size() - 1);
        this.newHeader = new InstancesHeader(format);
    }
}

