% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issuerows.R
\name{diffdf_issuerows}
\alias{diffdf_issuerows}
\title{diffdf_issuerows}
\usage{
diffdf_issuerows(df, diff, vars = NULL)
}
\arguments{
\item{df}{dataframe to be subsetted}

\item{diff}{diffdf object}

\item{vars}{(optional) character vector containing names of issue variables to subset dataframe 
on. A value of NULL (default) will be taken to mean available issue variables.}
}
\description{
This function takes a diffdf object and a dataframe and subsets
the dataframe for problem rows as identified in the comparison object.
If \code{vars} has been specified only issue rows associated with those
variable(s) will be returned.
}
\details{
Note that diffdf_issuerows can be used to subset against any dataframe. The only
requirement is that the original variables specified in the keys argument to diffdf
are present on the dataframe you are subsetting against. However please note that if 
no keys were specified in diffdf then the row number is used. This means using 
diffdf_issuerows without a keys against an arbitrary dataset can easily result in 
nonsense rows being returned. It is always recommended to supply keys to diffdf.
}
\examples{
iris2 <- iris
for ( i in 1:3) iris2[i,i] <- 99
x <- diffdf( iris , iris2, suppress_warnings = TRUE)
diffdf_issuerows( iris , x)
diffdf_issuerows( iris2 , x)
diffdf_issuerows( iris2 , x , vars = "Sepal.Length")
diffdf_issuerows( iris2 , x , vars = c("Sepal.Length" , "Sepal.Width"))
}
