/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Instance_Selection.EUSCHCQstat;

import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Basic.KNN;
import keel.Dataset.Attribute;
import org.core.Randomize;

public class Chromosome
implements Comparable {
    boolean[] cuerpo;
    double calidad;
    boolean cruzado;
    boolean valido;
    boolean[] prediction;

    public Chromosome(int size) {
        this.cuerpo = new boolean[size];
        for (int i = 0; i < size; ++i) {
            double u = Randomize.Rand();
            this.cuerpo[i] = !(u < 0.5);
        }
        this.cruzado = true;
        this.valido = true;
    }

    public Chromosome(int size, Chromosome a) {
        this.cuerpo = new boolean[size];
        for (int i = 0; i < this.cuerpo.length; ++i) {
            this.cuerpo[i] = a.getGen(i);
        }
        this.calidad = a.getCalidad();
        this.cruzado = false;
        this.valido = true;
        this.prediction = (boolean[])a.prediction.clone();
    }

    public boolean getGen(int indice) {
        return this.cuerpo[indice];
    }

    public double getCalidad() {
        return this.calidad;
    }

    public void setGen(int indice, boolean valor) {
        this.cuerpo[indice] = valor;
    }

    public void evalua(double[][] datos, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[][] train, double[][] trainR, int[][] trainN, boolean[][] trainM, int[] clasesT, String wrapper, int K, String evMeas, boolean MS, boolean pFactor, double P, int posID, int nPos, boolean distanceEu, Attribute[] entradas, boolean[][] anteriores, boolean[][] salidasAnteriores) {
        int claseObt;
        int j;
        int m;
        int[] clasesS;
        boolean[][] conjM;
        int[][] conjN;
        double[][] conjR;
        double[][] conjS;
        int[] vecinos;
        int s;
        int i;
        int l = 0;
        int aciertosP = 0;
        int aciertosN = 0;
        int totalP = 0;
        int totalN = 0;
        this.prediction = new boolean[train.length];
        int negID = -1;
        for (i = 0; i < datos.length; ++i) {
            if (clases[i] == posID) continue;
            negID = clases[i];
            break;
        }
        if (MS) {
            s = this.genesActivos() + nPos;
            vecinos = new int[K];
            conjS = new double[s][train[0].length];
            conjR = new double[s][train[0].length];
            conjN = new int[s][train[0].length];
            conjM = new boolean[s][train[0].length];
            clasesS = new int[s];
            int h = 0;
            m = 0;
            l = 0;
            while (m < this.cuerpo.length) {
                while (h < clasesT.length && clasesT[h] == posID) {
                    ++h;
                }
                if (this.getGen(m)) {
                    for (j = 0; j < train[h].length; ++j) {
                        conjS[l][j] = train[h][j];
                        conjR[l][j] = trainR[h][j];
                        conjN[l][j] = trainN[h][j];
                        conjM[l][j] = trainM[h][j];
                    }
                    clasesS[l] = clasesT[h];
                    ++l;
                }
                ++m;
                ++h;
            }
            for (m = 0; m < train.length; ++m) {
                if (clasesT[m] != posID) continue;
                for (j = 0; j < train[m].length; ++j) {
                    conjS[l][j] = train[m][j];
                    conjR[l][j] = trainR[m][j];
                    conjN[l][j] = trainN[m][j];
                    conjM[l][j] = trainM[m][j];
                }
                clasesS[l] = clasesT[m];
                ++l;
            }
            if (wrapper.equalsIgnoreCase("k-NN")) {
                for (i = 0; i < datos.length; ++i) {
                    claseObt = KNN.evaluacionKNN2(K, conjS, conjR, conjN, conjM, clasesS, datos[i], real[i], nominal[i], nulos[i], Math.max(posID, negID) + 1, distanceEu, vecinos);
                    if (claseObt < 0) continue;
                    if (clases[i] == claseObt && clases[i] == posID) {
                        ++aciertosP;
                        ++totalP;
                        this.prediction[i] = true;
                        continue;
                    }
                    if (clases[i] != claseObt && clases[i] == posID) {
                        ++totalP;
                        this.prediction[i] = false;
                        continue;
                    }
                    if (clases[i] == claseObt && clases[i] != posID) {
                        ++aciertosN;
                        ++totalN;
                        this.prediction[i] = true;
                        continue;
                    }
                    if (clases[i] == claseObt || clases[i] == posID) continue;
                    ++totalN;
                    this.prediction[i] = false;
                }
            }
        } else {
            s = this.genesActivos();
            vecinos = new int[K];
            conjS = new double[s][train[0].length];
            conjR = new double[s][train[0].length];
            conjN = new int[s][train[0].length];
            conjM = new boolean[s][train[0].length];
            clasesS = new int[s];
            l = 0;
            for (j = 0; j < train.length; ++j) {
                if (!this.cuerpo[j]) continue;
                for (m = 0; m < train[j].length; ++m) {
                    conjS[l][m] = train[j][m];
                    conjR[l][m] = trainR[j][m];
                    conjN[l][m] = trainN[j][m];
                    conjM[l][m] = trainM[j][m];
                }
                clasesS[l] = clasesT[j];
                ++l;
            }
            for (i = 0; i < datos.length; ++i) {
                claseObt = KNN.evaluacionKNN2(K, conjS, conjR, conjN, conjM, clasesS, datos[i], real[i], nominal[i], nulos[i], Math.max(posID, negID) + 1, distanceEu, vecinos);
                if (claseObt < 0) continue;
                if (clases[i] == claseObt && clases[i] == posID) {
                    ++aciertosP;
                    ++totalP;
                    this.prediction[i] = true;
                    continue;
                }
                if (clases[i] != claseObt && clases[i] == posID) {
                    ++totalP;
                    this.prediction[i] = false;
                    continue;
                }
                if (clases[i] == claseObt && clases[i] != posID) {
                    ++aciertosN;
                    ++totalN;
                    this.prediction[i] = true;
                    continue;
                }
                if (clases[i] == claseObt || clases[i] == posID) continue;
                ++totalN;
                this.prediction[i] = false;
            }
        }
        if (evMeas.equalsIgnoreCase("geometric mean")) {
            this.calidad = Math.sqrt((double)aciertosP / (double)totalP * ((double)aciertosN / (double)totalN));
        } else if (evMeas.equalsIgnoreCase("auc")) {
            this.calidad = totalP < totalN ? (double)aciertosP / (double)totalP * ((double)aciertosN / (double)totalN) + (1.0 - (double)aciertosN / (double)totalN) * ((double)aciertosP / (double)totalP) / 2.0 + (1.0 - (double)aciertosP / (double)totalP) * ((double)aciertosN / (double)totalN) / 2.0 : (double)aciertosN / (double)totalN * ((double)aciertosP / (double)totalP) + (1.0 - (double)aciertosP / (double)totalP) * ((double)aciertosN / (double)totalN) / 2.0 + (1.0 - (double)aciertosN / (double)totalN) * ((double)aciertosP / (double)totalP) / 2.0;
        } else if (evMeas.equalsIgnoreCase("cost-sensitive")) {
            this.calidad = (double)totalN - (double)aciertosN + ((double)totalP - (double)aciertosP) * (double)totalN / (double)totalP;
            this.calidad /= 2.0 * (double)totalN;
            this.calidad = 1.0 - this.calidad;
        } else if (evMeas.equalsIgnoreCase("kappa")) {
            double sumDiagonales = 0.0;
            double sumTrTc = 0.0;
            sumDiagonales = aciertosP + aciertosN;
            sumTrTc = totalP * (totalN - aciertosN) + totalN * (totalP - aciertosP);
            this.calidad = ((double)datos.length * sumDiagonales - sumTrTc) / ((double)datos.length * (double)datos.length - sumTrTc);
        } else {
            double precision = (double)aciertosP / (double)totalP / ((double)aciertosP / (double)totalP + (1.0 - (double)aciertosN / (double)totalN));
            double recall = (double)aciertosP / (double)totalP / ((double)aciertosP / (double)totalP + (1.0 - (double)aciertosP / (double)totalP));
            this.calidad = 2.0 * precision * recall / (recall + precision);
        }
        if (pFactor) {
            double beta = MS ? (double)this.genesActivos() / (double)nPos : (double)this.genes0Activos(clasesT) / (double)this.genes1Activos(clasesT);
            this.calidad -= Math.abs(1.0 - beta) * P;
        }
        if (anteriores[0] != null) {
            double q = -1.7976931348623157E308;
            for (i = 0; i < anteriores.length && anteriores[i] != null; ++i) {
                double qaux = this.Qstatistic(anteriores[i], this.cuerpo, clases.length);
                if (!(q < qaux)) continue;
                q = qaux;
            }
            double peso = (double)(anteriores.length - i) / (double)anteriores.length;
            double IR = (double)totalN / (double)totalP * 0.1;
            this.calidad = this.calidad * (1.0 / peso) * (1.0 / IR) - q * peso;
        }
        this.cruzado = false;
    }

    private double Qstatistic(boolean[] v1, boolean[] v2, int n) {
        double[][] t = new double[2][2];
        double ceros = 0.0;
        if (v1.length < n) {
            n = v1.length;
        }
        for (int i = 0; i < n; ++i) {
            if (v1[i] == v2[i] && v1[i]) {
                double[] dArray = t[0];
                dArray[0] = dArray[0] + 1.0;
            } else if (v1[i] == v2[i] && !v1[i]) {
                double[] dArray = t[1];
                dArray[1] = dArray[1] + 1.0;
            } else if (v1[i] != v2[i] && v1[i]) {
                double[] dArray = t[1];
                dArray[0] = dArray[0] + 1.0;
            } else {
                double[] dArray = t[0];
                dArray[1] = dArray[1] + 1.0;
            }
            if (v2[i]) continue;
            ceros += 1.0;
        }
        if (ceros == (double)n) {
            return 2.0;
        }
        return (t[1][1] * t[0][0] - t[0][1] * t[1][0]) / (t[1][1] * t[0][0] + t[0][1] * t[1][0]);
    }

    public void divergeCHC(double r, Chromosome mejor, double prob) {
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (Randomize.Rand() < r) {
                if (Randomize.Rand() < prob) {
                    this.cuerpo[i] = true;
                    continue;
                }
                this.cuerpo[i] = false;
                continue;
            }
            this.cuerpo[i] = mejor.getGen(i);
        }
        this.cruzado = true;
    }

    public boolean estaEvaluado() {
        return !this.cruzado;
    }

    public int genesActivos() {
        int suma = 0;
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (!this.cuerpo[i]) continue;
            ++suma;
        }
        return suma;
    }

    public int genes0Activos(int[] clases) {
        int suma = 0;
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (!this.cuerpo[i] || clases[i] != 0) continue;
            ++suma;
        }
        return suma;
    }

    public int genes1Activos(int[] clases) {
        int suma = 0;
        for (int i = 0; i < this.cuerpo.length; ++i) {
            if (!this.cuerpo[i] || clases[i] != 1) continue;
            ++suma;
        }
        return suma;
    }

    public boolean esValido() {
        return this.valido;
    }

    public void borrar() {
        this.valido = false;
    }

    public int compareTo(Object o1) {
        if (this.calidad > ((Chromosome)o1).calidad) {
            return -1;
        }
        if (this.calidad < ((Chromosome)o1).calidad) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String temp = "[";
        for (int i = 0; i < this.cuerpo.length; ++i) {
            temp = this.cuerpo[i] ? temp + "1" : temp + "0";
        }
        temp = temp + ", " + String.valueOf(this.calidad) + ", " + String.valueOf(this.genesActivos()) + "]";
        return temp;
    }
}

