/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.Logistic.core.matrix;

import keel.Algorithms.Statistical_Classifiers.Logistic.core.Utils;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.matrix.Matrix;

public class LinearRegression {
    protected double[] m_Coefficients = null;

    public LinearRegression(Matrix a, Matrix y, double ridge) {
        this.calculate(a, y, ridge);
    }

    public LinearRegression(Matrix a, Matrix y, double[] w, double ridge) {
        if (w.length != a.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect number of weights provided");
        }
        Matrix weightedThis = new Matrix(a.getRowDimension(), a.getColumnDimension());
        Matrix weightedDep = new Matrix(a.getRowDimension(), 1);
        for (int i = 0; i < w.length; ++i) {
            double sqrt_weight = Math.sqrt(w[i]);
            for (int j = 0; j < a.getColumnDimension(); ++j) {
                weightedThis.set(i, j, a.get(i, j) * sqrt_weight);
            }
            weightedDep.set(i, 0, y.get(i, 0) * sqrt_weight);
        }
        this.calculate(weightedThis, weightedDep, ridge);
    }

    protected void calculate(Matrix a, Matrix y, double ridge) {
        if (y.getColumnDimension() > 1) {
            throw new IllegalArgumentException("Only one dependent variable allowed");
        }
        int nc = a.getColumnDimension();
        this.m_Coefficients = new double[nc];
        Matrix xt = a.transpose();
        boolean success = true;
        do {
            int i;
            Matrix ss = xt.times(a);
            for (int i2 = 0; i2 < nc; ++i2) {
                ss.set(i2, i2, ss.get(i2, i2) + ridge);
            }
            Matrix bb = xt.times(y);
            for (i = 0; i < nc; ++i) {
                this.m_Coefficients[i] = bb.get(i, 0);
            }
            try {
                Matrix solution = ss.solve(new Matrix(this.m_Coefficients, this.m_Coefficients.length));
                for (i = 0; i < nc; ++i) {
                    this.m_Coefficients[i] = solution.get(i, 0);
                }
                success = true;
            }
            catch (Exception ex) {
                ridge *= 10.0;
                success = false;
            }
        } while (!success);
    }

    public final double[] getCoefficients() {
        return this.m_Coefficients;
    }

    public String toString() {
        return Utils.arrayToString(this.getCoefficients());
    }
}

