/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray;

import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractIndividual;
import org.apache.commons.lang.builder.EqualsBuilder;

public class RealArrayIndividual
extends AbstractIndividual<double[]> {
    private static final long serialVersionUID = 7013687809733709173L;

    public RealArrayIndividual() {
    }

    public RealArrayIndividual(double[] genotype) {
        super(genotype);
    }

    public RealArrayIndividual(double[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        int gl = ((double[])this.genotype).length;
        double[] gother = new double[((double[])this.genotype).length];
        System.arraycopy(this.genotype, 0, gother, 0, gl);
        if (this.fitness != null) {
            return new RealArrayIndividual(gother, this.fitness.copy());
        }
        return new RealArrayIndividual(gother);
    }

    @Override
    public double distance(IIndividual other) {
        double[] gother = (double[])((RealArrayIndividual)other).genotype;
        double distance = 0.0;
        int gl = ((double[])this.genotype).length;
        int i = 0;
        while (i < gl) {
            double aux = ((double[])this.genotype)[i] - gother[i];
            distance += aux * aux;
            ++i;
        }
        return Math.sqrt(distance);
    }

    public boolean equals(Object other) {
        if (other instanceof RealArrayIndividual) {
            RealArrayIndividual iaother = (RealArrayIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((double[])this.genotype, (double[])iaother.genotype);
            return eb.isEquals();
        }
        return false;
    }
}

