/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multisyntaxtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractRecombinator;
import net.sourceforge.jclec.multisyntaxtree.MultiSyntaxTreeIndividual;
import net.sourceforge.jclec.multisyntaxtree.MultiSyntaxTreeSpecies;
import net.sourceforge.jclec.syntaxtree.IRecombineSyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class MultiSyntaxTreeRecombinator
extends AbstractRecombinator
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected IRecombineSyntaxTree baseOp;
    protected transient MultiSyntaxTreeSpecies species;
    protected transient SyntaxTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    public IRecombineSyntaxTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IRecombineSyntaxTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IRecombineSyntaxTree baseOp = (IRecombineSyntaxTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 2;
    }

    @Override
    protected void prepareRecombination() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof MultiSyntaxTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (MultiSyntaxTreeSpecies)spc;
        this.schema = ((MultiSyntaxTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void recombineNext() {
        int nOfSyntaxTrees = this.species.numberOfSyntaxTrees();
        int actTargetSyntaxIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfSyntaxTrees) : this.targetTreeIndex;
        SyntaxTree[] p0_genotype = (SyntaxTree[])((MultiSyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        SyntaxTree[] p1_genotype = (SyntaxTree[])((MultiSyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter + 1)).getGenotype();
        SyntaxTree[] s0_genotype = new SyntaxTree[nOfSyntaxTrees];
        SyntaxTree[] s1_genotype = new SyntaxTree[nOfSyntaxTrees];
        int i = 0;
        while (i < nOfSyntaxTrees) {
            s0_genotype[i] = new SyntaxTree();
            s1_genotype[i] = new SyntaxTree();
            ++i;
        }
        i = 0;
        while (i < nOfSyntaxTrees) {
            if (i == actTargetSyntaxIndex) {
                this.baseOp.recombine(p0_genotype[i], p1_genotype[i], s0_genotype[i], s1_genotype[i], this.schema[i], this.randgen);
            } else {
                s0_genotype[i] = p0_genotype[i].copy();
                s1_genotype[i] = p1_genotype[i].copy();
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(s0_genotype));
        this.sonsBuffer.add(this.species.createIndividual(s1_genotype));
    }
}

