/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.tree.TreeModel;
import java.util.ArrayList;
import java.util.List;

public interface BranchSpecificSubstitutionModelProvider {
    public SubstitutionModel getSubstitutionModel(Tree var1, NodeRef var2);

    public SubstitutionModel getRootSubstitutionModel();

    public List<SubstitutionModel> getSubstitutionModelList();

    public BranchModel.Mapping getBranchModelMapping(NodeRef var1);

    public static class Default
    extends Base
    implements BranchSpecificSubstitutionModelProvider {
        private final TreeModel tree;

        public Default(List<SubstitutionModel> list, TreeModel treeModel) {
            this.substitutionModelList = list;
            this.tree = treeModel;
            assert (list.size() == treeModel.getNodeCount());
        }

        private int getParameterIndexFromNode(NodeRef nodeRef) {
            return nodeRef.getNumber();
        }

        @Override
        public SubstitutionModel getSubstitutionModel(Tree tree, NodeRef nodeRef) {
            return (SubstitutionModel)this.substitutionModelList.get(this.getParameterIndexFromNode(nodeRef));
        }

        @Override
        public SubstitutionModel getRootSubstitutionModel() {
            return (SubstitutionModel)this.substitutionModelList.get(this.getParameterIndexFromNode(this.tree.getRoot()));
        }

        @Override
        public BranchModel.Mapping getBranchModelMapping(final NodeRef nodeRef) {
            return new BranchModel.Mapping(){

                @Override
                public int[] getOrder() {
                    return new int[]{this.getParameterIndexFromNode(nodeRef)};
                }

                @Override
                public double[] getWeights() {
                    return new double[]{1.0};
                }
            };
        }
    }

    public static class None
    extends Base
    implements BranchSpecificSubstitutionModelProvider {
        private final SubstitutionModel substitutionModel;

        public None(SubstitutionModel substitutionModel) {
            this.substitutionModel = substitutionModel;
            this.substitutionModelList.add(this.substitutionModel);
        }

        @Override
        public SubstitutionModel getSubstitutionModel(Tree tree, NodeRef nodeRef) {
            return this.substitutionModel;
        }

        @Override
        public SubstitutionModel getRootSubstitutionModel() {
            return this.substitutionModel;
        }

        @Override
        public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
            return BranchModel.DEFAULT;
        }
    }

    public static abstract class Base
    implements BranchSpecificSubstitutionModelProvider {
        protected List<SubstitutionModel> substitutionModelList = new ArrayList<SubstitutionModel>();

        @Override
        public List<SubstitutionModel> getSubstitutionModelList() {
            return this.substitutionModelList;
        }
    }
}

