/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import java.io.Serializable;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;

public abstract class Decision<E extends Variable>
implements ICause,
Serializable {
    protected transient E var;
    protected int max_branching;
    protected int branch;
    private int position;

    public Decision(int arity) {
        this.max_branching = arity;
    }

    public final void setPosition(int p) {
        this.position = p;
    }

    public final int getPosition() {
        return this.position;
    }

    public final boolean hasNext() {
        return this.branch < this.max_branching;
    }

    public final void buildNext() {
        ++this.branch;
    }

    public final int triesLeft() {
        return this.max_branching - this.branch;
    }

    public final Decision<E> setRefutable(boolean isRefutable) {
        this.max_branching = isRefutable ? 2 : 1;
        return this;
    }

    public final int getArity() {
        return this.max_branching;
    }

    public abstract void apply() throws ContradictionException;

    public final void rewind() {
        this.branch = 0;
    }

    protected void set(E var) {
        this.var = var;
        this.branch = 0;
        this.max_branching = 2;
    }

    public final E getDecisionVariable() {
        return this.var;
    }

    public abstract Object getDecisionValue();

    public abstract void free();

    public void reverse() {
        throw new UnsupportedOperationException();
    }

    public Decision<E> duplicate() {
        throw new UnsupportedOperationException();
    }

    public boolean isEquivalentTo(Decision dec) {
        return false;
    }
}

