/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.GA_Gen_BinCod.wrapper;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Feature_Selection.Datos;
import keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.Cromosoma;
import keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms.CromosomaBinario;
import keel.Dataset.Attributes;
import org.core.Fichero;
import org.core.Randomize;

public class GGABinaryLVO {
    private Datos data;
    private Parametros params;
    private Cromosoma[] poblacion;
    private Cromosoma mejorIndividuo;
    private int nEvalMejorIndividuo;

    public GGABinaryLVO(String ficParametros) {
        this.params = new Parametros(ficParametros);
        Randomize.setSeed(this.params.seed);
        this.data = new Datos(this.params.trainFileNameInput, this.params.testFileNameInput, this.params.paramKNN);
        this.poblacion = new Cromosoma[this.params.tamPoblacion];
        this.mejorIndividuo = new CromosomaBinario(this.data.returnNumFeatures());
        this.nEvalMejorIndividuo = -1;
        for (int i = 0; i < this.params.tamPoblacion; ++i) {
            this.poblacion[i] = new CromosomaBinario(this.data.returnNumFeatures());
        }
    }

    private double fitness(Cromosoma cr) {
        if (cr == null) {
            System.err.println("ERROR: Chromosome doesn't exist");
            System.exit(0);
        }
        boolean[] fv = cr.devolverFeaturesVector();
        double precision = this.data.LVO(fv);
        int numCaracSel = 0;
        for (int i = 0; i < fv.length; ++i) {
            if (!fv[i]) continue;
            ++numCaracSel;
        }
        return (1.0 - this.params.alfa) * (1.0 - precision) - this.params.alfa * ((double)numCaracSel / (double)fv.length);
    }

    private Cromosoma[] seleccionProporcional() {
        int i;
        Cromosoma[] cr = new Cromosoma[this.params.tamPoblacion];
        double[] probabilidades = new double[this.params.tamPoblacion];
        double fitnessTotal = 0.0;
        for (i = 0; i < this.params.tamPoblacion; ++i) {
            fitnessTotal += this.fitness(this.poblacion[i]);
        }
        for (i = 0; i < this.params.tamPoblacion; ++i) {
            probabilidades[i] = this.fitness(this.poblacion[i]) / fitnessTotal;
        }
        for (int k = 0; k < this.params.tamPoblacion; ++k) {
            double nAleatorio = Randomize.RandClosed();
            i = 0;
            int lim = 0;
            while (i < this.params.tamPoblacion && nAleatorio > (double)lim) {
                lim = (int)((double)lim + probabilidades[i++]);
            }
            cr[k] = this.poblacion[i - 1];
        }
        return cr;
    }

    private Cromosoma[] seleccionPorTorneo() {
        Cromosoma[] padres = new Cromosoma[this.params.tamPoblacion];
        Cromosoma[] individuosTorneo = new Cromosoma[this.params.valorKTorneo];
        for (int k = 0; k < padres.length; ++k) {
            int i;
            for (i = 0; i < individuosTorneo.length; ++i) {
                individuosTorneo[i] = this.poblacion[Randomize.Randint(0, this.params.tamPoblacion)];
            }
            Cromosoma mejor = individuosTorneo[0];
            for (i = 1; i < individuosTorneo.length; ++i) {
                if (!(individuosTorneo[i].getFitness() > mejor.getFitness())) continue;
                mejor = individuosTorneo[i];
            }
            padres[k] = mejor;
        }
        return padres;
    }

    private Cromosoma[] mutarYCruzar(Cromosoma[] seleccionados) {
        double aleat;
        int i;
        Cromosoma[] descendientes = new Cromosoma[this.params.tamPoblacion];
        int posPadre2 = -1;
        int posPadre1 = -1;
        int posDescendientes = 0;
        for (i = 0; i < this.params.tamPoblacion; ++i) {
            aleat = Randomize.RandClosed();
            if (aleat <= this.params.probCruce) {
                if (posPadre1 == -1) {
                    posPadre1 = i;
                } else {
                    posPadre2 = i;
                }
            } else {
                descendientes[posDescendientes++] = this.poblacion[i];
            }
            if (posPadre1 == -1 || posPadre2 == -1) continue;
            descendientes[posDescendientes] = new CromosomaBinario(this.data.returnNumFeatures());
            descendientes[posDescendientes + 1] = new CromosomaBinario(this.data.returnNumFeatures());
            this.poblacion[posPadre1].cruzar(this.poblacion[posPadre2], descendientes[posDescendientes], descendientes[posDescendientes + 1]);
            posDescendientes += 2;
            posPadre2 = -1;
            posPadre1 = -1;
        }
        if (posPadre1 != -1 && posPadre2 == -1 && posDescendientes < this.params.tamPoblacion) {
            descendientes[posDescendientes] = this.poblacion[posPadre1];
        }
        for (i = 0; i < this.params.tamPoblacion; ++i) {
            aleat = Randomize.RandClosed();
            if (!(aleat <= this.params.probMutacion)) continue;
            descendientes[i].mutar();
        }
        return descendientes;
    }

    private void elitismo() {
        int i;
        for (i = 0; i < this.params.tamPoblacion && !this.poblacion[i].isEqual(this.mejorIndividuo); ++i) {
        }
        if (i < this.params.tamPoblacion) {
            int peor = 0;
            double fitnessPeor = this.poblacion[0].getFitness();
            for (i = 1; i < this.params.tamPoblacion; ++i) {
                if (!(fitnessPeor > this.poblacion[i].getFitness())) continue;
                fitnessPeor = this.poblacion[i].getFitness();
                peor = i;
            }
            this.poblacion[peor].copy(this.mejorIndividuo);
        }
    }

    private void comprobarCromosomasVacios() {
        int i = 0;
        while (i < this.params.tamPoblacion) {
            boolean vacio = true;
            for (int j = 0; j < this.poblacion[i].devolverTamCromosoma() && vacio; ++j) {
                if (this.poblacion[i].devolverGen(j) == 0) continue;
                vacio = false;
            }
            if (vacio) {
                this.poblacion[i].initRand();
                this.poblacion[i].setFitness(-1.0);
                continue;
            }
            ++i;
        }
    }

    private void modeloGeneracional() {
        int i;
        int nEvaluaciones = 0;
        for (i = 0; i < this.params.tamPoblacion; ++i) {
            this.poblacion[i].initRand();
        }
        while (nEvaluaciones < this.params.numEvaluaciones) {
            this.comprobarCromosomasVacios();
            boolean necesarioElitismo = true;
            for (i = 0; i < this.params.tamPoblacion; ++i) {
                if (this.poblacion[i].getFitness() != -1.0) continue;
                ++nEvaluaciones;
                this.poblacion[i].setFitness(this.fitness(this.poblacion[i]));
                if (this.mejorIndividuo != null && !(this.poblacion[i].getFitness() > this.mejorIndividuo.getFitness())) continue;
                this.mejorIndividuo.copy(this.poblacion[i]);
                this.nEvalMejorIndividuo = nEvaluaciones;
                necesarioElitismo = false;
            }
            if (necesarioElitismo) {
                this.elitismo();
            }
            Cromosoma[] padresSeleccionados = this.seleccionPorTorneo();
            Cromosoma[] descendientes = this.mutarYCruzar(padresSeleccionados);
            this.poblacion = descendientes;
        }
    }

    public void ejecutar() {
        Date d = new Date();
        String resultado = "RESULTS generated at " + String.valueOf(d) + " \n--------------------------------------------------\n";
        resultado = resultado + "Algorithm Name: " + this.params.nameAlgorithm + "\n";
        this.modeloGeneracional();
        resultado = resultado + "\nPARTITION Filename: " + this.params.trainFileNameInput + "\n---------------\n\n";
        resultado = resultado + "Features selected: \n";
        boolean[] features = this.mejorIndividuo.devolverFeaturesVector();
        int numFeatures = 0;
        for (int i = 0; i < features.length; ++i) {
            if (!features[i]) continue;
            resultado = resultado + Attributes.getInputAttribute(i).getName() + " - ";
            ++numFeatures;
        }
        resultado = resultado + "\n Best individual find at " + this.nEvalMejorIndividuo + "evaluation. ";
        resultado = resultado + "\n\n" + String.valueOf(numFeatures) + " features of " + Attributes.getInputNumAttributes() + "\n\n";
        resultado = resultado + "Error in test (using train for prediction): " + String.valueOf(this.data.validacionCruzada(features)) + "\n";
        resultado = resultado + "Error in test (using test for prediction): " + String.valueOf(this.data.LVOTest(features)) + "\n";
        resultado = resultado + "---------------\n";
        System.out.println("Experiment completed successfully");
        Fichero.escribeFichero(this.params.extraFileNameOutput, resultado);
        this.data.generarFicherosSalida(this.params.trainFileNameOutput, this.params.testFileNameOutput, features);
    }

    private class Parametros {
        String nameAlgorithm;
        int paramKNN;
        int valorKTorneo;
        String trainFileNameInput;
        String testFileNameInput;
        String testFileNameOutput;
        String trainFileNameOutput;
        String extraFileNameOutput;
        double probCruce;
        double probMutacion;
        double alfa;
        int tamPoblacion;
        long seed;
        int numEvaluaciones;

        Parametros(String nombreFicheroParametros) {
            try {
                String fichero = Fichero.leeFichero(nombreFicheroParametros);
                fichero = fichero + "\n";
                fichero = fichero.replace('\r', ' ');
                StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n");
                int i = 0;
                while (lineasFichero.hasMoreTokens()) {
                    String linea = lineasFichero.nextToken();
                    ++i;
                    StringTokenizer tokens = new StringTokenizer(linea, " ,\t");
                    if (!tokens.hasMoreTokens()) continue;
                    String tok = tokens.nextToken();
                    if (tok.equalsIgnoreCase("algorithm")) {
                        this.nameAlgorithm = this.getParamString(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inputdata")) {
                        this.getInputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("outputdata")) {
                        this.getOutputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("paramKNN")) {
                        this.paramKNN = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("crossProb")) {
                        this.probCruce = this.getParamDouble(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("mutProb")) {
                        this.probMutacion = this.getParamDouble(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("seed")) {
                        this.seed = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("nEval")) {
                        this.numEvaluaciones = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("alfa")) {
                        this.alfa = this.getParamDouble(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("popLength")) {
                        this.tamPoblacion = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("k")) {
                        this.valorKTorneo = this.getParamInt(tokens);
                        continue;
                    }
                    throw new IOException("Syntax error on line " + i + ": [" + tok + "]\n");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + "Parameter file");
            }
            catch (IOException e) {
                System.err.println(e + "Aborting program");
                System.exit(-1);
            }
            String contents = "-- Parameters echo --- \n";
            contents = contents + "Algorithm name: " + this.nameAlgorithm + "\n";
            contents = contents + "Input Train File: " + this.trainFileNameInput + "\n";
            contents = contents + "Input Test File: " + this.testFileNameInput + "\n";
            contents = contents + "Output Train File: " + this.trainFileNameOutput + "\n";
            contents = contents + "Output Test File: " + this.testFileNameOutput + "\n";
            contents = contents + "Parameter k of KNN Algorithm: " + this.paramKNN + "\n";
            contents = contents + "Cross Prob. : " + this.probCruce + "\n";
            contents = contents + "Mutation Prob.: " + this.probMutacion + "\n";
            contents = contents + "Alfa: " + this.alfa + "\n";
            contents = contents + "Population: " + this.tamPoblacion + "\n";
            contents = contents + "Number of Evals: " + this.numEvaluaciones + "\n";
            contents = contents + "Seed: " + this.seed + "\n";
            contents = contents + "k value for k-tournament: " + this.valorKTorneo + "\n";
            System.out.println(contents);
        }

        private int getParamInt(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Integer.parseInt(val);
        }

        private long getParamLong(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Long.parseLong(val);
        }

        private double getParamDouble(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Double.parseDouble(val);
        }

        private String getParamString(StringTokenizer s) {
            String contenido = "";
            String val = s.nextToken();
            while (s.hasMoreTokens()) {
                contenido = contenido + s.nextToken() + " ";
            }
            return contenido.trim();
        }

        private void getInputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameInput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameInput = s.nextToken().replace('\"', ' ').trim();
        }

        private void getOutputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.extraFileNameOutput = s.nextToken().replace('\"', ' ').trim();
        }
    }
}

