/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.PUBLIC;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.StringTokenizer;
import keel.Algorithms.Decision_Trees.PUBLIC.Node;
import keel.Algorithms.Decision_Trees.PUBLIC.Split;
import keel.Algorithms.Decision_Trees.PUBLIC.TreeNode;
import keel.Algorithms.Decision_Trees.PUBLIC.myAttribute;
import keel.Algorithms.Decision_Trees.PUBLIC.myDataset;
import org.core.Fichero;

public class PUBLIC {
    private TreeNode root;
    private ArrayList<Node> all_nodes;
    private ArrayDeque<Node> queue;
    private String[] outFile;
    private String testFile;
    private String trainFile;
    private String referenceFile;
    private myDataset testDataset;
    private myDataset trainDataset;
    private myDataset referenceDataset;
    private long initialTime = System.currentTimeMillis();
    private double classificationTrainTime;
    private double classificationTestTime;
    private double buildingTime;
    private int correctTrain;
    private int failTrain;
    private int correctTest;
    private int failTest;
    private int nodesBetweenPrune;
    private char publicPruneEstimation;

    public PUBLIC(String script) {
        this.readConfiguration(script);
        this.readParameters(script);
        try {
            this.trainDataset = new myDataset(this.trainFile, 1);
            this.testDataset = new myDataset(this.testFile, 3);
            this.referenceDataset = new myDataset(this.referenceFile, 2);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        this.buildTree();
    }

    private void buildTree() {
        this.all_nodes = new ArrayList();
        System.out.println("\nInitializing root node");
        long buildTime = System.currentTimeMillis();
        Node auxnode = this.initializeRootNode();
        System.out.println("Root node initialized");
        int numnodes = 1;
        int numnodesproccessed = 0;
        this.queue = new ArrayDeque();
        this.queue.add(auxnode);
        this.all_nodes.add(auxnode);
        while (!this.queue.isEmpty()) {
            TreeNode auxtreenode;
            auxnode = this.queue.poll();
            System.out.println("\nBeginning node processing...");
            if (!auxnode.isPure()) {
                Split best_split = auxnode.evaluateAllSplits();
                ArrayList<Node> nodes = auxnode.split(best_split, numnodes);
                if (nodes == null) {
                    auxtreenode = this.root.getNode(auxnode.getIdentifier());
                    auxtreenode.setLeaf(true);
                    auxtreenode.setOutputClass(auxnode.getMajorOutputClass());
                    ++numnodesproccessed;
                } else {
                    auxtreenode = this.root.getNode(auxnode.getIdentifier());
                    auxtreenode.setLeft(new TreeNode(numnodes + 1, null, null, false, -1, null));
                    auxtreenode.setRight(new TreeNode(numnodes + 2, null, null, false, -1, null));
                    auxtreenode.setCondition(new Split(best_split));
                    this.queue.add(nodes.get(0));
                    this.queue.add(nodes.get(1));
                    this.all_nodes.add(nodes.get(0));
                    this.all_nodes.add(nodes.get(1));
                    numnodes += 2;
                    ++numnodesproccessed;
                }
            } else {
                auxtreenode = this.root.getNode(auxnode.getIdentifier());
                auxtreenode.setLeaf(true);
                auxtreenode.setOutputClass(auxnode.getOutputClass());
                ++numnodesproccessed;
            }
            if (numnodesproccessed % this.nodesBetweenPrune != 0) continue;
            System.out.println("\nBeginning pruning...");
            this.computeCostPrunePublic(this.root);
            System.out.println("Pruning phase finished!");
        }
        System.out.println("\nBeginning final prune...");
        this.computeCostPrunePublic(this.root);
        System.out.println("Last prune finished!");
        this.buildingTime = (double)(System.currentTimeMillis() - buildTime) / 1000.0;
        System.out.println("\nBuilding of the tree finished!!");
        System.out.println(numnodes + " nodes generated");
    }

    public void execute() {
        System.out.println();
        System.out.println("Beginning classification...");
        System.out.println();
        this.print(this.referenceDataset, this.outFile[0], 0);
        this.print(this.testDataset, this.outFile[1], 1);
        this.printResults(this.trainDataset, this.outFile[2]);
        System.out.println("Classification FINISHED!!");
        System.out.println();
        System.out.println(this.getStatistical());
    }

    protected void readConfiguration(String script) {
        this.outFile = new String[3];
        String fichero = Fichero.leeFichero(script);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.trainFile = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.referenceFile = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.testFile = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[1] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[2] = new String(line, i, j - i);
    }

    protected void readParameters(String script) {
        String file = Fichero.leeFichero(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.nodesBetweenPrune = Integer.parseInt(tokens.nextToken().substring(1));
        if (this.nodesBetweenPrune < 1) {
            System.err.println("Error: The minimum number of nodes that are generated between prunes is 1");
            System.exit(-1);
        }
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.publicPruneEstimation = tokens.nextToken().substring(1).charAt(7);
        if (this.publicPruneEstimation != '1' && this.publicPruneEstimation != 'S' && this.publicPruneEstimation != 'V') {
            System.err.println("Error: The different ways to estimate the cost of the tree for pruning are PUBLIC(1), PUBLIC(S) or PUBLIC(V)");
            System.exit(-1);
        }
    }

    private Node initializeRootNode() {
        Node auxnode = new Node(this.trainDataset, 1);
        this.root = new TreeNode(1, null, null, false, -1, null);
        return auxnode;
    }

    private double computeCostPrunePublic(TreeNode node) {
        Node aux_node = null;
        boolean found = false;
        for (int i = 0; i < this.all_nodes.size() && !found; ++i) {
            aux_node = this.all_nodes.get(i);
            if (aux_node.getIdentifier() != node.getIdentifier()) continue;
            found = true;
        }
        if (node.getLeft() == null && node.getRight() == null && !node.isLeaf()) {
            switch (this.publicPruneEstimation) {
                case '1': {
                    return 1.0;
                }
                case 'S': {
                    return this.computeMinCostS(aux_node);
                }
                case 'V': {
                    double costV1 = this.computeMinCostV(aux_node);
                    double costV2 = this.computeMinCostV2(aux_node);
                    if (costV1 < costV2) {
                        return costV1;
                    }
                    return costV2;
                }
            }
            System.err.println("The prune estimation selected isn't correct");
            System.exit(-1);
        }
        if (node.getLeft() == null && node.getRight() != null || node.getLeft() != null && node.getRight() == null) {
            System.err.println("The node " + node.getIdentifier() + " is badly built");
            System.exit(-1);
        }
        if (node.isLeaf()) {
            return this.C(aux_node) + 1.0;
        }
        double minCost1 = this.computeCostPrunePublic(node.getLeft());
        double minCost2 = this.computeCostPrunePublic(node.getRight());
        double minCostN = this.C_split(node, aux_node) + minCost1 + minCost2;
        double aux = this.C(aux_node) + 1.0;
        if (aux < minCostN) {
            minCostN = aux;
        }
        if (minCostN == aux) {
            System.out.println("Node " + node.getIdentifier() + " and its children are pruned");
            ArrayList<Integer> nodesToRemove = node.deleteDescendants(node.getIdentifier());
            for (int i = 0; i < nodesToRemove.size(); ++i) {
                boolean removed = false;
                for (int j = 0; j < this.all_nodes.size() && !removed; ++j) {
                    if (this.all_nodes.get(j).getIdentifier() != nodesToRemove.get(i).intValue()) continue;
                    this.queue.remove(this.all_nodes.get(j));
                    this.all_nodes.remove(j);
                    removed = true;
                }
            }
            node.setLeaf(true);
            node.setOutputClass(aux_node.getMajorOutputClass());
        }
        return minCostN;
    }

    private double C(Node aux_node) {
        double cost = 0.0;
        for (int i = 0; i < this.trainDataset.getNumClasses(); ++i) {
            int ni = aux_node.getNumItemsClassI(i);
            if (ni == 0) continue;
            cost += (double)ni * (Math.log((double)aux_node.getNumRegisters() / (double)ni) / Math.log(2.0));
        }
        cost += (double)(aux_node.getNumClasses() - 1) / 2.0 * (Math.log((double)aux_node.getNumRegisters() / 2.0) / Math.log(2.0));
        return cost += Math.log(Math.pow(Math.PI, (double)aux_node.getNumClasses() / 2.0) / this.gamma(aux_node.getNumClasses(), 2)) / Math.log(2.0);
    }

    private double gamma(int dividend, int divisor) {
        if (divisor == 2) {
            double gamma = dividend % 2 == 0 ? (double)this.factorial(dividend / divisor - 1) : (dividend != 1 ? Math.sqrt(Math.PI) * ((double)this.double_factorial(dividend - 2) / Math.pow(2.0, (double)(dividend - 1) / 2.0)) : Math.sqrt(Math.PI));
            return gamma;
        }
        System.err.println("This gamma function only computes integers or numbers divided by two");
        System.exit(-1);
        return 0.0;
    }

    private int factorial(int x) {
        int aux = 1;
        aux = x == 0 ? 1 : (aux *= this.factorial(x - 1));
        return aux;
    }

    private int double_factorial(int x) {
        int aux = 1;
        aux = x == 1 ? 1 : (aux *= this.double_factorial(x - 2));
        return aux;
    }

    private double C_split(TreeNode node, Node aux_node) {
        double cost = Math.log(this.trainDataset.getNumAtr()) / Math.log(2.0);
        if (this.trainDataset.getAttributes().get(node.getCondition().getAttribute()).isNominal()) {
            cost += Math.log(Math.pow(2.0, this.trainDataset.getAttributes().get(node.getCondition().getAttribute()).getValues().size()) - 2.0) / Math.log(2.0);
        } else {
            int aux = aux_node.getDifferentValuesAttributeI(node.getCondition().getAttribute());
            cost += Math.log((double)aux - 1.0) / Math.log(2.0);
        }
        return cost;
    }

    private double computeMinCostS(Node N) {
        ArrayList<ArrayList<Integer>> ni = N.getDecreasedNI();
        if (ni.get(0).size() == 1) {
            return this.C(N) + 1.0;
        }
        int s = 0;
        double tmpCost = (double)(2 * s + 1) + (double)s * (Math.log(this.trainDataset.getNumAtr()) / Math.log(2.0));
        for (int i = s + 2; i < ni.get(0).size(); ++i) {
            tmpCost += (double)ni.get(1).get(i).intValue();
        }
        while (s + 1 < ni.get(0).size() - 1 && (double)ni.get(1).get(s + 2).intValue() > 2.0 + Math.log(this.trainDataset.getNumAtr()) / Math.log(2.0)) {
            tmpCost = tmpCost + 2.0 + Math.log(this.trainDataset.getNumAtr()) / Math.log(2.0) - (double)ni.get(1).get(s + 2).intValue();
            ++s;
        }
        double aux = this.C(N) + 1.0;
        if (tmpCost < aux) {
            aux = tmpCost;
        }
        return aux;
    }

    private double computeMinCostV(Node N) {
        int k = N.getNumClasses();
        if (k == 1) {
            return this.C(N) + 1.0;
        }
        ArrayList<ArrayList<Integer>> ni = N.getDecreasedNIV();
        int s = 1;
        double tmpCost = 1.0;
        for (int i = 0; i < k; ++i) {
            tmpCost += (double)ni.get(1).get(i).intValue();
        }
        double minCost = tmpCost;
        while (s <= k) {
            tmpCost = tmpCost + 2.0 + Math.log(this.trainDataset.getNumAtr()) / Math.log(2.0) - ((double)ni.get(1).get(s - 1).intValue() - N.V(s - 1));
            double max = 0.0;
            for (int w = s + 1; w <= k; ++w) {
                if (!((double)ni.get(1).get(w - 1).intValue() > max)) continue;
                max = ni.get(1).get(w - 1).intValue();
            }
            double auxCost = tmpCost - max;
            if (auxCost < minCost) {
                minCost = auxCost;
            }
            ++s;
        }
        double aux = this.C(N) + 1.0;
        if (minCost < aux) {
            aux = minCost;
        }
        return aux;
    }

    private double computeMinCostV2(Node N) {
        int i;
        int k = N.getNumClasses();
        if (k == 1) {
            return this.C(N) + 1.0;
        }
        int[] B = new int[2 * k];
        ArrayList<ArrayList<Integer>> ni = N.getDecreasedNI();
        for (i = 0; i < k; ++i) {
            B[2 * i + 1] = (int)N.V(i);
            B[2 * i] = ni.get(1).get(i) - B[2 * i + 1];
        }
        for (i = 0; i < 2 * k - 1; ++i) {
            int current = B[i];
            int w = i;
            for (int j = i + 1; j < B.length; ++j) {
                if (current >= B[j]) continue;
                w = j;
                current = B[j];
            }
            B[w] = B[i];
            B[i] = current;
        }
        int s = 0;
        double tmpCost = 1.0;
        for (i = 0; i < k; ++i) {
            tmpCost += (double)ni.get(1).get(i).intValue();
        }
        double minCost = tmpCost;
        while (s < 2 * k - 1) {
            double auxCost = (tmpCost = tmpCost + 2.0 + Math.log(this.trainDataset.getNumAtr()) / Math.log(2.0) - (double)B[s]) - (double)B[s + 1];
            if (auxCost < minCost) {
                minCost = auxCost;
            }
            ++s;
        }
        double aux = this.C(N) + 1.0;
        if (minCost < aux) {
            aux = minCost;
        }
        return aux;
    }

    private String getHeader(myDataset dat) {
        ArrayList<myAttribute> attributes = dat.getAttributes();
        myAttribute output = dat.getOutputAttribute();
        String header = "@relation " + dat.getName() + "\n";
        block10: for (int i = 0; i < attributes.size(); ++i) {
            switch (attributes.get(i).getAttributeType()) {
                case 1: {
                    header = header + "@attribute " + attributes.get(i).getName() + " integer[" + (int)attributes.get(i).getMin() + "," + (int)attributes.get(i).getMax() + "]\n";
                    continue block10;
                }
                case 2: {
                    header = header + "@attribute " + attributes.get(i).getName() + " real[" + attributes.get(i).getMin() + "," + attributes.get(i).getMax() + "]\n";
                    continue block10;
                }
                case 3: {
                    header = header + "@attribute " + attributes.get(i).getName() + " {";
                    for (int j = 0; j < attributes.get(i).getValues().size() - 1; ++j) {
                        header = header + attributes.get(i).getValue(j) + ",";
                    }
                    header = header + attributes.get(i).getValue(attributes.get(i).getValues().size() - 1) + "}\n";
                }
            }
        }
        switch (output.getAttributeType()) {
            case 1: {
                header = header + "@attribute " + output.getName() + " integer[" + (int)output.getMin() + "," + (int)output.getMax() + "]\n";
                break;
            }
            case 2: {
                header = header + "@attribute " + output.getName() + " real[" + output.getMin() + "," + output.getMax() + "]\n";
                break;
            }
            case 3: {
                header = header + "@attribute " + output.getName() + " {";
                for (int j = 0; j < output.getValues().size() - 1; ++j) {
                    header = header + output.getValue(j) + ",";
                }
                header = header + output.getValue(output.getValues().size() - 1) + "}\n";
            }
        }
        return header;
    }

    public int evaluateItem(double[] item, ArrayList<myAttribute> atts) {
        return this.root.evaluate(item, atts);
    }

    public void print(myDataset data, String filename, int type) {
        String text = this.getHeader(data);
        text = text + "@data\n";
        double[] item = new double[data.getNumAtr()];
        int correct = 0;
        int fail = 0;
        long time = System.currentTimeMillis();
        for (int i = 0; i < data.getNumIns(); ++i) {
            try {
                item = data.getDataItem(i);
                int cl = this.evaluateItem(item, data.getAttributes());
                if (cl == data.getOutputI(i)) {
                    ++correct;
                } else {
                    ++fail;
                }
                text = text + data.getOutputAttribute().getValue(data.getOutputI(i)) + " " + data.getOutputAttribute().getValue(cl) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if (type == 0) {
            this.classificationTrainTime = (double)(System.currentTimeMillis() - time) / 1000.0;
            this.correctTrain = correct;
            this.failTrain = fail;
        } else if (type == 1) {
            this.classificationTestTime = (double)(System.currentTimeMillis() - time) / 1000.0;
            this.correctTest = correct;
            this.failTest = fail;
        } else {
            System.err.println("Wrong dataset for printing results");
            System.exit(-1);
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(filename));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the output file " + filename + ": " + e.getMessage());
        }
    }

    private String getStatistical() {
        String text = "";
        text = text + "@TotalNumberOfNodes " + this.root.getNumNodes() + "\n";
        text = text + "@NumberOfLeafs " + this.root.getLeafs() + "\n\n";
        text = text + "@NumberOfItemsetsTraining " + this.referenceDataset.getNumIns() + "\n";
        text = text + "@NumberOfCorrectlyClassifiedTraining " + this.correctTrain + "\n";
        text = text + "@PercentageOfCorrectlyClassifiedTraining " + (double)this.correctTrain * 100.0 / (double)this.referenceDataset.getNumIns() + "%\n";
        text = text + "@NumberOfIncorrectlyClassifiedTraining " + this.failTrain + "\n";
        text = text + "@PercentageOfIncorrectlyClassifiedTraining " + (double)this.failTrain * 100.0 / (double)this.referenceDataset.getNumIns() + "%\n\n";
        text = text + "@NumberOfItemsetsTest " + this.testDataset.getNumIns() + "\n";
        text = text + "@NumberOfCorrectlyClassifiedTest " + this.correctTest + "\n";
        text = text + "@PercentageOfCorrectlyClassifiedTest " + (double)this.correctTest * 100.0 / (double)this.testDataset.getNumIns() + "%\n";
        text = text + "@NumberOfIncorrectlyClassifiedTest " + this.failTest + "\n";
        text = text + "@PercentageOfIncorrectlyClassifiedTest " + (double)this.failTest * 100.0 / (double)this.testDataset.getNumIns() + "%\n\n";
        text = text + "@TotalElapsedTime " + (double)(System.currentTimeMillis() - this.initialTime) / 1000.0 + "s\n";
        text = text + "@BuildingElapsedTime " + this.buildingTime + "s\n";
        text = text + "@ClassificationTrainElapsedTime " + this.classificationTrainTime + "s\n";
        text = text + "@ClassificationTestElapsedTime " + this.classificationTestTime + "s\n";
        return text;
    }

    public void printResults(myDataset data, String filename) {
        String text = this.getHeader(data);
        text = text + "@inputs\n";
        for (int i = 0; i < data.getAttributes().size(); ++i) {
            text = text + data.getAttributes().get(i).getName() + " ";
        }
        text = text + "\n@outputs " + data.getOutputAttribute().getName() + "\n@data\n\n@decisiontree\n\n" + this.root.printTree(data.getAttributes(), data.getOutputAttribute()) + "\n";
        text = text + this.getStatistical();
        try {
            PrintWriter print = new PrintWriter(new FileWriter(filename));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the output file " + filename + ": " + e.getMessage());
        }
    }
}

