/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.IClassifier;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IDataset;

public class Classifier
implements IClassifier {
    private static final long serialVersionUID = 1L;
    private List<IClassificationRule> rules;
    private double defaultClass;

    public Classifier() {
    }

    public Classifier(List<IClassificationRule> rules, double defaultC) {
        this.rules = rules;
        this.defaultClass = defaultC;
    }

    public void setClassificationRules(List<IClassificationRule> rules) {
        this.rules = rules;
    }

    public List<IClassificationRule> getClassificationRules() {
        return this.rules;
    }

    public double getDefaultClass() {
        return this.defaultClass;
    }

    public void setDefaultClass(double defaultClass) {
        this.defaultClass = defaultClass;
    }

    public void addClassificationRule(IClassificationRule rule) {
        if (this.rules != null) {
            this.rules.add(rule);
        } else {
            this.rules = new ArrayList<IClassificationRule>();
            this.rules.add(rule);
        }
    }

    public void clearRules() {
        this.rules.clear();
    }

    public IClassificationRule getClassificationRule(int index) {
        return this.rules.get(index);
    }

    @Override
    public double[] classify(IDataset data) {
        try {
            data.reset();
            int numInstances = data.numberOfInstances();
            int numRules = this.getClassificationRules().size();
            double[] result = new double[numInstances];
            boolean cover = false;
            IDataset.IInstance[] instances = new IDataset.IInstance[numInstances];
            data.reset();
            int i = 0;
            while (i < numInstances) {
                data.next();
                instances[i] = data.read().copy();
                ++i;
            }
            i = 0;
            while (i < numInstances) {
                int j = 0;
                while (j < numRules) {
                    if (this.getClassificationRule(j).covers(instances[i])) {
                        result[i] = this.getClassificationRule(j).getConsequent();
                        cover = true;
                    }
                    ++j;
                }
                if (!cover) {
                    result[i] = this.getDefaultClass();
                }
                cover = false;
                ++i;
            }
            return result;
        }
        catch (DatasetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public double classify(IDataset.IInstance inst) {
        int numRules = this.getClassificationRules().size();
        int i = 0;
        while (i < numRules) {
            if (this.getClassificationRules().get(i).covers(inst)) {
                return this.getClassificationRule(i).getConsequent();
            }
            ++i;
        }
        return -1.0;
    }

    public String toString() {
        String result = new String();
        int numRules = this.getClassificationRules().size();
        int i = 0;
        while (i < numRules) {
            result = this.getClassificationRule(i).toString();
            ++i;
        }
        return result;
    }
}

