/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.base.DecoratedRecombinator;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class FilteredRecombinator
extends DecoratedRecombinator {
    private static final long serialVersionUID = 9168537902966940372L;
    protected double recProb;
    protected IRandGen randgen;
    protected transient List<IIndividual> fertile = new ArrayList<IIndividual>();
    protected transient List<IIndividual> sterile = new ArrayList<IIndividual>();

    public FilteredRecombinator() {
    }

    public FilteredRecombinator(ISystem context) {
        this.contextualize(context);
    }

    public final double getRecProb() {
        return this.recProb;
    }

    public final void setRecProb(double recProb) {
        this.recProb = recProb;
    }

    @Override
    public void contextualize(ISystem context) {
        super.contextualize(context);
        this.randgen = context.createRandGen();
    }

    @Override
    public List<IIndividual> recombine(List<IIndividual> parents) {
        this.fertile.clear();
        this.sterile.clear();
        for (IIndividual ind : parents) {
            if (this.randgen.coin(this.recProb)) {
                this.fertile.add(ind);
                continue;
            }
            this.sterile.add(ind);
        }
        int rest = this.fertile.size() % this.decorated.getPpl();
        if (rest != 0) {
            int i = 0;
            int j = this.fertile.size() - 1;
            while (i < rest) {
                this.sterile.add(this.fertile.remove(j));
                ++i;
                --j;
            }
        }
        return this.decorated.recombine(this.fertile);
    }

    public List<IIndividual> getSterile() {
        return this.sterile;
    }

    public List<IIndividual> getFertile() {
        return this.fertile;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double recProb = settings.getDouble("recombination-prob", 0.5);
        this.setRecProb(recProb);
    }

    public boolean equals(Object other) {
        if (other instanceof FilteredRecombinator) {
            FilteredRecombinator o = (FilteredRecombinator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.decorated, o.decorated);
            eb.append(this.recProb, o.recProb);
            return eb.isEquals();
        }
        return false;
    }
}

