/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISystem;
import org.apache.commons.configuration.Configuration;

public abstract class DecoratedRecombinator
implements IRecombinator,
IConfigure {
    protected IRecombinator decorated;
    protected ISystem context;

    public DecoratedRecombinator() {
    }

    public DecoratedRecombinator(ISystem context) {
        this.contextualize(context);
    }

    public final IRecombinator getDecorated() {
        return this.decorated;
    }

    public final void setDecorated(IRecombinator decorated) {
        this.decorated = decorated;
        if (this.context != null) {
            decorated.contextualize(this.context);
        }
    }

    @Override
    public void contextualize(ISystem context) {
        this.context = context;
        if (this.decorated != null) {
            this.decorated.contextualize(context);
        }
    }

    @Override
    public final int getPpl() {
        return this.decorated.getPpl();
    }

    @Override
    public final int getSpl() {
        return this.decorated.getSpl();
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String decoratedClassname = settings.getString("decorated[@type]");
            Class<?> decoratedClass = Class.forName(decoratedClassname);
            IRecombinator decorated = (IRecombinator)decoratedClass.newInstance();
            if (decorated instanceof IConfigure) {
                ((IConfigure)((Object)decorated)).configure(settings.subset("decorated"));
            }
            this.setDecorated(decorated);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

