/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import org.rosuda.deducer.widgets.param.Param;
import org.w3c.dom.Element;

public class ParamNumeric
extends Param {
    protected Double value;
    protected Double defaultValue;

    public ParamNumeric() {
        this.name = "";
        this.title = "";
        this.value = null;
        this.defaultValue = null;
        this.view = "org.rosuda.deducer.widgets.param.ParamTextFieldWidget";
    }

    public ParamNumeric(String string) {
        this.name = string;
        this.title = string;
        this.value = null;
        this.defaultValue = null;
        this.view = "org.rosuda.deducer.widgets.param.ParamTextFieldWidget";
    }

    public ParamNumeric(String string, double d) {
        this.name = string;
        this.title = string;
        this.value = new Double(d);
        this.defaultValue = new Double(d);
        this.view = "org.rosuda.deducer.widgets.param.ParamTextFieldWidget";
    }

    public ParamNumeric(String string, String string2, String string3, Double d, Double d2) {
        this.name = string;
        this.title = string2;
        this.view = string3;
        this.value = d;
        this.defaultValue = d2;
        this.view = "org.rosuda.deducer.widgets.param.ParamTextFieldWidget";
    }

    @Override
    public Object clone() {
        int n;
        String[] stringArray;
        ParamNumeric paramNumeric = new ParamNumeric();
        paramNumeric.setName(this.getName());
        paramNumeric.setTitle(this.getTitle());
        if (this.getLowerBound() != null) {
            paramNumeric.setLowerBound(new Double(this.getLowerBound()));
        }
        if (this.getUpperBound() != null) {
            paramNumeric.setUpperBound(new Double(this.getUpperBound()));
        }
        paramNumeric.setViewType(this.getViewType());
        if (this.value != null) {
            paramNumeric.setValue(new Double(this.value));
        }
        if (this.defaultValue != null) {
            paramNumeric.setDefaultValue(new Double(this.defaultValue));
        }
        if (this.getOptions() != null) {
            stringArray = new String[this.getOptions().length];
            for (n = 0; n < this.getOptions().length; ++n) {
                stringArray[n] = this.getOptions()[n];
            }
            paramNumeric.setOptions(stringArray);
        }
        if (this.getLabels() != null) {
            stringArray = new String[this.getLabels().length];
            for (n = 0; n < this.getLabels().length; ++n) {
                stringArray[n] = this.getLabels()[n];
            }
            paramNumeric.setLabels(stringArray);
        }
        paramNumeric.required = this.required;
        return paramNumeric;
    }

    @Override
    public String[] getParamCalls() {
        String[] stringArray;
        if (this.getValue() != null && !this.getValue().equals(this.getDefaultValue())) {
            String string = "";
            string = this.getDefaultValue() == null || this.getValue() != null && !this.getDefaultValue().toString().equals(this.getValue().toString()) ? this.getValue().toString() : "";
            stringArray = string.length() > 0 ? new String[]{(this.name != null ? this.name + " = " : "") + string} : new String[]{};
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public void setDefaultValue(Object object) {
        if (object instanceof Double || object == null) {
            this.defaultValue = (Double)object;
        } else {
            System.out.println("ParamNumeric: invalid setDefaultValue");
        }
    }

    public void setDefaultValue(double d) {
        this.defaultValue = new Double(d);
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof Double || object == null) {
            this.value = (Double)object;
        } else if (object instanceof String) {
            this.value = new Double(Double.parseDouble(object.toString()));
        } else {
            System.out.println("ParamNumeric: invalid setValue");
            Exception exception = new Exception();
            exception.printStackTrace();
        }
    }

    public void setValue(double d) {
        this.value = new Double(d);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Element toXML() {
        Element element = super.toXML();
        if (this.value != null) {
            element.setAttribute("value", this.value.toString());
        }
        if (this.defaultValue != null) {
            element.setAttribute("defaultValue", this.defaultValue.toString());
        }
        element.setAttribute("className", "org.rosuda.deducer.widgets.param.ParamNumeric");
        return element;
    }

    @Override
    public void setFromXML(Element element) {
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.widgets.param.ParamNumeric")) {
            System.out.println("Error ParamNumeric: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        super.setFromXML(element);
        this.value = element.hasAttribute("value") ? new Double(Double.parseDouble(element.getAttribute("value"))) : null;
        this.defaultValue = element.hasAttribute("defaultValue") ? new Double(Double.parseDouble(element.getAttribute("defaultValue"))) : null;
    }

    @Override
    public boolean hasValidEntry() {
        return this.value != null || this.defaultValue != null;
    }
}

