/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import dsa.Interval;
import dsa.Split;
import java.util.HashSet;
import java.util.Set;

class NumericInterval
implements Interval {
    String varname;
    double lower;
    double upper;

    NumericInterval(String varname, double lower, double upper) {
        assert (upper >= lower);
        this.varname = varname;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public String getVarName() {
        return this.varname;
    }

    @Override
    public int satisfied(Split split) {
        assert (split.varname.equals(this.varname));
        if (split.value >= this.upper) {
            return 0;
        }
        if (split.value <= this.lower) {
            return 1;
        }
        return -1;
    }

    @Override
    public Set<Split> getsplits() {
        HashSet<Split> s = new HashSet<Split>();
        if (!Double.isInfinite(this.upper)) {
            s.add(new Split(this.varname, this.upper));
        }
        if (!Double.isInfinite(this.lower)) {
            s.add(new Split(this.varname, this.lower));
        }
        return s;
    }

    public String toString() {
        if (this.lower > Double.NEGATIVE_INFINITY) {
            if (this.upper < Double.POSITIVE_INFINITY) {
                return String.format("%f < %s <= %f", this.lower, this.varname, this.upper);
            }
            return String.format("%f < %s", this.lower, this.varname);
        }
        if (this.upper < Double.POSITIVE_INFINITY) {
            return String.format("%s <= %f", this.varname, this.upper);
        }
        return String.format("%f < %s <= %f", this.lower, this.varname, this.upper);
    }
}

