## ----setup, include=FALSE---------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  echo = TRUE,
  message = FALSE,
  warning = FALSE,
  fig.width = 8,
  fig.height = 6,
  out.width = "100%",
  dpi = 300,
  collapse = TRUE,
  comment = "#>"
)

options(
  width = 120,
  pillar.min_chars = 15,
  pillar.min_title_chars = Inf,
  tibble.print_max = 10
)

# Load required packages
library(cpam)  
library(dplyr)
library(tidyr)
library(stringr)
library(ggplot2)

#"cpam: <u>c</u>hange<u>p</u>oint <u>a</u>dditive <u>m</u>odels"


## ----installation, eval=FALSE-----------------------------------------------------------------------------------------
# install.packages("cpam")

## ----loading, eval=FALSE----------------------------------------------------------------------------------------------
# library(cpam)
# library(dplyr)
# library(tidyr)
# library(stringr)
# library(ggplot2)
# 

## ----experimental-design----------------------------------------------------------------------------------------------

# load example data
load(system.file("extdata", "exp_design_example.rda", package = "cpam"))
exp_design_example

## ----count-matrix-----------------------------------------------------------------------------------------------------
# load example data
load(system.file("extdata", "count_matrix_example.rda", package = "cpam"))
as.data.frame(count_matrix_example) %>% head 

## ----fitting-the-model, eval = T--------------------------------------------------------------------------------------
  cpo <- prepare_cpam(exp_design = exp_design_example,
                      count_matrix = count_matrix_example,
                      model_type = "case-only",
                      t2g = NULL,
                      gene_level = T,
                      num_cores = 1) # just for the example
  cpo <- compute_p_values(cpo) # 6 seconds
  cpo <- estimate_changepoint(cpo) # 4 seconds
  cpo <- select_shape(cpo) # 5 seconds

## ----print-cpo--------------------------------------------------------------------------------------------------------
cpo

## ----results-1--------------------------------------------------------------------------------------------------------
results(cpo)

## ----filtered-results-------------------------------------------------------------------------------------------------
results(cpo, min_count = 10, min_lfc = 1, p_threshold = 0.01)

## ----plot-g063--------------------------------------------------------------------------------------------------------
plot_cpam(cpo, gene_id = "g063")

## ----find-tp-gene-----------------------------------------------------------------------------------------------------
results(cpo) %>% 
  filter(shape == "tp")

## ----plot-g210--------------------------------------------------------------------------------------------------------
plot_cpam(cpo, gene_id = "g210")

## ----plot-g210-shape2-------------------------------------------------------------------------------------------------
plot_cpam(cpo, gene_id = "g210",shape_type = "shape2")

## ----results-cp3}-----------------------------------------------------------------------------------------------------
results(cpo) %>% 
  filter(cp == 3)

## ----plot-g013--------------------------------------------------------------------------------------------------------
plot_cpam(cpo, gene_id = "g013")

## ----clusters-1, cache=TRUE-------------------------------------------------------------------------------------------
res <- results(cpo)
plot_cluster(cpo, res, changepoints = 1, shapes = c("cv"))

## ----clusters-2, cache=TRUE-------------------------------------------------------------------------------------------
plot_cluster(cpo, res, changepoints = 2, shapes = c("dlin","mdcx"))

## ----session-info-----------------------------------------------------------------------------------------------------
sessionInfo()

