/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.AttributeValueType;
import eu.kliegr.ac1.data.DataTable;
import eu.kliegr.ac1.rule.AttributeNotFoundException;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.RuleMultiItemCache;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Data {
    private static final Logger LOGGER = Logger.getLogger(Data.class.getName());
    private DataTable dt;
    private RuleMultiItemCache cache = new RuleMultiItemCache();

    public void purge() {
        this.dt = null;
        this.cache = new RuleMultiItemCache();
    }

    public boolean isInitialized() {
        return this.dt != null;
    }

    public DataTable newDataTable(String[] colNames, String targetColName, ArrayList<AttributeType> attributeTypes, String IDcolumnName) throws Exception {
        this.dt = new DataTable(colNames, targetColName, attributeTypes, IDcolumnName);
        return this.dt;
    }

    public DataTable getDataTable() {
        return this.dt;
    }

    public Attribute getTargetAttribute() {
        return this.dt.getTargetAttribute();
    }

    public RuleMultiItem makeRuleItem(ArrayList<AttributeValue> values, String attributeName) {
        RuleMultiItem rmi = this.cache.get(values);
        if (rmi == null) {
            rmi = new RuleMultiItem(values, this.dt.getAttribute(attributeName));
            this.cache.put(rmi);
        }
        return rmi;
    }

    public RuleMultiItem makeRuleItem(ArrayList<AttributeValue> attributeValues, ArrayList<ValueOrigin> valueOrigin, Attribute attribute, ValueOrigin lastModificationType) {
        RuleMultiItem ri = new RuleMultiItem(attributeValues, valueOrigin, attribute, lastModificationType);
        return ri;
    }

    public Collection<AttributeValue> getValuesOfTargetAttribute() {
        Attribute at = this.dt.getTargetAttribute();
        return at.getAllValues();
    }

    public Collection<AttributeValue> getValuesInRange(String attributeName, float leftMargin, boolean fromInclusive, float rightMargin, boolean toInclusive, boolean negated) {
        Collection<AttributeValue> list;
        Attribute at = this.dt.getAttribute(attributeName);
        if (!negated) {
            try {
                list = at.getValuesInRange(Float.valueOf(leftMargin), fromInclusive, Float.valueOf(rightMargin), toInclusive);
            }
            catch (Exception e) {
                Collection<AttributeValue> list2 = at.getValuesInRange(Float.valueOf(leftMargin), fromInclusive, Float.valueOf(rightMargin), toInclusive);
                throw e;
            }
        } else {
            Collection<AttributeValue> negativeList = at.getValuesInRange(Float.valueOf(leftMargin), fromInclusive, Float.valueOf(rightMargin), toInclusive);
            list = at.getAllValues();
            list.removeAll(negativeList);
        }
        if (list.isEmpty()) {
            LOGGER.log(Level.INFO, "Warning: no matching attribute value found for {0}={1};{2}", new Object[]{attributeName, Float.valueOf(leftMargin), Float.valueOf(rightMargin)});
        }
        return list;
    }

    public AttributeValue getValue(String attributeName, String value, AttributeValueType type) throws AttributeNotFoundException {
        Attribute at = this.dt.getAttribute(attributeName);
        if (at == null) {
            throw new AttributeNotFoundException("Attribute " + attributeName + " not found in the data");
        }
        AttributeValue val = at.getValueByString(value);
        if (val == null) {
            val = at.addNewValue(value, null, type);
        } else if (val.getType() != type) {
            val.updateType(type);
        }
        return val;
    }

    public Collection<AttributeValue> getValuesByEnumeration(String attributeName, String[] values, boolean negated, AttributeValueType type) throws AttributeNotFoundException {
        Collection<AttributeValue> list;
        Attribute at = this.dt.getAttribute(attributeName);
        if (!negated) {
            list = new ArrayList<AttributeValue>();
            for (String value : values) {
                AttributeValue val = this.getValue(attributeName, value, type);
                list.add(val);
            }
        } else {
            list = at.getAllValues();
            list.removeAll(Arrays.asList(values));
        }
        if (list.isEmpty()) {
            LOGGER.log(Level.INFO, "Warning: no matching attribute value found for {0}={1}", new Object[]{attributeName, Arrays.toString(values)});
        }
        return list;
    }
}

