/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.InstanceWithConfidence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public abstract class TransducerSequenceConfidenceEstimator {
    private static Logger logger = MalletLogger.getLogger(TransducerSequenceConfidenceEstimator.class.getName());
    protected Transducer model;

    public TransducerSequenceConfidenceEstimator(Transducer model) {
        this.model = model;
    }

    public abstract double estimateConfidenceFor(Instance var1, Object[] var2, Object[] var3);

    public InstanceWithConfidence[] rankInstancesByConfidence(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        ArrayList<InstanceWithConfidence> confidenceList = new ArrayList<InstanceWithConfidence>();
        for (int i = 0; i < ilist.size(); ++i) {
            Instance instance = (Instance)ilist.get(i);
            Sequence<Object> predicted = new MaxLatticeDefault(this.model, (Sequence)instance.getData()).bestOutputSequence();
            double confidence = this.estimateConfidenceFor(instance, startTags, continueTags);
            confidenceList.add(new InstanceWithConfidence(instance, confidence, predicted));
            logger.info("instance#" + i + " confidence=" + confidence);
        }
        Collections.sort(confidenceList);
        InstanceWithConfidence[] ret = new InstanceWithConfidence[1];
        ret = confidenceList.toArray(ret);
        return ret;
    }
}

