/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.tasks.ResultPreviewListener;
import moa.tasks.TaskMonitor;

public class StandardTaskMonitor
implements TaskMonitor {
    protected String currentActivityDescription = "";
    protected double currentActivityFractionComplete = -1.0;
    protected volatile boolean cancelFlag = false;
    protected volatile boolean pauseFlag = false;
    protected volatile boolean isComplete = false;
    protected volatile boolean resultPreviewRequested = false;
    protected volatile Object latestResultPreview = null;
    protected volatile ResultPreviewListener resultPreviewer = null;

    public void setCurrentActivity(String activityDescription, double fracComplete) {
        this.setCurrentActivityDescription(activityDescription);
        this.setCurrentActivityFractionComplete(fracComplete);
    }

    public void setCurrentActivityDescription(String activity) {
        this.currentActivityDescription = activity;
    }

    public void setCurrentActivityFractionComplete(double fracComplete) {
        this.currentActivityFractionComplete = fracComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean taskShouldAbort() {
        if (this.pauseFlag) {
            try {
                StandardTaskMonitor standardTaskMonitor = this;
                synchronized (standardTaskMonitor) {
                    while (this.pauseFlag && !this.cancelFlag) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.cancelFlag;
    }

    public String getCurrentActivityDescription() {
        return this.currentActivityDescription;
    }

    public double getCurrentActivityFractionComplete() {
        return this.currentActivityFractionComplete;
    }

    public boolean isCancelled() {
        return this.cancelFlag;
    }

    public void requestCancel() {
        this.cancelFlag = true;
        this.requestResume();
    }

    public void requestPause() {
        this.pauseFlag = true;
    }

    public synchronized void requestResume() {
        this.pauseFlag = false;
        this.notify();
    }

    public boolean isPaused() {
        return this.pauseFlag;
    }

    public Object getLatestResultPreview() {
        return this.latestResultPreview;
    }

    public void requestResultPreview() {
        this.resultPreviewRequested = true;
    }

    public void requestResultPreview(ResultPreviewListener toInform) {
        this.resultPreviewer = toInform;
        this.resultPreviewRequested = true;
    }

    public boolean resultPreviewRequested() {
        return this.resultPreviewRequested;
    }

    public synchronized void setLatestResultPreview(Object latestPreview) {
        this.resultPreviewRequested = false;
        this.latestResultPreview = latestPreview;
        if (this.resultPreviewer != null) {
            this.resultPreviewer.latestPreviewChanged();
        }
        this.resultPreviewer = null;
    }
}

