/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DiagonalDoubleMatrix2D;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DenseDoubleSingularValueDecomposition {
    private DoubleMatrix2D U;
    private DoubleMatrix2D V;
    private DoubleMatrix2D S;
    private double[] elementsU;
    private double[] elementsVt;
    private double[] elementsS;
    private intW info;
    private int m;
    private int n;
    private int mn;
    private boolean wantWholeUV;
    private boolean wantUV;
    private boolean columnMatrix = false;

    public DenseDoubleSingularValueDecomposition(DoubleMatrix2D doubleMatrix2D, boolean bl, boolean bl2) {
        double[] dArray;
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        this.wantUV = bl;
        this.wantWholeUV = bl2;
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        if (doubleMatrix2D instanceof DenseColumnDoubleMatrix2D) {
            dArray = (double[])doubleMatrix2D.copy().elements();
            this.columnMatrix = true;
        } else {
            dArray = (double[])doubleMatrix2D.viewDice().copy().elements();
        }
        this.mn = Math.min(this.m, this.n);
        int n = Math.max(this.m, this.n);
        this.info = new intW(2);
        int[] nArray = new int[8 * this.mn];
        this.elementsS = new double[this.mn];
        bl = true;
        if (true) {
            if (bl2) {
                this.elementsU = new double[this.m * this.m];
                this.elementsVt = new double[this.n * this.n];
                int n2 = 3 * this.mn * this.mn + Math.max(n, 4 * this.mn * this.mn + 4 * this.mn) + n;
                double[] dArray2 = new double[n2];
                LAPACK.getInstance().dgesdd("A", this.m, this.n, dArray, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.n, dArray2, n2, nArray, this.info);
            } else {
                this.elementsU = new double[this.m * this.mn];
                this.elementsVt = new double[this.mn * this.n];
                int n3 = 3 * this.mn * this.mn + Math.max(n, 4 * this.mn * this.mn + 4 * this.mn) + n;
                double[] dArray3 = new double[n3];
                LAPACK.getInstance().dgesdd("S", this.m, this.n, dArray, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.mn, dArray3, n3, nArray, this.info);
            }
        } else {
            int n4 = 3 * this.mn + Math.max(n, 6 * this.mn) + n;
            double[] dArray4 = new double[n4];
            LAPACK.getInstance().dgesdd("N", this.m, this.n, dArray, this.m, this.elementsS, null, this.m, null, this.n, dArray4, n4, nArray, this.info);
        }
        if (this.info.val != 0) {
            throw new IllegalArgumentException("Error occured while computing SVD decomposition: " + this.info);
        }
    }

    public double cond() {
        return this.elementsS[0] / this.elementsS[this.mn - 1];
    }

    public DoubleMatrix2D getS() {
        if (this.S == null) {
            this.S = !this.wantWholeUV ? new DiagonalDoubleMatrix2D(this.mn, this.mn, 0) : new DiagonalDoubleMatrix2D(this.m, this.n, 0);
            for (int i = 0; i < this.mn; ++i) {
                this.S.setQuick(i, i, this.elementsS[i]);
            }
        }
        return this.S.copy();
    }

    public double[] getSingularValues() {
        return this.elementsS;
    }

    public DoubleMatrix2D getU() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix U was not computed");
        }
        if (this.U == null) {
            this.U = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.m, this.mn).assign(this.elementsU) : new DenseDoubleMatrix2D(this.mn, this.m).assign(this.elementsU).viewDice()) : (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.m, this.m).assign(this.elementsU) : new DenseDoubleMatrix2D(this.m, this.m).assign(this.elementsU).viewDice());
        }
        return this.U.copy();
    }

    public DoubleMatrix2D getV() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix V was not computed");
        }
        if (this.V == null) {
            this.V = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.mn, this.n).assign(this.elementsVt).viewDice() : new DenseDoubleMatrix2D(this.n, this.mn).assign(this.elementsVt)) : (this.columnMatrix ? new DenseColumnDoubleMatrix2D(this.n, this.n).assign(this.elementsVt).viewDice() : new DenseDoubleMatrix2D(this.n, this.n).assign(this.elementsVt));
        }
        return this.V.copy();
    }

    public intW getInfo() {
        return this.info;
    }

    public double norm2() {
        return this.elementsS[0];
    }

    public int rank() {
        double d = Math.pow(2.0, -52.0);
        double d2 = (double)Math.max(this.m, this.n) * this.elementsS[0] * d;
        int n = 0;
        for (int i = 0; i < this.elementsS.length; ++i) {
            if (!(this.elementsS[i] > d2)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

