/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.akf.AugmentedFilter;
import jdplus.toolkit.base.core.ssf.akf.AugmentedSmoother;
import jdplus.toolkit.base.core.ssf.akf.DefaultAugmentedFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.SmoothingOutput;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import lombok.Generated;

public final class QRSmoother {
    public static SmoothingOutput process(ISsf ssf, ISsfData data, boolean var, boolean rescale) {
        DefaultAugmentedFilteringResults fr2 = new DefaultAugmentedFilteringResults(true);
        fr2.prepare(ssf, 0, data.length());
        AugmentedFilter filter = new AugmentedFilter();
        if (!filter.process(ssf, data, fr2)) {
            return null;
        }
        int len = data.length();
        int n = data.getObsCount();
        int nd = ssf.getDiffuseDim();
        FastMatrix Xl = FastMatrix.make(n, nd);
        DataBlock yl = DataBlock.make(n);
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if (data.isMissing(i)) continue;
            double e = Math.sqrt(fr2.errorVariance(i));
            yl.set(j, fr2.error(i) / e);
            Xl.row(j).setAY(-1.0 / e, fr2.E(i));
            ++j;
        }
        QRLeastSquaresSolution ls = QRLeastSquaresSolver.robustLeastSquares((DoubleSeq)yl, Xl);
        FastMatrix psi = ls.RtR();
        SymmetricMatrix.lcholesky(psi);
        DoubleSeq delta = ls.getB();
        double sig2 = ls.getSsqErr() / (double)(n - nd);
        AugmentedSmoother smoother = new AugmentedSmoother();
        smoother.setCalcVariances(var);
        DefaultSmoothingResults rslts = var ? DefaultSmoothingResults.full() : DefaultSmoothingResults.light();
        rslts.prepare(ssf.getStateDim(), 0, len);
        smoother.process(ssf, len, fr2, psi, delta, rslts);
        if (rescale) {
            rslts.rescaleVariances(sig2);
        }
        return new SmoothingOutput(fr2, sig2, rslts);
    }

    @Generated
    private QRSmoother() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

