/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.ami;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.estimation.IArimaMapping;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;

class MultiPeriodicAirlineMapping
implements IArimaMapping<ArimaModel> {
    private final int[] periods;
    private final boolean stationary;
    private static final double UB = 0.999;

    public MultiPeriodicAirlineMapping(int[] periods) {
        this(periods, false);
    }

    public MultiPeriodicAirlineMapping(int[] periods, boolean stationary) {
        this.stationary = stationary;
        this.periods = (int[])periods.clone();
    }

    @Override
    public ArimaModel map(DoubleSeq p) {
        double th = p.get(0);
        double[] ma = new double[]{1.0, -th};
        BackFilter fma = BackFilter.ofInternal(ma);
        BackFilter fs = BackFilter.ONE;
        BackFilter fd = this.stationary ? BackFilter.ONE : BackFilter.D1;
        for (int i = 0; i < this.periods.length; ++i) {
            double[] dma = new double[this.periods[i] + 1];
            dma[0] = 1.0;
            dma[this.periods[i]] = -p.get(i + 1);
            if (!this.stationary) {
                double[] d = new double[this.periods[i] + 1];
                d[0] = 1.0;
                d[this.periods[i]] = -1.0;
                fd = fd.times(BackFilter.ofInternal(d));
            }
            fma = fma.times(BackFilter.ofInternal(dma));
        }
        return new ArimaModel(fs, fd, fma, 1.0);
    }

    @Override
    public DoubleSeq parametersOf(ArimaModel t) {
        BackFilter ma = t.getMa();
        double[] p = new double[this.periods.length + 1];
        p[0] = -ma.get(1);
        for (int i = 0; i < this.periods.length; ++i) {
            p[i + 1] = -ma.get(this.periods[i]);
        }
        return DoubleSeq.of((double[])p);
    }

    @Override
    public boolean checkBoundaries(DoubleSeq inparams) {
        return inparams.allMatch(x -> Math.abs(x) <= 0.999);
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        return inparams.get(idx) > 0.0 ? -1.0E-6 : 1.0E-6;
    }

    @Override
    public int getDim() {
        return this.periods.length + 1;
    }

    @Override
    public double lbound(int idx) {
        return -1.0;
    }

    @Override
    public double ubound(int idx) {
        return 1.0;
    }

    @Override
    public ParamValidation validate(DataBlock ioparams) {
        boolean changed = false;
        for (int i = 0; i < ioparams.length(); ++i) {
            double p = ioparams.get(i);
            if (Math.abs(p) > 1.001001001001001) {
                ioparams.set(i, 1.0 / p);
                changed = true;
                continue;
            }
            if (!(Math.abs(p) > 0.999)) continue;
            ioparams.set(i, p < 0.0 ? -0.999 : 0.999);
            changed = true;
        }
        return changed ? ParamValidation.Changed : ParamValidation.Valid;
    }

    @Override
    public String getDescription(int idx) {
        return "p" + idx;
    }

    @Override
    public DoubleSeq getDefaultParameters() {
        double[] p = new double[this.getDim()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = 0.2;
        }
        return DoubleSeq.of((double[])p);
    }

    @Override
    public IArimaMapping<ArimaModel> stationaryMapping() {
        return this.stationary ? this : new MultiPeriodicAirlineMapping(this.periods, true);
    }
}

