/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ml;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Random;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.ml.ExtendedIsolationForest;
import jdplus.toolkit.base.core.ml.IsolationForest;
import jdplus.toolkit.base.core.ml.XIsolationForest;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class IsolationForests {
    static final double EULER_CONSTANT = 0.5772156649;

    static double innerProduct(double[] X1, double[] X2) {
        double result = 0.0;
        for (int i = 0; i < X1.length; ++i) {
            result += X1[i] * X2[i];
        }
        return result;
    }

    static double cFactor(int N) {
        double Nd = N;
        double Ndc = Nd - 1.0;
        double result = 2.0 * (Math.log(Ndc) + 0.5772156649 - Ndc / Nd);
        return result;
    }

    @Deprecated
    static int[] sampleWithoutReplacementLegacy(int k, int N, boolean shuffle, Random rnd) {
        HashSet<Integer> samples = new HashSet<Integer>();
        for (int r = N - k; r < N; ++r) {
            int v = rnd.nextInt(r + 1);
            if (samples.add(v)) continue;
            samples.add(r);
        }
        int[] result = new int[k];
        int i = 0;
        for (Integer j : samples) {
            result[i++] = j;
        }
        if (shuffle) {
            for (int j = 0; j < k; ++j) {
                int idx = rnd.nextInt(k);
                if (idx == j) continue;
                int tmp = result[j];
                result[j] = result[idx];
                result[idx] = tmp;
            }
        }
        return result;
    }

    static int[] sampleWithoutReplacement(int k, int N, boolean shuffle, Random rnd) {
        int[] sample = new int[k];
        BitSet flags = new BitSet(N);
        int i = 0;
        int r = N - k;
        while (r < N) {
            int v = rnd.nextInt(r + 1);
            if (flags.get(v)) {
                flags.set(r);
                sample[i] = r;
            } else {
                flags.set(v);
                sample[i] = v;
            }
            ++r;
            ++i;
        }
        if (shuffle) {
            for (int j = 0; j < k; ++j) {
                int idx = rnd.nextInt(k);
                if (idx == j) continue;
                int tmp = sample[j];
                sample[j] = sample[idx];
                sample[idx] = tmp;
            }
        }
        return sample;
    }

    public static double findPath(Node node, DoubleSeq x) {
        if (node.isFinal()) {
            int size = node.size();
            switch (size) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return 1.0;
                }
            }
            return 1.0 + IsolationForests.cFactor(size);
        }
        return 1.0 + IsolationForests.findPath(node.branch(x), x);
    }

    @Generated
    private IsolationForests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface Node {
        default public boolean isFinal() {
            return false;
        }

        public int size();

        public Node branch(DoubleSeq var1);

        public Node left();

        public Node right();
    }

    public static class Forest {
        @NonNull
        final Matrix X;
        int limit;
        Node[] trees;
        double c;
        TreeBuilder treeBuilder;
        final Random rnd;

        public void fit(int ntrees, int sampleSize) {
            int climit = this.limit <= 0 ? (int)Math.ceil(Math.log(sampleSize) / Math.log(2.0)) : this.limit;
            this.c = IsolationForests.cFactor(sampleSize);
            this.trees = new Node[ntrees];
            if (sampleSize < this.X.getColumnsCount()) {
                for (int i = 0; i < ntrees; ++i) {
                    int[] sample = IsolationForests.sampleWithoutReplacement(sampleSize, this.X.getColumnsCount(), false, this.rnd);
                    IntList selection = new IntList(sampleSize);
                    for (int j = 0; j < sample.length; ++j) {
                        selection.add(sample[j]);
                    }
                    this.trees[i] = this.treeBuilder.root(this.X, selection.toArray(), climit, this.rnd);
                }
            } else {
                for (int i = 0; i < ntrees; ++i) {
                    this.trees[i] = this.treeBuilder.root(this.X, null, climit, this.rnd);
                }
            }
        }

        public double[] predict(Matrix x) {
            Matrix z = x == null ? this.X : x;
            int size = z.getColumnsCount();
            double[] S = new double[size];
            for (int i = 0; i < size; ++i) {
                DoubleSeq cur = z.column(i);
                double htemp = 0.0;
                for (Node root : this.trees) {
                    htemp += IsolationForests.findPath(root, cur);
                }
                double havg = htemp / (double)this.trees.length;
                S[i] = Math.pow(2.0, -havg / this.c);
            }
            return S;
        }

        @Generated
        public static @org.jspecify.annotations.NonNull Builder builder() {
            return new Builder();
        }

        @NonNull
        @Generated
        public Matrix getX() {
            return this.X;
        }

        @Generated
        public int getLimit() {
            return this.limit;
        }

        @Generated
        public Node[] getTrees() {
            return this.trees;
        }

        @Generated
        public double getC() {
            return this.c;
        }

        @Generated
        public TreeBuilder getTreeBuilder() {
            return this.treeBuilder;
        }

        @Generated
        public Random getRnd() {
            return this.rnd;
        }

        @Generated
        public void setLimit(int limit) {
            this.limit = limit;
        }

        @Generated
        public void setTrees(Node[] trees) {
            this.trees = trees;
        }

        @Generated
        public void setC(double c) {
            this.c = c;
        }

        @Generated
        public void setTreeBuilder(TreeBuilder treeBuilder) {
            this.treeBuilder = treeBuilder;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Forest)) {
                return false;
            }
            Forest other = (Forest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            if (Double.compare(this.getC(), other.getC()) != 0) {
                return false;
            }
            Matrix this$X = this.getX();
            Matrix other$X = other.getX();
            if (this$X == null ? other$X != null : !this$X.equals(other$X)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getTrees(), other.getTrees())) {
                return false;
            }
            TreeBuilder this$treeBuilder = this.getTreeBuilder();
            TreeBuilder other$treeBuilder = other.getTreeBuilder();
            if (this$treeBuilder == null ? other$treeBuilder != null : !this$treeBuilder.equals(other$treeBuilder)) {
                return false;
            }
            Random this$rnd = this.getRnd();
            Random other$rnd = other.getRnd();
            return !(this$rnd == null ? other$rnd != null : !this$rnd.equals(other$rnd));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Forest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLimit();
            long $c = Double.doubleToLongBits(this.getC());
            result = result * 59 + (int)($c >>> 32 ^ $c);
            Matrix $X = this.getX();
            result = result * 59 + ($X == null ? 43 : $X.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getTrees());
            TreeBuilder $treeBuilder = this.getTreeBuilder();
            result = result * 59 + ($treeBuilder == null ? 43 : $treeBuilder.hashCode());
            Random $rnd = this.getRnd();
            result = result * 59 + ($rnd == null ? 43 : $rnd.hashCode());
            return result;
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "IsolationForests.Forest(X=" + String.valueOf(this.getX()) + ", limit=" + this.getLimit() + ", trees=" + Arrays.deepToString(this.getTrees()) + ", c=" + this.getC() + ", treeBuilder=" + String.valueOf(this.getTreeBuilder()) + ", rnd=" + String.valueOf(this.getRnd()) + ")";
        }

        @Generated
        private Forest(@NonNull Matrix X, int limit, Node[] trees, double c, TreeBuilder treeBuilder, Random rnd) {
            if (X == null) {
                throw new NullPointerException("X is marked non-null but is null");
            }
            this.X = X;
            this.limit = limit;
            this.trees = trees;
            this.c = c;
            this.treeBuilder = treeBuilder;
            this.rnd = rnd;
        }

        public static class Builder {
            @Generated
            private Matrix X;
            @Generated
            private int limit;
            @Generated
            private Node[] trees;
            @Generated
            private double c;
            @Generated
            private TreeBuilder treeBuilder;
            @Generated
            private Random rnd;

            public Forest build() {
                if (this.X == null) {
                    throw new IllegalArgumentException();
                }
                Random brnd = this.rnd == null ? new Random() : this.rnd;
                return new Forest(this.X, this.limit, null, this.c, this.treeBuilder, brnd);
            }

            @Generated
            Builder() {
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder X(@NonNull Matrix X) {
                if (X == null) {
                    throw new NullPointerException("X is marked non-null but is null");
                }
                this.X = X;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder limit(int limit) {
                this.limit = limit;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder trees(Node[] trees) {
                this.trees = trees;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder c(double c) {
                this.c = c;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder treeBuilder(TreeBuilder treeBuilder) {
                this.treeBuilder = treeBuilder;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder rnd(Random rnd) {
                this.rnd = rnd;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull String toString() {
                return "IsolationForests.Forest.Builder(X=" + String.valueOf(this.X) + ", limit=" + this.limit + ", trees=" + Arrays.deepToString(this.trees) + ", c=" + this.c + ", treeBuilder=" + String.valueOf(this.treeBuilder) + ", rnd=" + String.valueOf(this.rnd) + ")";
            }
        }
    }

    @FunctionalInterface
    public static interface TreeBuilder {
        public Node root(Matrix var1, int[] var2, double var3, Random var5);

        public static TreeBuilder legacy() {
            return IsolationForest.BUILDER;
        }

        public static TreeBuilder extended(int extensionLevel) {
            return ExtendedIsolationForest.builder(extensionLevel);
        }

        public static TreeBuilder smooth() {
            return XIsolationForest.BUILDER;
        }
    }

    public static class FinalNode
    implements Node {
        private final int size;
        private static final Node ZERO = new FinalNode(0);
        private static final Node ONE = new FinalNode(1);

        public FinalNode(int size) {
            this.size = size;
        }

        public static Node of(int size) {
            switch (size) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
            return new FinalNode(size);
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Node branch(DoubleSeq x) {
            return null;
        }

        @Override
        public Node left() {
            return null;
        }

        @Override
        public Node right() {
            return null;
        }
    }
}

