/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.highfreq;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;

public enum DataCleaning {
    NONE,
    SUNDAYS,
    WEEKENDS;


    public static DataCleaning of(TsData data) {
        boolean bsun;
        TsPeriod start = data.getStart();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            return NONE;
        }
        int pos = start.start().getDayOfWeek().getValue();
        int n = data.length();
        if (n < 7) {
            return NONE;
        }
        int sun = 7 - pos;
        int sat = 6 - pos;
        if (sat < 0) {
            sat = 6;
        }
        if (!(bsun = data.getValues().extract(sun, (n - sun) / 7, 7).allMatch(x -> Double.isNaN(x)))) {
            return NONE;
        }
        boolean bsat = data.getValues().extract(sat, (n - sat) / 7, 7).allMatch(x -> Double.isNaN(x));
        return bsat ? WEEKENDS : SUNDAYS;
    }

    public double updatePeriodicity(double p) {
        return switch (this.ordinal()) {
            case 1 -> p / 7.0 * 6.0;
            case 2 -> p / 7.0 * 5.0;
            default -> p;
        };
    }

    public double[] updatePeriodicities(double[] p) {
        double[] np = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            np[i] = this.updatePeriodicity(p[i]);
        }
        return np;
    }

    public TsData expand(TsDomain domain, DoubleSeq data) {
        return switch (this.ordinal()) {
            case 1 -> DataCleaning.withMissingSundays(domain, data);
            case 2 -> DataCleaning.withMissingWeekEnds(domain, data);
            default -> TsData.of(domain.getStartPeriod(), data);
        };
    }

    public static TsData withMissingSundays(TsDomain domain, DoubleSeq data) {
        double[] tmp = new double[domain.length()];
        TsPeriod start = domain.getStartPeriod();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            throw new UnsupportedOperationException();
        }
        int pos = start.start().getDayOfWeek().getValue();
        int out = 0;
        int in = 0;
        int n = data.length();
        DoubleSeqCursor cursor = data.cursor();
        while (in < n && out < tmp.length) {
            if (pos != 7) {
                tmp[out++] = cursor.getAndNext();
                ++in;
                ++pos;
                continue;
            }
            tmp[out++] = Double.NaN;
            pos = 1;
        }
        while (out < tmp.length) {
            tmp[out++] = Double.NaN;
        }
        return TsData.ofInternal(start, tmp);
    }

    public static TsData withMissingWeekEnds(TsDomain domain, DoubleSeq data) {
        double[] tmp = new double[domain.length()];
        TsPeriod start = domain.getStartPeriod();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            throw new UnsupportedOperationException();
        }
        int pos = start.start().getDayOfWeek().getValue();
        int out = 0;
        int in = 0;
        int n = data.length();
        DoubleSeqCursor cursor = data.cursor();
        if (pos == 7) {
            tmp[out++] = Double.NaN;
            pos = 1;
        }
        while (in < n && out < tmp.length) {
            if (pos != 6) {
                tmp[out++] = cursor.getAndNext();
                ++in;
                ++pos;
                continue;
            }
            tmp[out++] = Double.NaN;
            tmp[out++] = Double.NaN;
            pos = 1;
        }
        while (out < tmp.length) {
            tmp[out++] = Double.NaN;
        }
        return TsData.ofInternal(start, tmp);
    }

    public int clean(TsData data, DoubleSeq.Mutable out) {
        return switch (this.ordinal()) {
            case 1 -> DataCleaning.cleanSundays(data, out);
            case 2 -> DataCleaning.cleanWeekEnds(data, out);
            default -> DataCleaning.set(data, out);
        };
    }

    public static int cleanSundays(TsData data, DoubleSeq.Mutable out) {
        TsPeriod start = data.getStart();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            throw new UnsupportedOperationException();
        }
        int pos = start.start().getDayOfWeek().getValue();
        DoubleSeqCursor cursor = data.getValues().cursor();
        DoubleSeqCursor.OnMutable ocursor = out.cursor();
        int nin = data.length();
        int nout = 0;
        for (int i = 0; i < nin; ++i) {
            if (pos != 7) {
                ocursor.setAndNext(cursor.getAndNext());
                ++pos;
                ++nout;
                continue;
            }
            cursor.skip(1);
            pos = 1;
        }
        return nout;
    }

    public static int set(TsData data, DoubleSeq.Mutable out) {
        DoubleSeqCursor cursor = data.getValues().cursor();
        DoubleSeqCursor.OnMutable ocursor = out.cursor();
        int nin = data.length();
        for (int i = 0; i < nin; ++i) {
            ocursor.setAndNext(cursor.getAndNext());
        }
        return nin;
    }

    public static int cleanWeekEnds(TsData data, DoubleSeq.Mutable out) {
        TsPeriod start = data.getStart();
        if (!start.getUnit().equals(TsUnit.P1D)) {
            throw new UnsupportedOperationException();
        }
        int pos = start.start().getDayOfWeek().getValue();
        int i = 0;
        DoubleSeqCursor cursor = data.getValues().cursor();
        DoubleSeqCursor.OnMutable ocursor = out.cursor();
        int nin = data.length();
        int nout = 0;
        if (pos == 7) {
            cursor.skip(1);
            pos = 1;
            i = 1;
        }
        while (i < nin) {
            if (pos != 6) {
                ocursor.setAndNext(cursor.getAndNext());
                ++pos;
                ++i;
                ++nout;
                continue;
            }
            cursor.skip(2);
            pos = 1;
            i += 2;
        }
        return nout;
    }
}

