/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.Map;
import java.util.function.Function;
import jdplus.toolkit.base.api.information.BasicInformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractors;
import jdplus.toolkit.base.api.util.WildCards;

public abstract class InformationDelegate<S, T>
implements InformationExtractor<S> {
    private final Function<S, T> fn;

    public abstract Class<T> getDelegateClass();

    public InformationDelegate(Function<S, T> fn) {
        this.fn = fn;
    }

    @Override
    public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
        InformationExtractors.fillDictionary(this.getDelegateClass(), BasicInformationExtractor.concatenate(prefix, null), dic, compact);
    }

    @Override
    public boolean contains(String id) {
        return InformationExtractors.contains(this.getDelegateClass(), id);
    }

    @Override
    public <Q> Q getData(S source, String id, Class<Q> qclass) {
        if (source == null) {
            return null;
        }
        T t = this.fn.apply(source);
        if (t == null) {
            return null;
        }
        return InformationExtractors.getData(this.getDelegateClass(), t, id, qclass);
    }

    @Override
    public <Q> void searchAll(S source, WildCards wc, Class<Q> tclass, Map<String, Q> map) {
        InformationExtractors.searchAll(this.getDelegateClass(), this.fn.apply(source), wc, tclass, map);
    }
}

