/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.Comparator;
import lombok.Generated;

public final class Information<S> {
    private final String name;
    private final S value;
    private final long index;

    public Information(String name, S value) {
        this.name = name;
        this.value = value;
        this.index = -1L;
    }

    Information(String name, S value, long index) {
        this.name = name;
        this.value = value;
        this.index = index;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public S getValue() {
        return this.value;
    }

    @Generated
    public long getIndex() {
        return this.index;
    }

    public static class IndexedNameSorter
    implements Comparator<Information<?>> {
        private final String prefix;
        private final int start;

        public IndexedNameSorter(String prefix) {
            this.prefix = prefix;
            this.start = prefix.length();
        }

        @Override
        public int compare(Information<?> o1, Information<?> o2) {
            try {
                if (o1.name.startsWith(this.prefix) && o2.name.startsWith(this.prefix)) {
                    int i1 = Integer.parseInt(o1.name.substring(this.start));
                    int i2 = Integer.parseInt(o2.name.substring(this.start));
                    return Integer.compare(i1, i2);
                }
                return o1.name.compareTo(o2.name);
            }
            catch (Exception err) {
                return o1.name.compareTo(o2.name);
            }
        }
    }

    public static class NameSorter
    implements Comparator<Information<?>> {
        @Override
        public int compare(Information<?> o1, Information<?> o2) {
            return o1.name.compareTo(o2.name);
        }
    }
}

